/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.wizard.core.view;

import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.wizard.core.controller.RiderWizardController;
import com.jetbrains.rider.wizard.steps.base.RiderWizardStepModel;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/wizard/core/view/NavBarItemSimple;", "Lcom/intellij/ui/SimpleColoredComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "controller", "Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;", "model", "Lcom/jetbrains/rider/wizard/steps/base/RiderWizardStepModel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;Lcom/jetbrains/rider/wizard/steps/base/RiderWizardStepModel;)V", "getController", "()Lcom/jetbrains/rider/wizard/core/controller/RiderWizardController;", "j", "Ljavax/swing/Icon;", "j", "", "isSelected", "", "isFirst", "updateUI", "intellij.rider"})
final class NavBarItemSimple
extends SimpleColoredComponent {
    @NotNull
    private final RiderWizardController controller;
    @NotNull
    private final RiderWizardStepModel model;

    public NavBarItemSimple(@NotNull Lifetime lifetime2, @NotNull RiderWizardController controller, @NotNull RiderWizardStepModel model2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.controller = controller;
        this.model = model2;
        this.setIpad((Insets)JBInsets.emptyInsets());
        this.model.isFirst().advise(lifetime2, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean isFirst) {
                this.j((Boolean)model.isSelected().getValue(), isFirst);
            }
        });
        this.model.isSelected().advise(lifetime2, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean isSelected) {
                this.j(isSelected, (Boolean)model.isFirst().getValue());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@Nullable MouseEvent e) {
                if (!((Boolean)model.isSelected().getValue()).booleanValue()) {
                    this.getController().move(model);
                }
            }
        });
    }

    @NotNull
    public final RiderWizardController getController() {
        return this.controller;
    }

    private final void j(boolean bl, boolean bl2) {
        this.clear();
        Color color = bl ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        if (!bl2) {
            this.setIcon(this.j());
        }
        this.append(this.model.getNavigationName(), new SimpleTextAttributes(null, color2, null, 1));
    }

    public void updateUI() {
        super.updateUI();
        if (this.getIcon() == null) {
            return;
        }
        this.setIcon(this.j());
    }

    private final Icon j() {
        Icon icon2;
        if (!StartupUiUtil.isUnderDarcula()) {
            Icon icon3 = AllIcons.General.ChevronRight;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ChevronRight");
            Color color = UIUtil.getLabelDisabledForeground().brighter().brighter();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
            icon2 = IconUtil.colorize$default((Icon)icon3, (Color)color, (boolean)false, (int)4, null);
        } else {
            Icon icon4 = AllIcons.General.ChevronRight;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ChevronRight");
            Color color = UIUtil.getLabelDisabledForeground().brighter();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"brighter(...)");
            icon2 = IconUtil.colorize$default((Icon)icon4, (Color)color, (boolean)false, (int)4, null);
        }
        return icon2;
    }
}

