/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.viewer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.RiderBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 #2\u00020\u0001:\u0003#$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000bJ \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eJ\u001d\u0010\u001f\u001a\u00020\u00132\r\u0010 \u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b!2\u0006\u0010\"\u001a\u00020\u0018R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activated", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getActivated", "()Lcom/jetbrains/rd/util/reactive/Property;", "ilViewerToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getIlViewerToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "loadingLabelText", "", "panelLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "activateToolwindow", "", "activeBackend", "toolWindow", "j", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "panel", "Ljavax/swing/JPanel;", "createIlViewer", "viewerLifetime", "editor", "Lcom/intellij/openapi/editor/Editor;", "showUnavailabilityLabel", "reason", "Lorg/jetbrains/annotations/Nls;", "reasonLifetime", "Companion", "IlViewerPanel", "UnavailabilityLabel", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nIlViewerHostUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n13#2:139\n13#3:140\n*S KotlinDebug\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi\n*L\n40#1:139\n40#1:140\n*E\n"})
public final class IlViewerHostUi
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Property<Boolean> activated;
    @NotNull
    private final SequentialLifetimes panelLifetimes;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String loadingLabelText;
    @NotNull
    private static final Logger logger;

    public IlViewerHostUi(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.activated = new Property((Object)false);
        this.panelLifetimes = new SequentialLifetimes(this.getServiceLifetime());
        this.loadingLabelText = RiderBundle.message("label.loading", new Object[0]);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = this.getIlViewerToolWindow();
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                boolean bl = toolWindow2.isVisible();
                this.getActivated().set((Object)bl);
            }
        });
    }

    @NotNull
    public final Property<Boolean> getActivated() {
        return this.activated;
    }

    @Nullable
    public final ToolWindow getIlViewerToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.project).getToolWindow("IL");
    }

    public final void activeBackend(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.activated.set((Object)true);
        this.j(Lifetime.Companion.getEternal(), toolWindow, new UnavailabilityLabel(this.loadingLabelText));
    }

    public final void activateToolwindow() {
        block0: {
            ToolWindow toolWindow = this.getIlViewerToolWindow();
            if (toolWindow == null) break block0;
            toolWindow.activate(null);
        }
    }

    public final void showUnavailabilityLabel(@Nullable String reason, @NotNull Lifetime reasonLifetime) {
        Intrinsics.checkNotNullParameter((Object)reasonLifetime, (String)"reasonLifetime");
        ToolWindow toolWindow = this.getIlViewerToolWindow();
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        logger.debug("showing unavailability reason: " + reason + " ");
        this.j(reasonLifetime, toolWindow2, new UnavailabilityLabel(reason));
    }

    public final void createIlViewer(@NotNull Lifetime viewerLifetime, @NotNull Editor editor2) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)viewerLifetime, (String)"viewerLifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        logger.debug("showing IL viewer editor");
        editor2.getSettings().setLineNumbersShown(false);
        editor2.getSettings().setGutterIconsShown(false);
        editor2.getSettings().setRightMarginShown(false);
        if (editor2 instanceof EditorEx && (toolWindow = FileDocumentManager.getInstance().getFile((Document)((EditorEx)editor2).getDocument())) != null) {
            EditorColorsScheme editorColorsScheme = ((EditorEx)editor2).createBoundColorSchemeDelegate(EditorColorsUtil.getGlobalOrDefaultColorScheme());
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"createBoundColorSchemeDelegate(...)");
            EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
            ((EditorEx)editor2).setColorsScheme(editorColorsScheme2);
            ((EditorEx)editor2).setHighlighter(EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter((VirtualFile)toolWindow, editorColorsScheme2, this.project));
        }
        ToolWindow toolWindow2 = this.getIlViewerToolWindow();
        if (toolWindow2 == null) {
            return;
        }
        toolWindow = toolWindow2;
        this.j(viewerLifetime, toolWindow, (JPanel)((Object)new IlViewerPanel(editor2)));
    }

    private final void j(Lifetime lifetime2, ToolWindow toolWindow, JPanel jPanel) {
        Lifetime lifetime3 = RLifetimeKt.intersect((Lifetime)((Lifetime)this.panelLifetimes.next()), (Lifetime)lifetime2);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content2 = contentManager2.getFactory().createContent((JComponent)jPanel, "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        lifetime3.bracketIfAlive((Function0)new Function0<Unit>(contentManager2, content3){
            final /* synthetic */ ContentManager $contentManager;
            final /* synthetic */ Content $content;
            {
                this.$contentManager = $contentManager;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                this.$contentManager.addContent(this.$content);
            }
        }, (Function0)new Function0<Unit>(contentManager2, content3){
            final /* synthetic */ ContentManager $contentManager;
            final /* synthetic */ Content $content;
            {
                this.$contentManager = $contentManager;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                this.$contentManager.removeContent(this.$content, true);
            }
        });
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(IlViewerHostUi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/viewer/IlViewerHostUi;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nIlViewerHostUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n31#2,2:139\n*S KotlinDebug\n*F\n+ 1 IlViewerHostUi.kt\ncom/jetbrains/rider/viewer/IlViewerHostUi$Companion\n*L\n38#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IlViewerHostUi getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<IlViewerHostUi> clazz = IlViewerHostUi.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (IlViewerHostUi)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi$IlViewerPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "j", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "dispose", "", "intellij.rider"})
    public static final class IlViewerPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private final Editor editor;

        public IlViewerPanel(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(true, true);
            this.editor = editor2;
            logger.debug("creating panel for " + this.editor);
            this.setToolbar(this.j().getComponent());
            this.setContent(this.editor.getComponent());
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        private final ActionToolbar j() {
            AnAction anAction = ActionManager.getInstance().getAction("RiderIlViewerToolbar");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup actionGroup2 = (ActionGroup)anAction;
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("IlViewerToolbar", actionGroup2, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar actionToolbar2 = actionToolbar;
            actionToolbar2.setTargetComponent(this.editor.getComponent());
            return actionToolbar2;
        }

        public void dispose() {
            if (!this.editor.isDisposed()) {
                logger.debug("disposing panel for " + this.editor);
                EditorFactory.getInstance().releaseEditor(this.editor);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/viewer/IlViewerHostUi$UnavailabilityLabel;", "Ljavax/swing/JPanel;", "reason", "", "(Ljava/lang/String;)V", "intellij.rider"})
    public static final class UnavailabilityLabel
    extends JPanel {
        public UnavailabilityLabel(@NlsContexts.Label @Nullable String reason) {
            super(new GridBagLayout());
            this.add((Component)new JLabel(reason), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.getInsets(), 0, 0));
        }
    }
}

