/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils.registryUtils.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.utils.registryUtils.IRegistryKey;
import com.jetbrains.rider.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.List;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J&\u0010\u0010\u001a \u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0003H\u0016JG\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0018\"\u00020\u00032\u001c\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u00160\u001aj\b\u0012\u0004\u0012\u0002H\u0016`\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/utils/registryUtils/impl/RegistryKey;", "Lcom/jetbrains/rider/utils/registryUtils/IRegistryKey;", "key", "", "registryRoot", "Lcom/jetbrains/rider/utils/registryUtils/impl/RegistryRoot;", "(Ljava/lang/String;Lcom/jetbrains/rider/utils/registryUtils/impl/RegistryRoot;)V", "getKey", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getKeys", "", "kotlin.jvm.PlatformType", "getStringValue", "value", "getValues", "Ljava/util/TreeMap;", "", "inChild", "child", "j", "T", "args", "", "action", "Lkotlin/Function1;", "Lcom/sun/jna/platform/win32/WinReg$HKEY;", "Lcom/jetbrains/rider/utils/registryUtils/impl/WinRegAction;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withSuffix", "suffix", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRegistryRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryRoot.kt\ncom/jetbrains/rider/utils/registryUtils/impl/RegistryKey\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n13#3:69\n*S KotlinDebug\n*F\n+ 1 RegistryRoot.kt\ncom/jetbrains/rider/utils/registryUtils/impl/RegistryKey\n*L\n15#1:68\n15#1:69\n*E\n"})
public final class RegistryKey
implements IRegistryKey {
    @NotNull
    private final String key;
    @NotNull
    private final RegistryRoot registryRoot;
    @NotNull
    private final Logger logger;

    public RegistryKey(@NotNull String key2, @NotNull RegistryRoot registryRoot) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)registryRoot, (String)"registryRoot");
        this.key = key2;
        this.registryRoot = registryRoot;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RegistryKey.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public IRegistryKey withSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new RegistryKey(this.key + suffix, this.registryRoot);
    }

    @Override
    @NotNull
    public IRegistryKey inChild(@NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return new RegistryKey(this.key + "\\" + child, this.registryRoot);
    }

    @Override
    @Nullable
    public String getStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String[] stringArray = new String[]{this.key, value};
        return (String)this.j(stringArray, (Function1)new Function1<WinReg.HKEY, String>(this, value){
            final /* synthetic */ RegistryKey this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Advapi32Util.registryKeyExists((WinReg.HKEY)it, (String)this.this$0.getKey())) {
                    return null;
                }
                return Advapi32Util.registryGetStringValue((WinReg.HKEY)it, (String)this.this$0.getKey(), (String)this.$value);
            }
        });
    }

    @Override
    @Nullable
    public List<String> getKeys() {
        String[] stringArray = new String[]{this.key};
        Object[] objectArray = (String[])this.j(stringArray, (Function1)new Function1<WinReg.HKEY, String[]>(this){
            final /* synthetic */ RegistryKey this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String[] invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Advapi32Util.registryGetKeys((WinReg.HKEY)it, (String)this.this$0.getKey());
            }
        });
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    @Nullable
    public TreeMap<String, Object> getValues() {
        String[] stringArray = new String[]{this.key};
        return (TreeMap)this.j(stringArray, (Function1)new Function1<WinReg.HKEY, TreeMap<String, Object>>(this){
            final /* synthetic */ RegistryKey this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final TreeMap<String, Object> invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Advapi32Util.registryGetValues((WinReg.HKEY)it, (String)this.this$0.getKey());
            }
        });
    }

    private final <T> T j(String[] stringArray, Function1<? super WinReg.HKEY, ? extends T> function1) {
        return this.registryRoot.executeWithHKEY((Function1)new Function1<WinReg.HKEY, T>(function1, this, stringArray){
            final /* synthetic */ Function1<WinReg.HKEY, T> $action;
            final /* synthetic */ RegistryKey this$0;
            final /* synthetic */ String[] $args;
            {
                this.$action = $action;
                this.this$0 = $receiver;
                this.$args = $args;
                super(1);
            }

            @Nullable
            public final T invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    return (T)this.$action.invoke((Object)it);
                }
                catch (Win32Exception win32Exception) {
                    RegistryKey.access$getLogger$p(this.this$0).info("registry arguments: " + ArraysKt.joinToString$default((Object[])this.$args, null, null, null, (int)0, null, null, (int)63, null));
                    RegistryKey.access$getLogger$p(this.this$0).warn("Failed to work with registry", (Throwable)win32Exception);
                    return null;
                }
            }
        });
    }

    public static final /* synthetic */ Logger access$getLogger$p(RegistryKey $this) {
        return $this.logger;
    }
}

