/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils.registryUtils.impl;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.utils.registryUtils.WindowsRegistryErrorTypes;
import com.jetbrains.rider.utils.registryUtils.WindowsRegistryException;
import com.jetbrains.rider.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/utils/registryUtils/impl/PrivateRegistryRoot;", "Lcom/jetbrains/rider/utils/registryUtils/impl/RegistryRoot;", "file", "Ljava/io/File;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Ljava/io/File;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "Companion", "intellij.rider"})
public final class PrivateRegistryRoot
extends RegistryRoot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private static final Map<File, PrivateRegistryRoot> openedRegFiles = new LinkedHashMap();

    private PrivateRegistryRoot(File file2, Lifetime lifetime2) {
        super(PrivateRegistryRoot.Companion.j(file2), lifetime2);
        this.file = file2;
        lifetime2.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                openedRegFiles.remove(file);
            }
        });
    }

    public /* synthetic */ PrivateRegistryRoot(File file2, Lifetime lifetime2, DefaultConstructorMarker $constructor_marker) {
        this(file2, lifetime2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/utils/registryUtils/impl/PrivateRegistryRoot$Companion;", "", "()V", "openedRegFiles", "", "Ljava/io/File;", "Lcom/jetbrains/rider/utils/registryUtils/impl/PrivateRegistryRoot;", "getOrCreate", "file", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "j", "", "winCode", "", "j", "Lcom/sun/jna/platform/win32/WinReg$HKEY;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nPrivateRegistryRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateRegistryRoot.kt\ncom/jetbrains/rider/utils/registryUtils/impl/PrivateRegistryRoot$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,60:1\n372#2,7:61\n*S KotlinDebug\n*F\n+ 1 PrivateRegistryRoot.kt\ncom/jetbrains/rider/utils/registryUtils/impl/PrivateRegistryRoot$Companion\n*L\n14#1:61,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateRegistryRoot getOrCreate(@NotNull File file2, @NotNull Lifetime lifetime2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Map map2 = openedRegFiles;
            boolean bl = false;
            Object v2 = map2.get(file2);
            if (v2 == null) {
                boolean bl2 = false;
                PrivateRegistryRoot privateRegistryRoot = new PrivateRegistryRoot(file2, lifetime2, null);
                map2.put(file2, privateRegistryRoot);
                object = privateRegistryRoot;
            } else {
                object = v2;
            }
            return (PrivateRegistryRoot)object;
        }

        private final String j(int n2) {
            return switch (n2) {
                case 32 -> "The process cannot access the file because it is being used by another process.";
                case 33 -> "The process cannot access the file because another process has locked a portion of the file.";
                case 123 -> "The filename, directory name, or volume label syntax is incorrect.";
                case 0 -> "Operation completed successfully.";
                default -> "Unknown Windows error: " + n2;
            };
        }

        private final WinReg.HKEY j(File file2) {
            WinReg.HKEYByReference hKEYByReference;
            try {
                hKEYByReference = Advapi32Util.registryLoadAppKey((String)file2.getAbsolutePath(), (int)983103, (int)0);
            }
            catch (Win32Exception win32Exception) {
                throw new WindowsRegistryException(this.j(win32Exception.getErrorCode()), WindowsRegistryErrorTypes.CORRUPTED);
            }
            WinReg.HKEYByReference hKEYByReference2 = hKEYByReference;
            try {
                int n2 = Advapi32Util.registryQueryInfoKey((WinReg.HKEY)hKEYByReference2.getValue(), (int)0).lpcMaxSubKeyLen.getValue();
                if (n2 == 0) {
                    throw new WindowsRegistryException("lpcMaxSubKeyLen == 0, possibly a bad file", WindowsRegistryErrorTypes.CORRUPTED);
                }
            }
            catch (Win32Exception win32Exception) {
                throw new WindowsRegistryException("Failed to query info key, registry is corrupted", WindowsRegistryErrorTypes.CORRUPTED);
            }
            WinReg.HKEY hKEY = hKEYByReference2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"getValue(...)");
            return hKEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

