/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.trees.nodes;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.ui.Queryable;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdUnitTestNodeDescriptorBase;
import com.jetbrains.rider.model.RdUnitTestSessionNodeDescriptor;
import com.jetbrains.rider.unitTesting.RiderUnitTestExtensionsKt;
import com.jetbrains.rider.unitTesting.RiderUnitTestingBundle;
import com.jetbrains.rider.unitTesting.diagnostics.RiderUnitTestDiagnostics;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeDescriptor;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeSessionDescriptor;
import com.jetbrains.rider.unitTesting.trees.nodes.RiderUnitTestNodeBase;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u000f\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0019\u0010\u0015\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/unitTesting/trees/nodes/RiderUnitTestNode;", "Lcom/jetbrains/rider/unitTesting/trees/nodes/RiderUnitTestNodeBase;", "treeDescriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "id", "", "(Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;I)V", "getId", "()Ljava/lang/Integer;", "canNavigate", "", "canNavigateToSource", "getTestPresentation", "", "Lcom/intellij/openapi/util/NlsSafe;", "getTextForCompare", "navigate", "", "requestFocus", "showLoadingNode", "toString", "toTestString", "printInfo", "Lcom/intellij/openapi/ui/Queryable$PrintInfo;", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "j", "Ljavax/swing/Icon;", "Lcom/jetbrains/rider/model/RdUnitTestNodeDescriptorBase;", "intellij.rider"})
public final class RiderUnitTestNode
extends RiderUnitTestNodeBase {
    private final int id;

    public RiderUnitTestNode(@NotNull RiderUnitTestTreeDescriptor treeDescriptor, int id2) {
        Intrinsics.checkNotNullParameter((Object)treeDescriptor, (String)"treeDescriptor");
        super(treeDescriptor, id2);
        this.id = id2;
    }

    @Override
    @NotNull
    public Integer getId() {
        return this.id;
    }

    @Override
    protected boolean showLoadingNode() {
        return true;
    }

    protected void update(@NotNull PresentationData presentation2) {
        String string;
        int n2;
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase = this.getDescriptor();
        if (rdUnitTestNodeDescriptorBase == null) {
            return;
        }
        RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase2 = rdUnitTestNodeDescriptorBase;
        presentation2.setIcon(this.j(rdUnitTestNodeDescriptorBase2));
        if (RiderUnitTestDiagnostics.Companion.isDiagnosticsMode()) {
            presentation2.addText("[" + this.getId() + "]", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        if (rdUnitTestNodeDescriptorBase2.getNamespace() != null) {
            presentation2.addText(rdUnitTestNodeDescriptorBase2.getNamespace(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation2.addText(rdUnitTestNodeDescriptorBase2.getText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (rdUnitTestNodeDescriptorBase2.getTargetFramework() != null) {
            presentation2.addText(rdUnitTestNodeDescriptorBase2.getTargetFramework(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        if ((n2 = rdUnitTestNodeDescriptorBase2.getTestCount()) > 0) {
            Object[] objectArray = new Object[]{n2};
            string = " (" + RiderUnitTestingBundle.Companion.message("RiderUnitTestNode.tests", objectArray) + ")";
            presentation2.addText(string, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        presentation2.setTooltip("");
        if (rdUnitTestNodeDescriptorBase2 instanceof RdUnitTestSessionNodeDescriptor && this.getTreeDescriptor() instanceof RiderUnitTestTreeSessionDescriptor) {
            if (((Boolean)InterfacesKt.valueOrDefault((IOptProperty)((RiderUnitTestTreeSessionDescriptor)this.getTreeDescriptor()).getRdSession().getOptions().getShowDuration(), (Object)false)).booleanValue()) {
                presentation2.addText(" [" + NlsMessages.formatDurationApproximateNarrow((long)((RdUnitTestSessionNodeDescriptor)rdUnitTestNodeDescriptorBase2).getDuration()) + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            presentation2.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            string = RiderUnitTestExtensionsKt.toColor(((RdUnitTestSessionNodeDescriptor)rdUnitTestNodeDescriptorBase2).getStatus());
            presentation2.addText(((RdUnitTestSessionNodeDescriptor)rdUnitTestNodeDescriptorBase2).getStatusMessage(), new SimpleTextAttributes(0, (Color)((Object)string)));
            presentation2.setTooltip(((RdUnitTestSessionNodeDescriptor)rdUnitTestNodeDescriptorBase2).isOutdated() ? RiderUnitTestingBundle.Companion.message("RiderUnitTestNode.tooltip.outdated", new Object[0]) : "");
        }
    }

    @NotNull
    public final String getTextForCompare() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase = this.getDescriptor();
        if (rdUnitTestNodeDescriptorBase != null) {
            RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase2 = rdUnitTestNodeDescriptorBase;
            if (rdUnitTestNodeDescriptorBase2.getNamespace() != null) {
                stringBuilder2.append(rdUnitTestNodeDescriptorBase2.getNamespace());
            }
            stringBuilder2.append(rdUnitTestNodeDescriptorBase2.getText());
            if (rdUnitTestNodeDescriptorBase2.getTargetFramework() != null) {
                stringBuilder2.append(rdUnitTestNodeDescriptorBase2.getTargetFramework());
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getTextForCompare();
    }

    @Nullable
    public String getTestPresentation() {
        RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase = this.getDescriptor();
        return rdUnitTestNodeDescriptorBase != null ? rdUnitTestNodeDescriptorBase.getText() : null;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getTestPresentation();
    }

    public void navigate(boolean requestFocus) {
        this.getTreeDescriptor().navigate(this.getId(), requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    private final Icon j(RdUnitTestNodeDescriptorBase rdUnitTestNodeDescriptorBase) {
        IconModel iconModel = rdUnitTestNodeDescriptorBase instanceof RdUnitTestSessionNodeDescriptor ? ((RdUnitTestSessionNodeDescriptor)rdUnitTestNodeDescriptorBase).getStatusIcon() : null;
        return RiderUnitTestExtensionsKt.generateUnitTestIcon(rdUnitTestNodeDescriptorBase.getIcon(), iconModel);
    }
}

