/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.trees.helpers;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.unitTesting.RiderUnitTestingBundle;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeDescriptor;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/unitTesting/trees/helpers/RiderUnitTestTreeExpander;", "Lcom/intellij/ide/DefaultTreeExpander;", "descriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "(Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;)V", "canCollapse", "", "canExpand", "collapseAll", "", "expandAll", "intellij.rider"})
public final class RiderUnitTestTreeExpander
extends DefaultTreeExpander {
    @NotNull
    private final RiderUnitTestTreeDescriptor descriptor;

    public RiderUnitTestTreeExpander(@NotNull RiderUnitTestTreeDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        super((JTree)descriptor2.getTree());
        this.descriptor = descriptor2;
    }

    public void collapseAll() {
        if (this.descriptor.getFrontendExpandAllMode()) {
            return;
        }
        super.collapseAll();
    }

    public void expandAll() {
        int n2;
        if (this.descriptor.getFrontendExpandAllMode()) {
            return;
        }
        if (this.descriptor.getTotalTestCount() > 5000 && (n2 = Messages.showYesNoDialog((Project)this.descriptor.getProject(), (String)RiderUnitTestingBundle.Companion.message("RiderUnitTestTreeExpander.dialog.message.expand.all", new Object[0]), (String)RiderUnitTestingBundle.Companion.message("RiderUnitTestTreeExpander.dialog.title.expanding.unit.tests", new Object[0]), (String)RiderUnitTestingBundle.Companion.message("RiderUnitTestTreeExpander.button.expand.anyway", new Object[0]), (String)RiderBundle.message("button.cancel", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        InterfacesKt.fire((ISignal)((ISignal)this.descriptor.getProtocolModel().getExpandAll()));
    }

    public boolean canExpand() {
        return true;
    }

    public boolean canCollapse() {
        return true;
    }
}

