/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.trees;

import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeDescriptor;
import com.jetbrains.rider.unitTesting.trees.nodes.RiderUnitTestNode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001e\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestViewportEvaluator;", "Ljavax/swing/event/TreeExpansionListener;", "Ljavax/swing/event/TreeModelListener;", "Ljavax/swing/event/ChangeListener;", "viewport", "Ljavax/swing/JViewport;", "descriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "(Ljavax/swing/JViewport;Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "getDescriptor", "()Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "getViewport", "()Ljavax/swing/JViewport;", "j", "", "stateChanged", "event", "Ljavax/swing/event/ChangeEvent;", "treeCollapsed", "p0", "Ljavax/swing/event/TreeExpansionEvent;", "treeExpanded", "treeNodesChanged", "Ljavax/swing/event/TreeModelEvent;", "treeNodesInserted", "treeNodesRemoved", "treeStructureChanged", "Companion", "intellij.rider"})
public final class RiderUnitTestViewportEvaluator
implements TreeExpansionListener,
TreeModelListener,
ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JViewport viewport;
    @NotNull
    private final RiderUnitTestTreeDescriptor descriptor;
    @NotNull
    private final Tree tree;
    @NotNull
    private final SingleAlarm alarm;
    private static final int INVISIBLE_ROW_COUNT = 20;

    public RiderUnitTestViewportEvaluator(@NotNull JViewport viewport, @NotNull RiderUnitTestTreeDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.viewport = viewport;
        this.descriptor = descriptor2;
        this.tree = this.descriptor.getTree();
        this.alarm = new SingleAlarm(() -> RiderUnitTestViewportEvaluator.j(this), 50, Alarm.ThreadToUse.SWING_THREAD, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.descriptor.getLifetime(), null, (int)1, null));
        this.tree.getModel().addTreeModelListener(this);
        this.descriptor.getLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                tree.getModel().removeTreeModelListener(this);
            }
        });
        this.tree.addTreeExpansionListener((TreeExpansionListener)this);
        this.descriptor.getLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                tree.removeTreeExpansionListener((TreeExpansionListener)this);
            }
        });
        this.viewport.addChangeListener(this);
        this.descriptor.getLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.getViewport().removeChangeListener(this);
            }
        });
    }

    @NotNull
    public final JViewport getViewport() {
        return this.viewport;
    }

    @NotNull
    public final RiderUnitTestTreeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    @Override
    public void treeExpanded(@Nullable TreeExpansionEvent p0) {
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    @Override
    public void treeCollapsed(@Nullable TreeExpansionEvent p0) {
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    @Override
    public void treeNodesInserted(@Nullable TreeModelEvent p0) {
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    @Override
    public void treeNodesRemoved(@Nullable TreeModelEvent p0) {
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    @Override
    public void treeStructureChanged(@Nullable TreeModelEvent p0) {
        SingleAlarm.request$default((SingleAlarm)this.alarm, (boolean)false, (int)0, (int)3, null);
    }

    @Override
    public void treeNodesChanged(@Nullable TreeModelEvent p0) {
    }

    private final void j() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.descriptor.getLifetime())) {
            return;
        }
        Rectangle rectangle = this.viewport.getViewRect();
        int n2 = Math.max(this.tree.getClosestRowForLocation(rectangle.x, rectangle.y) - 20, 0);
        int n3 = Math.min(this.tree.getClosestRowForLocation(rectangle.x, rectangle.y + rectangle.height) + 20, this.tree.getRowCount());
        this.descriptor.log((Function0<String>)((Function0)new Function0<String>(n2, n3){
            final /* synthetic */ int $firstRow;
            final /* synthetic */ int $lastRow;
            {
                this.$firstRow = $firstRow;
                this.$lastRow = $lastRow;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "EvaluateVisibleNodes for rows: " + this.$firstRow + " - " + this.$lastRow;
            }
        }));
        List list2 = new ArrayList();
        int n4 = n2;
        if (n4 <= n3) {
            while (true) {
                Object object;
                TreePath treePath = this.tree.getPathForRow(n4);
                Object object2 = object = treePath != null ? treePath.getLastPathComponent() : null;
                if (object instanceof RiderUnitTestNode) {
                    list2.add(((RiderUnitTestNode)((Object)object)).getId());
                }
                if (n4 == n3) break;
                ++n4;
            }
        }
        this.descriptor.evaluate(list2);
    }

    private static final void j(RiderUnitTestViewportEvaluator riderUnitTestViewportEvaluator) {
        Intrinsics.checkNotNullParameter((Object)riderUnitTestViewportEvaluator, (String)"this$0");
        riderUnitTestViewportEvaluator.j();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestViewportEvaluator$Companion;", "", "()V", "INVISIBLE_ROW_COUNT", "", "isViewportEvaluationEnabled", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isViewportEvaluationEnabled() {
            return Registry.is((String)"rider.unit.testing.evaluate.viewport");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

