/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.panels;

import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdUnitTestSession;
import com.jetbrains.rider.model.RdUnitTestSessionState;
import com.jetbrains.rider.unitTesting.panels.RiderUnitTestPanel;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeDescriptor;
import java.awt.Color;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/unitTesting/panels/RiderUnitTestSessionPanel;", "Lcom/jetbrains/rider/unitTesting/panels/RiderUnitTestPanel;", "treeDescriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;", "rdSession", "Lcom/jetbrains/rider/model/RdUnitTestSession;", "(Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeDescriptor;Lcom/jetbrains/rider/model/RdUnitTestSession;)V", "getRdSession", "()Lcom/jetbrains/rider/model/RdUnitTestSession;", "j", "Ljava/awt/Color;", "state", "Lcom/jetbrains/rider/model/RdUnitTestSessionState;", "updateProgressBar", "", "intellij.rider"})
public final class RiderUnitTestSessionPanel
extends RiderUnitTestPanel {
    @NotNull
    private final RdUnitTestSession rdSession;

    public RiderUnitTestSessionPanel(@NotNull RiderUnitTestTreeDescriptor treeDescriptor, @NotNull RdUnitTestSession rdSession) {
        Intrinsics.checkNotNullParameter((Object)treeDescriptor, (String)"treeDescriptor");
        Intrinsics.checkNotNullParameter((Object)rdSession, (String)"rdSession");
        super(treeDescriptor, true);
        this.rdSession = rdSession;
        this.rdSession.getState().advise(treeDescriptor.getLifetime(), (Function1)new Function1<RdUnitTestSessionState, Unit>(){

            public final void invoke(@NotNull RdUnitTestSessionState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.updateProgressBar();
            }
        });
        treeDescriptor.getProtocolModel().isBusy().advise(treeDescriptor.getLifetime(), (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.updateProgressBar();
            }
        });
        this.updateProgressBar();
    }

    @NotNull
    public final RdUnitTestSession getRdSession() {
        return this.rdSession;
    }

    @Override
    protected void updateProgressBar() {
        JProgressBar jProgressBar;
        super.updateProgressBar();
        RdUnitTestSessionState rdUnitTestSessionState = (RdUnitTestSessionState)this.rdSession.getState().getValueOrNull();
        if (rdUnitTestSessionState == null) {
            return;
        }
        RdUnitTestSessionState rdUnitTestSessionState2 = rdUnitTestSessionState;
        boolean bl = (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.getTreeDescriptor().getProtocolModel().isBusy(), (Object)false);
        JProgressBar jProgressBar2 = jProgressBar = this.getMyProgressBar();
        boolean bl2 = false;
        jProgressBar2.setIndeterminate(rdUnitTestSessionState2.isIndeterminate() || rdUnitTestSessionState2.isPending() && !rdUnitTestSessionState2.isRunning() || bl);
        jProgressBar2.setString(rdUnitTestSessionState2.getMessage());
        jProgressBar2.setStringPainted(this.getViewSettings().getProgressBarShowText().getValue());
        jProgressBar2.setForeground(this.j(rdUnitTestSessionState2));
        jProgressBar2.setValue(rdUnitTestSessionState2.getCompletedCount());
        jProgressBar2.setMaximum(rdUnitTestSessionState2.getTotalCount());
        jProgressBar2.setToolTipText(rdUnitTestSessionState2.getMessage());
        jProgressBar2.setVisible(rdUnitTestSessionState2.isRunning() || rdUnitTestSessionState2.isPending() || rdUnitTestSessionState2.isIndeterminate() || bl);
    }

    private final Color j(RdUnitTestSessionState rdUnitTestSessionState) {
        boolean bl = Registry.is((String)"rider.unitTests.coloredProgressBar");
        if (bl) {
            Color color;
            if (rdUnitTestSessionState.getHasFailedTests()) {
                Color color2 = ColorProgressBar.RED;
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"RED");
            } else {
                Color color3 = ColorProgressBar.GREEN;
                color = color3;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"GREEN");
            }
            return color;
        }
        JBColor jBColor = JBColor.GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
        return (Color)jBColor;
    }
}

