/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.panels;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdUnitTestResultData;
import com.jetbrains.rider.model.RdUnitTestSession;
import com.jetbrains.rider.model.RdUnitTestTreeNode;
import com.jetbrains.rider.stacktrace.RiderStacktraceUtil;
import com.jetbrains.rider.ui.RiderColorKt;
import com.jetbrains.rider.ui.RiderUI;
import com.jetbrains.rider.unitTesting.RiderUnitTestConsoleHyperlinkFilter;
import com.jetbrains.rider.unitTesting.RiderUnitTestExtensionsKt;
import com.jetbrains.rider.unitTesting.RiderUnitTestingBundle;
import com.jetbrains.rider.unitTesting.diagnostics.RiderUnitTestDiagnostics;
import com.jetbrains.rider.unitTesting.panels.RiderDiffLink;
import com.jetbrains.rider.unitTesting.trees.RiderUnitTestTreeSessionDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eJ*\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\rH\u0002J\u0012\u0010'\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u001c\u0010*\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010&\u001a\u00020\rH\u0002J\u0012\u0010+\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\f\u0010,\u001a\u00020$*\u00020)H\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/unitTesting/panels/RiderUnitTestResultPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "treeDescriptor", "Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeSessionDescriptor;", "session", "Lcom/jetbrains/rider/model/RdUnitTestSession;", "(Lcom/jetbrains/rider/unitTesting/trees/RiderUnitTestTreeSessionDescriptor;Lcom/jetbrains/rider/model/RdUnitTestSession;)V", "ansiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "diffLineRegex", "Lkotlin/text/Regex;", "isDisposed", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "navigator", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "getNavigator", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "resultDataConsoleView", "resultDataIcon", "Ljavax/swing/JLabel;", "resultDataPanel", "resultDataSummary", "getSession", "()Lcom/jetbrains/rider/model/RdUnitTestSession;", "dispose", "", "invalidateData", "j", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "unscrambledTrace", "", "asciiEscapePrefix", "force", "N", "data", "Lcom/jetbrains/rider/model/RdUnitTestResultData;", "j", "j", "j", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderUnitTestResultPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderUnitTestResultPanel.kt\ncom/jetbrains/rider/unitTesting/panels/RiderUnitTestResultPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n766#2:275\n857#2,2:276\n*S KotlinDebug\n*F\n+ 1 RiderUnitTestResultPanel.kt\ncom/jetbrains/rider/unitTesting/panels/RiderUnitTestResultPanel\n*L\n169#1:275\n169#1:276,2\n*E\n"})
public final class RiderUnitTestResultPanel
extends BorderLayoutPanel
implements Disposable {
    @NotNull
    private final RiderUnitTestTreeSessionDescriptor treeDescriptor;
    @NotNull
    private final RdUnitTestSession session;
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final AnsiEscapeDecoder ansiEscapeDecoder;
    @NotNull
    private final Regex diffLineRegex;
    @NotNull
    private final ConsoleViewImpl resultDataConsoleView;
    @NotNull
    private final JLabel resultDataIcon;
    @NotNull
    private final JLabel resultDataSummary;
    @NotNull
    private final BorderLayoutPanel resultDataPanel;
    @NotNull
    private final ConsoleViewImpl navigator;
    private boolean isDisposed;

    public RiderUnitTestResultPanel(@NotNull RiderUnitTestTreeSessionDescriptor treeDescriptor, @NotNull RdUnitTestSession session) {
        ConsoleViewImpl consoleViewImpl;
        Intrinsics.checkNotNullParameter((Object)treeDescriptor, (String)"treeDescriptor");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.treeDescriptor = treeDescriptor;
        this.session = session;
        this.project = this.treeDescriptor.getProject();
        this.lifetime = this.treeDescriptor.getLifetime();
        this.ansiEscapeDecoder = new AnsiEscapeDecoder();
        this.diffLineRegex = new Regex(".*Compare\\(Rider\\):?\\s?=?\\s?\u201c?\"(.+)\",\"(.+)\"\u201d?");
        ConsoleViewImpl consoleViewImpl2 = consoleViewImpl = RiderStacktraceUtil.INSTANCE.createRiderConsoleView(this.project, false);
        RiderUnitTestResultPanel riderUnitTestResultPanel = this;
        boolean bl = false;
        Project project = consoleViewImpl2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        consoleViewImpl2.addMessageFilter((Filter)new RiderUnitTestConsoleHyperlinkFilter(project));
        riderUnitTestResultPanel.resultDataConsoleView = consoleViewImpl;
        this.resultDataIcon = new JLabel();
        this.resultDataSummary = RiderUI.Companion.createLabel();
        this.resultDataPanel = RiderUI.Companion.headerPanel((Function1)new Function1<BorderLayoutPanel, Unit>(this){
            final /* synthetic */ RiderUnitTestResultPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BorderLayoutPanel $this$headerPanel) {
                Intrinsics.checkNotNullParameter((Object)$this$headerPanel, (String)"$this$headerPanel");
                $this$headerPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
                $this$headerPanel.add((Component)RiderUI.Companion.headerPanel((Function1)new Function1<BorderLayoutPanel, Unit>(this.this$0){
                    final /* synthetic */ RiderUnitTestResultPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull BorderLayoutPanel $this$headerPanel) {
                        Intrinsics.checkNotNullParameter((Object)$this$headerPanel, (String)"$this$headerPanel");
                        $this$headerPanel.setBorder((Border)JBUI.Borders.empty());
                        $this$headerPanel.addToLeft((Component)RiderUI.Companion.headerPanel((Function1)new Function1<BorderLayoutPanel, Unit>(this.this$0){
                            final /* synthetic */ RiderUnitTestResultPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull BorderLayoutPanel $this$headerPanel) {
                                Intrinsics.checkNotNullParameter((Object)$this$headerPanel, (String)"$this$headerPanel");
                                $this$headerPanel.setBorder((Border)JBUI.Borders.empty());
                                $this$headerPanel.addToLeft((Component)RiderUnitTestResultPanel.access$getResultDataIcon$p(this.this$0));
                                $this$headerPanel.addToCenter((Component)RiderUnitTestResultPanel.access$getResultDataSummary$p(this.this$0));
                            }
                        }));
                    }
                }), (Object)"West");
            }
        });
        this.navigator = this.resultDataConsoleView;
        this.setMinimumSize(new Dimension(0, 0));
        this.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)RiderUI.Companion.borderPanel((Function1)new Function1<BorderLayoutPanel, Unit>(){

            public final void invoke(@NotNull BorderLayoutPanel $this$borderPanel) {
                Intrinsics.checkNotNullParameter((Object)$this$borderPanel, (String)"$this$borderPanel");
                $this$borderPanel.add((Component)resultDataPanel, (Object)"North");
                final ConsoleViewImpl consoleViewImpl = resultDataConsoleView;
                $this$borderPanel.add((Component)consoleViewImpl.getComponent(), (Object)"Center");
                consoleViewImpl.setBorder((Border)JBUI.Borders.empty());
                consoleViewImpl.getEditor().setBorder((Border)JBUI.Borders.empty());
                $this$borderPanel.setBorder((Border)JBUI.Borders.empty());
                consoleViewImpl.clear();
                consoleViewImpl.allowHeavyFilters();
                treeDescriptor.getRdHost().getGlobalOptions().getWrapLongLinesInUnitTestSessionOutput().advise(lifetime, (Function1)new Function1<Boolean, Unit>(){

                    public final void invoke(boolean it) {
                        consoleViewImpl.getEditor().getSettings().setUseSoftWraps(it);
                    }
                });
            }
        }));
        this.session.getResultData().advise(this.lifetime, (Function1)new Function1<RdUnitTestResultData, Unit>(){

            public final void invoke(@Nullable RdUnitTestResultData resultData) {
                int n2 = ((Number)InterfacesKt.valueOrDefault((IOptProperty)this.getSession().getTreeDescriptor().getSelectedNode(), (Object)-1)).intValue();
                RdUnitTestTreeNode rdUnitTestTreeNode = treeDescriptor.getNodeById(n2);
                if (rdUnitTestTreeNode != null && resultData != null && !Intrinsics.areEqual((Object)StringsKt.take((String)rdUnitTestTreeNode.getDescriptor().getText(), (int)150), (Object)StringsKt.take((String)resultData.getText(), (int)150))) {
                    return;
                }
                this.j(resultData);
                RiderUnitTestResultPanel.updateResultData$default(this, resultData, false, 2, null);
            }
        });
        Disposer.register((Disposable)LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.lifetime, (String)"RiderUnitTestResultPanel::Disposable"), (Disposable)((Disposable)this.resultDataConsoleView));
    }

    @NotNull
    public final RdUnitTestSession getSession() {
        return this.session;
    }

    private final void j(ConsoleView consoleView, String string, String string2, boolean bl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string3 = string + "\n";
        Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        String string4 = ((ConsoleViewImpl)consoleView).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String string5 = string4;
        if (!Intrinsics.areEqual((Object)string3, (Object)string5) || bl) {
            consoleView.clear();
            String string6 = StringsKt.replace$default((String)string3, (String)string2, (String)"\u001b[", (boolean)false, (int)4, null);
            this.ansiEscapeDecoder.escapeText(string6, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> RiderUnitTestResultPanel.j(consoleView, this, arg_0, arg_1));
            consoleView.scrollTo(0);
        }
    }

    static /* synthetic */ void printToConsole$default(RiderUnitTestResultPanel riderUnitTestResultPanel, ConsoleView consoleView, String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        riderUnitTestResultPanel.j(consoleView, string, string2, bl);
    }

    @NotNull
    public final ConsoleViewImpl getNavigator() {
        return this.navigator;
    }

    /*
     * Unable to fully structure code
     */
    private final void j(RdUnitTestResultData var1_1, boolean var2_2) {
        block5: {
            block4: {
                var3_3 = this.N(var1_1);
                if (!Intrinsics.areEqual((Object)var3_3, (Object)"")) break block4;
                this.resultDataConsoleView.clear();
                break block5;
            }
            try {
                if (var1_1 == null) ** GOTO lbl-1000
                v0 = var1_1.getNodeKind().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)v0, (CharSequence)"xunit", (boolean)false, (int)2, null)) {
                    v1 = "\\x1b[";
                } else lbl-1000:
                // 2 sources

                {
                    v1 = "\\u001b[";
                }
                var4_4 = v1;
                this.j((ConsoleView)this.resultDataConsoleView, var3_3, var4_4, var2_2);
            }
            catch (Exception var4_5) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ void updateResultData$default(RiderUnitTestResultPanel riderUnitTestResultPanel, RdUnitTestResultData rdUnitTestResultData, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        riderUnitTestResultPanel.j(rdUnitTestResultData, bl);
    }

    private final String N(RdUnitTestResultData rdUnitTestResultData) {
        String string;
        Object[] objectArray;
        String string2;
        if (rdUnitTestResultData == null) {
            return "";
        }
        boolean bl = rdUnitTestResultData.isTrimmed();
        if (bl) {
            string2 = "The output has reached the limit and was truncated.\nTo view the full output use the 'Open Full Test Output in Editor' action.\nYou can also change the limit in 'File | Settings | Build, Execution, Deployment | Unit Testing'.";
        } else if (!bl) {
            string2 = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string3 = string2;
        if (RiderUnitTestDiagnostics.Companion.isDiagnosticsMode()) {
            objectArray = new String[]{"-------------------------------------------", "Text              = " + rdUnitTestResultData.getText(), "TestCount         = " + rdUnitTestResultData.getTestCount(), "Status            = " + rdUnitTestResultData.getStatus(), "StatusMessage     = " + rdUnitTestResultData.getStatusMessage(), "SessionId         = " + rdUnitTestResultData.getSessionId(), "ElementId         = " + rdUnitTestResultData.getElementId(), "Duration          = " + rdUnitTestResultData.getDuration(), "FailedTestCount   = " + rdUnitTestResultData.getFailedTestCount(), "IsOutdated        = " + rdUnitTestResultData.isOutdated()};
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = "";
        }
        String string4 = string;
        objectArray = ((CharSequence)rdUnitTestResultData.getStatusMessage()).length() == 0 ? "" : (StringsKt.contains$default((CharSequence)rdUnitTestResultData.getExceptionLines(), (CharSequence)rdUnitTestResultData.getStatusMessage(), (boolean)false, (int)2, null) ? "" : (StringsKt.contains$default((CharSequence)rdUnitTestResultData.getOutputLines(), (CharSequence)rdUnitTestResultData.getStatusMessage(), (boolean)false, (int)2, null) ? "" : ((Object)StringsKt.trim((CharSequence)rdUnitTestResultData.getStatusMessage())).toString()));
        Object object = new String[]{objectArray, rdUnitTestResultData.getExceptionLines(), rdUnitTestResultData.getOutputLines(), rdUnitTestResultData.getServiceMessage(), string3, string4};
        List list2 = CollectionsKt.listOf((Object[])object);
        object = list2;
        boolean bl2 = false;
        Object object2 = object;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            String string5 = (String)t;
            boolean bl4 = false;
            boolean bl5 = ((CharSequence)string5).length() > 0;
            if (!bl5) continue;
            collection.add(t);
        }
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private final void j(RdUnitTestResultData rdUnitTestResultData) {
        int n2 = JBUI.scale((int)20);
        RiderUI.Companion.setHeight$default((RiderUI.Companion)RiderUI.Companion, (JComponent)((JComponent)this.resultDataPanel), (int)n2, (boolean)false, (boolean)false, (int)4, null);
        if (rdUnitTestResultData != null) {
            this.resultDataSummary.setText(this.j(rdUnitTestResultData));
            this.resultDataIcon.setIcon(RiderUnitTestExtensionsKt.generateUnitTestIcon(rdUnitTestResultData.getIcon(), rdUnitTestResultData.getStatusIcon()));
        } else {
            this.resultDataSummary.setText("");
            this.resultDataIcon.setIcon(null);
        }
        this.resultDataSummary.setToolTipText(this.resultDataSummary.getText());
        this.resultDataPanel.updateUI();
    }

    @NlsSafe
    private final String j(RdUnitTestResultData rdUnitTestResultData) {
        JBColor jBColor;
        int n2;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("<html>");
        stringBuilder2.append(XmlStringUtil.escapeString((String)rdUnitTestResultData.getText()));
        String string = rdUnitTestResultData.getTargetFramework();
        CharSequence charSequence = string;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            stringBuilder2.append("<i>");
            stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)RiderUI.CommonPalette.Companion.getGray())) + ">");
            stringBuilder2.append(" (" + string + ")");
            stringBuilder2.append("</font>");
            stringBuilder2.append("</i>");
        }
        if ((n2 = rdUnitTestResultData.getTestCount()) > 0) {
            stringBuilder2.append("<i>");
            stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)RiderUI.CommonPalette.Companion.getGray())) + ">");
            jBColor = new JBColor[]{Integer.valueOf(n2)};
            stringBuilder2.append(" (" + RiderUnitTestingBundle.Companion.message("RiderUnitTestNode.tests", (Object[])jBColor) + ")");
            stringBuilder2.append("</font>");
            stringBuilder2.append("</i>");
        }
        stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)RiderUI.CommonPalette.Companion.getGray())) + ">");
        stringBuilder2.append(" [" + NlsMessages.formatDurationApproximateNarrow((long)rdUnitTestResultData.getDuration()) + "]");
        stringBuilder2.append("</font>");
        jBColor = RiderUnitTestExtensionsKt.toColor(rdUnitTestResultData.getStatus());
        stringBuilder2.append("<font color=" + RiderColorKt.toHtml((Color)((Color)jBColor)) + ">");
        stringBuilder2.append(' ');
        stringBuilder2.append(XmlStringUtil.escapeString((String)rdUnitTestResultData.getStatusMessage()));
        stringBuilder2.append("</font>");
        stringBuilder2.append("</html>");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.resultDataConsoleView.dispose();
        }
    }

    public final void invalidateData() {
        block0: {
            RdUnitTestResultData rdUnitTestResultData = (RdUnitTestResultData)this.session.getResultData().getValue();
            if (rdUnitTestResultData == null) break block0;
            RdUnitTestResultData rdUnitTestResultData2 = rdUnitTestResultData;
            boolean bl = false;
            this.j(rdUnitTestResultData2);
            this.j(rdUnitTestResultData2, true);
        }
    }

    private static final void j(ConsoleView consoleView, RiderUnitTestResultPanel riderUnitTestResultPanel, String string, Key key2) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"$consoleView");
        Intrinsics.checkNotNullParameter((Object)((Object)riderUnitTestResultPanel), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)string, (String)"textChunk");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"attributes");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)key2);
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        ConsoleViewContentType consoleViewContentType2 = consoleViewContentType;
        int n2 = StringsKt.indexOf$default((CharSequence)string, (String)"Compare(Rider)", (int)0, (boolean)false, (int)6, null);
        if (n2 == -1) {
            consoleView.print(string, consoleViewContentType2);
            return;
        }
        int n3 = 0;
        while (n2 != -1) {
            Unit unit;
            String string2;
            String string3 = string.substring(n3, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            consoleView.print(string3, consoleViewContentType2);
            n3 = StringsKt.indexOf$default((CharSequence)string, (char)'\n', (int)n2, (boolean)false, (int)4, null);
            if (n3 > 0 && string.charAt(n3 - 1) == '\r') {
                --n3;
            }
            if (n3 == -1) {
                n3 = string.length() - 1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n2, n3), (String)"substring(...)");
            if (riderUnitTestResultPanel.diffLineRegex.matchEntire((CharSequence)string2) != null) {
                MatchResult matchResult;
                boolean bl = false;
                consoleView.print(RiderUnitTestingBundle.Companion.message("RiderDiffLinkPrefix", new Object[0]) + " ", consoleViewContentType2);
                consoleView.printHyperlink(ExecutionBundle.message((String)"junit.click.to.see.diff.link", (Object[])new Object[0]), (HyperlinkInfo)new RiderDiffLink(riderUnitTestResultPanel.project, (String)matchResult.getGroupValues().get(2), (String)matchResult.getGroupValues().get(1)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                consoleView.print(string2, consoleViewContentType2);
            }
            n2 = StringsKt.indexOf$default((CharSequence)string, (String)"Compare(Rider)", (int)n3, (boolean)false, (int)4, null);
        }
        if (n3 != string.length() - 1) {
            String string4 = string.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            consoleView.print(string4, consoleViewContentType2);
        }
    }

    public static final /* synthetic */ JLabel access$getResultDataIcon$p(RiderUnitTestResultPanel $this) {
        return $this.resultDataIcon;
    }

    public static final /* synthetic */ JLabel access$getResultDataSummary$p(RiderUnitTestResultPanel $this) {
        return $this.resultDataSummary;
    }
}

