/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.unitTesting.diagnostics;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.model.RdUnitTestHost;
import com.jetbrains.rider.model.RdUnitTestNavigateArgs;
import com.jetbrains.rider.model.RdUnitTestSession;
import com.jetbrains.rider.model.RdUnitTestSessionManager;
import com.jetbrains.rider.model.RdUnitTestSessionOptions;
import com.jetbrains.rider.model.RdUnitTestSessionState;
import com.jetbrains.rider.model.RdUnitTestTreeDescriptor;
import com.jetbrains.rider.model.RdUnitTestTreeNode;
import com.jetbrains.rider.unitTesting.diagnostics.RiderUnitTestDiagnostics;
import com.jetbrains.rider.unitTesting.diagnostics.RiderUnitTestProtocolWatcher;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/unitTesting/diagnostics/RiderUnitTestProtocolWatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "host", "Lcom/jetbrains/rider/model/RdUnitTestHost;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/RdUnitTestHost;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getHost", "()Lcom/jetbrains/rider/model/RdUnitTestHost;", "log", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getLog", "()Lcom/jetbrains/rd/util/reactive/Signal;", "getProject", "()Lcom/intellij/openapi/project/Project;", "j", "", "treeDescriptor", "Lcom/jetbrains/rider/model/RdUnitTestTreeDescriptor;", "key", "Companion", "intellij.rider"})
public final class RiderUnitTestProtocolWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RdUnitTestHost host;
    @NotNull
    private final Signal<String> log;

    public RiderUnitTestProtocolWatcher(@NotNull Project project, @NotNull RdUnitTestHost host2, final @NotNull Lifetime lifetime2) {
        RdUnitTestSessionManager rdUnitTestSessionManager;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        this.project = project;
        this.host = host2;
        this.log = new Signal();
        this.j(lifetime2, this.host.getExplorerDescriptor(), "[EXPLORER]");
        this.host.getSessions().view(lifetime2, (Function3)new Function3<Lifetime, UUID, RdUnitTestSession, Unit>(){

            public final void invoke(@NotNull Lifetime sessionLt, @NotNull UUID sessionId, @NotNull RdUnitTestSession session) {
                Intrinsics.checkNotNullParameter((Object)sessionLt, (String)"sessionLt");
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                final String string = Companion.display(sessionId);
                this.getLog().fire((Object)(string + " CREATE_SESSION"));
                sessionLt.onTermination((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.getLog().fire((Object)(string + " CLOSE_SESSION"));
                    }
                });
                this.j(lifetime2, session.getTreeDescriptor(), string);
                RdUnitTestSessionOptions rdUnitTestSessionOptions = session.getOptions();
                Lifetime lifetime22 = lifetime2;
                RiderUnitTestProtocolWatcher riderUnitTestProtocolWatcher = this;
                RdUnitTestSessionOptions rdUnitTestSessionOptions2 = rdUnitTestSessionOptions;
                boolean bl = false;
                rdUnitTestSessionOptions2.getTitle().advise(lifetime22, (Function1)new Function1<String, Unit>(riderUnitTestProtocolWatcher, string){
                    final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
                    final /* synthetic */ String $sessionKey;
                    {
                        this.this$0 = $receiver;
                        this.$sessionKey = $sessionKey;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.getLog().fire((Object)(this.$sessionKey + ".title = " + it));
                    }
                });
                session.getState().advise(sessionLt, (Function1)new Function1<RdUnitTestSessionState, Unit>(){

                    public final void invoke(@NotNull RdUnitTestSessionState it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.getLog().fire((Object)(string + ".state = " + it.getStatus()));
                    }
                });
            }
        });
        RdUnitTestSessionManager rdUnitTestSessionManager2 = rdUnitTestSessionManager = this.host.getSessionManager();
        boolean bl = false;
        rdUnitTestSessionManager2.getActiveSessionId().advise(lifetime2, (Function1)new Function1<UUID, Unit>(this){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UUID sessionId) {
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                this.this$0.getLog().fire((Object)(RiderUnitTestProtocolWatcher.Companion.display(sessionId) + ": ACTIVE"));
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RdUnitTestHost getHost() {
        return this.host;
    }

    @NotNull
    public final Signal<String> getLog() {
        return this.log;
    }

    private final void j(Lifetime lifetime2, RdUnitTestTreeDescriptor rdUnitTestTreeDescriptor, String string) {
        rdUnitTestTreeDescriptor.getAddOrUpdateItem().advise(lifetime2, (Function1)new Function1<RdUnitTestTreeNode, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(@NotNull RdUnitTestTreeNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getLog().fire((Object)("Add or Update " + this.$key + " %" + it.getId() + " = " + RiderUnitTestProtocolWatcher.Companion.display(it)));
            }
        });
        rdUnitTestTreeDescriptor.getRemoveItem().advise(lifetime2, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                this.this$0.getLog().fire((Object)("Remove " + it));
            }
        });
        rdUnitTestTreeDescriptor.getClearItems().advise(lifetime2, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getLog().fire((Object)"Clear items");
            }
        });
        rdUnitTestTreeDescriptor.getExpand().advise(lifetime2, (Function1)new Function1<Integer, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(@Nullable Integer it) {
                this.this$0.getLog().fire((Object)(this.$key + ".expand(" + it + ")"));
            }
        });
        rdUnitTestTreeDescriptor.getShouldBeExpanded().advise(lifetime2, (Function1)new Function1<Integer, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(int it) {
                this.this$0.getLog().fire((Object)(this.$key + ".shouldBeExpanded(" + it + ")"));
            }
        });
        rdUnitTestTreeDescriptor.getSelectedNode().advise(lifetime2, (Function1)new Function1<Integer, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(int it) {
                this.this$0.getLog().fire((Object)(this.$key + ".selectedNode = " + it));
            }
        });
        rdUnitTestTreeDescriptor.getSelectedNodes().advise(lifetime2, (Function1)new Function1<List<? extends Integer>, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(@NotNull List<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.this$0.getLog().fire((Object)(this.$key + ".selectedNodes = (" + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, (Function1)adviseForTreeEvents.1.INSTANCE, (int)31, null) + ")"));
            }
        });
        rdUnitTestTreeDescriptor.getSelectNode().advise(lifetime2, (Function1)new Function1<RdUnitTestNavigateArgs, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(@NotNull RdUnitTestNavigateArgs it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getLog().fire((Object)(this.$key + ".selectNode(" + it + ")"));
            }
        });
        rdUnitTestTreeDescriptor.getLastValidSelectedNode().advise(lifetime2, (Function1)new Function1<Integer, Unit>(this, string){
            final /* synthetic */ RiderUnitTestProtocolWatcher this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            public final void invoke(int it) {
                this.this$0.getLog().fire((Object)(this.$key + ".lastValidSelectedNode = " + it));
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/unitTesting/diagnostics/RiderUnitTestProtocolWatcher$Companion;", "", "()V", "display", "", "sessionId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "node", "Lcom/jetbrains/rider/model/RdUnitTestTreeNode;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String display(@NotNull UUID sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return RiderUnitTestDiagnostics.Companion.display(sessionId);
        }

        @NotNull
        public final String display(@Nullable RdUnitTestTreeNode node) {
            return RiderUnitTestDiagnostics.Companion.display(node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

