/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components.utils;

import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0017H\u0004R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/ui/components/utils/ChessBoardComponent;", "Ljavax/swing/JComponent;", "()V", "value", "Ljava/awt/Color;", "blackColor", "getBlackColor", "()Ljava/awt/Color;", "setBlackColor", "(Ljava/awt/Color;)V", "", "cellSize", "getCellSize", "()I", "setCellSize", "(I)V", "pattern", "Ljava/awt/image/BufferedImage;", "whiteColor", "getWhiteColor", "setWhiteColor", "j", "paintComponent", "", "g", "Ljava/awt/Graphics;", "update", "intellij.rider"})
public class ChessBoardComponent
extends JComponent {
    @NotNull
    private BufferedImage pattern;
    private int cellSize = JBUI.scale((int)10);
    @NotNull
    private Color whiteColor;
    @NotNull
    private Color blackColor;

    public ChessBoardComponent() {
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        this.whiteColor = color;
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        this.blackColor = color2;
        this.pattern = this.j();
    }

    public final int getCellSize() {
        return this.cellSize;
    }

    public final void setCellSize(int value) {
        if (this.cellSize == value) {
            return;
        }
        this.cellSize = value;
        this.update();
    }

    @NotNull
    public final Color getWhiteColor() {
        return this.whiteColor;
    }

    public final void setWhiteColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.whiteColor == value) {
            return;
        }
        this.whiteColor = value;
        this.update();
    }

    @NotNull
    public final Color getBlackColor() {
        return this.blackColor;
    }

    public final void setBlackColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.blackColor == value) {
            return;
        }
        this.blackColor = value;
        this.update();
    }

    protected final void update() {
        this.pattern = this.j();
        this.repaint();
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        if (g == null) {
            return;
        }
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new TexturePaint(this.pattern, new Rectangle(0, 0, this.pattern.getWidth(), this.pattern.getHeight())));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.dispose();
        super.paintComponent(g);
    }

    private final BufferedImage j() {
        BufferedImage bufferedImage = ImageUtil.createImage((int)(2 * this.cellSize), (int)(2 * this.cellSize), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage bufferedImage2 = bufferedImage;
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.blackColor);
        graphics2D.fillRect(0, 0, this.cellSize, this.cellSize);
        graphics2D.fillRect(this.cellSize, this.cellSize, this.cellSize, this.cellSize);
        graphics2D.setColor(this.whiteColor);
        graphics2D.fillRect(this.cellSize, 0, this.cellSize, this.cellSize);
        graphics2D.fillRect(0, this.cellSize, this.cellSize, this.cellSize);
        return bufferedImage2;
    }
}

