/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.todo;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/todo/RiderTodoItem;", "Lcom/intellij/psi/search/TodoItem;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "todoPattern", "Lcom/intellij/psi/search/TodoPattern;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/search/TodoPattern;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "setPsiFile", "(Lcom/intellij/psi/PsiFile;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getTodoPattern", "()Lcom/intellij/psi/search/TodoPattern;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "getPattern", "getTextRange", "intellij.rider"})
public final class RiderTodoItem
implements TodoItem {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final TextRange range;
    @NotNull
    private final TodoPattern todoPattern;
    @Nullable
    private PsiFile psiFile;

    public RiderTodoItem(@NotNull Project project, @NotNull VirtualFile virtualFile2, @NotNull TextRange range, @NotNull TodoPattern todoPattern) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)todoPattern, (String)"todoPattern");
        this.project = project;
        this.virtualFile = virtualFile2;
        this.range = range;
        this.todoPattern = todoPattern;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final TodoPattern getTodoPattern() {
        return this.todoPattern;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    public final void setPsiFile(@Nullable PsiFile psiFile) {
        this.psiFile = psiFile;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile;
        PsiFile psiFile2 = this.psiFile;
        if (psiFile2 == null) {
            PsiFile psiFile3;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"getInstance(...)");
            PsiFile psiFile4 = ExtensionsKt.getPsiFile((VirtualFile)this.virtualFile, (FileDocumentManager)fileDocumentManager, (PsiDocumentManager)psiDocumentManager);
            if (psiFile4 == null) {
                throw new IllegalStateException(("Can't calculate psi file for " + this.virtualFile).toString());
            }
            this.psiFile = psiFile3 = psiFile4;
            return psiFile3;
        }
        if (psiFile2.isValid()) {
            return psiFile2;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        Intrinsics.checkNotNull((Object)psiDocumentManager);
        PsiFile psiFile5 = ExtensionsKt.getPsiFile((VirtualFile)this.virtualFile, (FileDocumentManager)fileDocumentManager, (PsiDocumentManager)psiDocumentManager);
        if (psiFile5 == null) {
            return psiFile2;
        }
        this.psiFile = psiFile = psiFile5;
        return psiFile;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.range;
    }

    @NotNull
    public TodoPattern getPattern() {
        return this.todoPattern;
    }
}

