/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rider.stacktrace.filters.RiderStacktraceNavigationContext;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001bJ\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0019H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceFrame;", "", "fragment", "Lcom/intellij/openapi/editor/Document;", "startLine", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlightRange", "(Lcom/intellij/openapi/editor/Document;ILcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;)V", "getHighlightRange", "()Lcom/intellij/openapi/util/TextRange;", "j", "j", "j", "component4", "copy", "equals", "", "other", "getNavigationContext", "Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceNavigationContext;", "rangeStart", "rangeEnd", "getText", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "hashCode", "toString", "intellij.rider"})
public final class RiderStacktraceFrame {
    @NotNull
    private final Document fragment;
    private final int startLine;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final TextRange highlightRange;

    public RiderStacktraceFrame(@NotNull Document fragment, int startLine, @NotNull TextRange textRange, @NotNull TextRange highlightRange) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
        this.fragment = fragment;
        this.startLine = startLine;
        this.textRange = textRange;
        this.highlightRange = highlightRange;
    }

    @NotNull
    public final TextRange getHighlightRange() {
        return this.highlightRange;
    }

    @NotNull
    public final String getText() {
        String string = this.fragment.getText(this.textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final RiderStacktraceNavigationContext getNavigationContext(int rangeStart, int rangeEnd) {
        int n2 = this.highlightRange.getStartOffset();
        TextRange textRange = new TextRange(n2 + rangeStart, n2 + rangeEnd);
        int n3 = this.highlightRange.contains(textRange.getStartOffset());
        if (_Assertions.ENABLED && n3 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        n3 = Math.max(this.fragment.getLineNumber(textRange.getStartOffset()) - 5, 0);
        int n4 = this.fragment.getLineStartOffset(n3);
        int n5 = Math.min(this.fragment.getLineNumber(textRange.getEndOffset()) + 5, this.fragment.getLineCount() - 1);
        int n6 = this.fragment.getLineEndOffset(n5);
        int n7 = this.highlightRange.getStartOffset() - n4;
        CharSequence charSequence = this.fragment.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        String string = ((Object)charSequence.subSequence(n4, n6)).toString();
        return new RiderStacktraceNavigationContext(string, n7);
    }

    private final Document j() {
        return this.fragment;
    }

    private final int j() {
        return this.startLine;
    }

    private final TextRange j() {
        return this.textRange;
    }

    @NotNull
    public final TextRange component4() {
        return this.highlightRange;
    }

    @NotNull
    public final RiderStacktraceFrame copy(@NotNull Document fragment, int startLine, @NotNull TextRange textRange, @NotNull TextRange highlightRange) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
        return new RiderStacktraceFrame(fragment, startLine, textRange, highlightRange);
    }

    public static /* synthetic */ RiderStacktraceFrame copy$default(RiderStacktraceFrame riderStacktraceFrame, Document document2, int n2, TextRange textRange, TextRange textRange2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            document2 = riderStacktraceFrame.fragment;
        }
        if ((n3 & 2) != 0) {
            n2 = riderStacktraceFrame.startLine;
        }
        if ((n3 & 4) != 0) {
            textRange = riderStacktraceFrame.textRange;
        }
        if ((n3 & 8) != 0) {
            textRange2 = riderStacktraceFrame.highlightRange;
        }
        return riderStacktraceFrame.copy(document2, n2, textRange, textRange2);
    }

    @NotNull
    public String toString() {
        return "RiderStacktraceFrame(fragment=" + this.fragment + ", startLine=" + this.startLine + ", textRange=" + this.textRange + ", highlightRange=" + this.highlightRange + ")";
    }

    public int hashCode() {
        int n2 = this.fragment.hashCode();
        n2 = n2 * 31 + Integer.hashCode(this.startLine);
        n2 = n2 * 31 + this.textRange.hashCode();
        n2 = n2 * 31 + this.highlightRange.hashCode();
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RiderStacktraceFrame)) {
            return false;
        }
        RiderStacktraceFrame riderStacktraceFrame = (RiderStacktraceFrame)other;
        if (!Intrinsics.areEqual((Object)this.fragment, (Object)riderStacktraceFrame.fragment)) {
            return false;
        }
        if (this.startLine != riderStacktraceFrame.startLine) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textRange, (Object)riderStacktraceFrame.textRange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.highlightRange, (Object)riderStacktraceFrame.highlightRange);
    }
}

