/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rider.model.StackTraceHyperlinkHighlighter;
import com.jetbrains.rider.model.StackTraceNavigationPoint;
import com.jetbrains.rider.stacktrace.filters.RiderHyperLinkInfoKt;
import com.jetbrains.rider.stacktrace.filters.RiderStacktraceFrame;
import com.jetbrains.rider.stacktrace.filters.RiderStacktraceNavigationContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/RiderHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "navigation", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lcom/jetbrains/rider/model/StackTraceNavigationPoint;", "hyperlink", "Lcom/jetbrains/rider/model/StackTraceHyperlinkHighlighter;", "frame", "Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceFrame;", "(Lcom/jetbrains/rd/util/reactive/ISignal;Lcom/jetbrains/rider/model/StackTraceHyperlinkHighlighter;Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceFrame;)V", "includeInOccurenceNavigation", "", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
public class RiderHyperlinkInfo
implements HyperlinkInfo {
    @NotNull
    private final ISignal<StackTraceNavigationPoint> navigation;
    @NotNull
    private final StackTraceHyperlinkHighlighter hyperlink;
    @NotNull
    private final RiderStacktraceFrame frame;

    public RiderHyperlinkInfo(@NotNull ISignal<StackTraceNavigationPoint> navigation, @NotNull StackTraceHyperlinkHighlighter hyperlink, @NotNull RiderStacktraceFrame frame) {
        Intrinsics.checkNotNullParameter(navigation, (String)"navigation");
        Intrinsics.checkNotNullParameter((Object)hyperlink, (String)"hyperlink");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.navigation = navigation;
        this.hyperlink = hyperlink;
        this.frame = frame;
    }

    public void navigate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RiderStacktraceNavigationContext riderStacktraceNavigationContext = this.frame.getNavigationContext(this.hyperlink.getStart(), this.hyperlink.getEnd());
        StackTraceHyperlinkHighlighter stackTraceHyperlinkHighlighter = RiderHyperLinkInfoKt.shiftRight(this.hyperlink, riderStacktraceNavigationContext.getDelta());
        this.navigation.fire((Object)new StackTraceNavigationPoint(riderStacktraceNavigationContext.getText(), stackTraceHyperlinkHighlighter));
    }

    public boolean includeInOccurenceNavigation() {
        return this.hyperlink.getIncludeInOccurenceNavigation();
    }
}

