/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rider.model.ApplyFilterRequestSettings;
import com.jetbrains.rider.stacktrace.filters.DotNetConsoleExceptionFilter;
import com.jetbrains.rider.stacktrace.filters.RiderExceptionFilterBase;
import com.jetbrains.rider.stacktrace.filters.RiderStacktraceFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/DotNetConsoleExceptionFilter;", "Lcom/jetbrains/rider/stacktrace/filters/RiderExceptionFilterBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getApplyFilterSettings", "Lcom/jetbrains/rider/model/ApplyFilterRequestSettings;", "getFramesIterator", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/rider/stacktrace/filters/RiderStacktraceFrame;", "copiedFragment", "Lcom/intellij/openapi/editor/Document;", "Companion", "intellij.rider"})
public final class DotNetConsoleExceptionFilter
extends RiderExceptionFilterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex stackTraceRegex = new Regex("^\\s*(at|\u0432|bei)\\s(?:(?<namespace>[\\p{L}\\d_.]*)\\.)?(?<class>[\\p{L}\\d_.+`]*(\\.[\\p{L}\\d_.+<>`]+)?)\\.(?<method>[\\p{L}\\d_\\[\\]<>`]*)\\s*\\((?:(?<parameter>[\\p{L}\\d`_.]+(?:\\[]|&|\\*)? [\\p{L}\\d_]+)(?:, )?)*\\)");
    @NotNull
    private static final Regex exceptionClassRegex = new Regex("([\\d\\p{L}]*)Exception");

    public DotNetConsoleExceptionFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public Sequence<RiderStacktraceFrame> getFramesIterator(@NotNull Document copiedFragment) {
        Intrinsics.checkNotNullParameter((Object)copiedFragment, (String)"copiedFragment");
        List list2 = new ArrayList();
        int n2 = copiedFragment.getLineCount();
        for (int k = 0; k < n2; ++k) {
            String string;
            int n3 = copiedFragment.getLineStartOffset(k);
            int n4 = copiedFragment.getLineEndOffset(k);
            TextRange textRange = new TextRange(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)copiedFragment.getText(textRange), (String)"getText(...)");
            if (!stackTraceRegex.containsMatchIn((CharSequence)string) && !exceptionClassRegex.containsMatchIn((CharSequence)string)) continue;
            list2.add(new RiderStacktraceFrame(copiedFragment, k, textRange, textRange));
        }
        return (Sequence)new Sequence<RiderStacktraceFrame>((List<RiderStacktraceFrame>)list2){
            private int index;
            final /* synthetic */ List<RiderStacktraceFrame> $frames;
            {
                this.$frames = $frames;
            }

            @NotNull
            public getFramesIterator.iterator.1 iterator() {
                return new Iterator<RiderStacktraceFrame>(this, this.$frames){
                    final /* synthetic */ getFramesIterator.1 this$0;
                    final /* synthetic */ List<RiderStacktraceFrame> $frames;
                    {
                        this.this$0 = $receiver;
                        this.$frames = $frames;
                    }

                    public boolean hasNext() {
                        return getFramesIterator.1.access$getIndex$p(this.this$0) < this.$frames.size();
                    }

                    @NotNull
                    public RiderStacktraceFrame next() {
                        getFramesIterator.1 var1_1 = this.this$0;
                        int n2 = getFramesIterator.1.access$getIndex$p(var1_1);
                        getFramesIterator.1.access$setIndex$p(var1_1, n2 + 1);
                        return this.$frames.get(n2);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }

            public static final /* synthetic */ int access$getIndex$p(getFramesIterator.1 $this) {
                return $this.index;
            }

            public static final /* synthetic */ void access$setIndex$p(getFramesIterator.1 $this, int n2) {
                $this.index = n2;
            }
        };
    }

    @Override
    @NotNull
    public ApplyFilterRequestSettings getApplyFilterSettings() {
        return new ApplyFilterRequestSettings(true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/stacktrace/filters/DotNetConsoleExceptionFilter$Companion;", "", "()V", "exceptionClassRegex", "Lkotlin/text/Regex;", "getExceptionClassRegex", "()Lkotlin/text/Regex;", "stackTraceRegex", "getStackTraceRegex", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getStackTraceRegex() {
            return stackTraceRegex;
        }

        @NotNull
        public final Regex getExceptionClassRegex() {
            return exceptionClassRegex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

