/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.stacktrace.AnalyzeExceptionConsolePanel;
import com.jetbrains.rider.stacktrace.StacktraceToolWindowFactory;
import com.jetbrains.rider.stacktrace.filters.DotNetConsoleExceptionFilter;
import com.jetbrains.rider.stacktrace.filters.RiderHeavyExceptionFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0003\u0010\u0011\u001a\u00020\u0004J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0007J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/stacktrace/RiderStacktraceUtil;", "", "()V", "NORMALIZE_STACK_TRACE_KEY", "", "RIDER_CONSOLE_VIEW_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRIDER_CONSOLE_VIEW_DATA_KEY", "()Lcom/intellij/openapi/util/Key;", "addAnalyzeExceptionTab", "", "project", "Lcom/intellij/openapi/project/Project;", "text", "tabTitle", "consoleIcon", "Ljavax/swing/Icon;", "toolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createRiderConsoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "isBulkTextExpected", "getRiderRelatedFilters", "", "Lcom/intellij/execution/filters/Filter;", "getToolWindow", "j", "j", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "unscrambledTrace", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderStacktraceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderStacktraceUtil.kt\ncom/jetbrains/rider/stacktrace/RiderStacktraceUtil\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n17#2,2:145\n766#3:147\n857#3,2:148\n*S KotlinDebug\n*F\n+ 1 RiderStacktraceUtil.kt\ncom/jetbrains/rider/stacktrace/RiderStacktraceUtil\n*L\n41#1:145,2\n103#1:147\n103#1:148,2\n*E\n"})
public final class RiderStacktraceUtil {
    @NotNull
    public static final RiderStacktraceUtil INSTANCE = new RiderStacktraceUtil();
    @NotNull
    private static final String NORMALIZE_STACK_TRACE_KEY = "rider.analyze.stacktrace.normalize";
    @NotNull
    private static final Key<Boolean> RIDER_CONSOLE_VIEW_DATA_KEY;

    private RiderStacktraceUtil() {
    }

    @NotNull
    public final Key<Boolean> getRIDER_CONSOLE_VIEW_DATA_KEY() {
        return RIDER_CONSOLE_VIEW_DATA_KEY;
    }

    public final void addAnalyzeExceptionTab(@NotNull Project project, @NotNull String text2, @NlsContexts.TabTitle @NotNull String tabTitle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        this.addAnalyzeExceptionTab(project, tabTitle, text2, null, this.getToolWindow(project));
    }

    public static /* synthetic */ void addAnalyzeExceptionTab$default(RiderStacktraceUtil riderStacktraceUtil, Project project, String string, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = RiderBundle.message("RiderStacktraceUtil.tab.title.analyze", new Object[0]);
        }
        riderStacktraceUtil.addAnalyzeExceptionTab(project, string, string2);
    }

    @NotNull
    public final ToolWindow getToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager componentManager = (ComponentManager)project;
        boolean bl = false;
        Object object = componentManager.getService(StacktraceToolWindowFactory.class);
        if (object == null) {
            throw new IllegalStateException("Service " + StacktraceToolWindowFactory.class + " not found in container " + componentManager);
        }
        return ((StacktraceToolWindowFactory)object).getToolWindow(project);
    }

    public final void addAnalyzeExceptionTab(@NotNull Project project, @NlsContexts.TabTitle @NotNull String tabTitle, @NotNull String text2, @Nullable Icon consoleIcon, @NotNull ToolWindow toolwindow) {
        Content content2;
        AnAction anAction3;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)toolwindow, (String)"toolwindow");
        ConsoleViewImpl consoleViewImpl = this.createRiderConsoleView(project, true);
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        AnalyzeExceptionConsolePanel analyzeExceptionConsolePanel = new AnalyzeExceptionConsolePanel((ExecutionConsole)consoleViewImpl, (ActionGroup)defaultActionGroup);
        AnAction anAction2 = consoleViewImpl.createConsoleActions();
        Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"createConsoleActions(...)");
        for (AnAction anAction3 : anAction2) {
            defaultActionGroup.add(anAction3);
        }
        ConsoleViewUtil.enableReplaceActionForConsoleViewEditor((Editor)consoleViewImpl.getEditor());
        consoleViewImpl.getEditor().getSettings().setCaretRowShown(true);
        AnAction anAction4 = ActionManager.getInstance().getAction("AnnotateStackTraceAction.show.files.modification.info");
        if (anAction4 != null) {
            defaultActionGroup.add(anAction4);
        }
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content3 = content2 = contentFactory.createContent((JComponent)analyzeExceptionConsolePanel, tabTitle, true);
        boolean bl = false;
        content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        content3.setIcon(consoleIcon);
        content3.setPreferredFocusedComponent(null);
        content3.setDisplayName(tabTitle);
        Content content4 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"apply(...)");
        Content content5 = content4;
        Disposer.register((Disposable)((Disposable)content5), (Disposable)((Disposable)consoleViewImpl));
        ContentManager contentManager = toolwindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        anAction3 = contentManager;
        anAction3.addContent(content5);
        anAction3.setSelectedContent(content5);
        Disposer.register((Disposable)((Disposable)project), () -> RiderStacktraceUtil.j((ContentManager)anAction3, content5));
        toolwindow.activate(null, false, false);
        consoleViewImpl.allowHeavyFilters();
        this.j((ConsoleView)consoleViewImpl, text2);
    }

    @NotNull
    public final ConsoleViewImpl createRiderConsoleView(@NotNull Project project, boolean isBulkTextExpected) {
        ConsoleViewImpl consoleViewImpl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<Filter> list2 = this.getRiderRelatedFilters(isBulkTextExpected, project);
        ConsoleViewImpl consoleViewImpl2 = consoleViewImpl = new ConsoleViewImpl(project, GlobalSearchScope.allScope((Project)project), false, true);
        boolean bl = false;
        UiUtils.putUserData((JComponent)((JComponent)consoleViewImpl2), RIDER_CONSOLE_VIEW_DATA_KEY, (Object)true);
        for (Filter filter2 : list2) {
            consoleViewImpl2.addMessageFilter(filter2);
        }
        return consoleViewImpl;
    }

    @NotNull
    public final List<Filter> getRiderRelatedFilters(boolean isBulkTextExpected, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list2 = AnalyzeStacktraceUtil.EP_NAME.getExtensions((AreaInstance)project);
        if (isBulkTextExpected) {
            return list2;
        }
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            Filter filter2 = (Filter)t;
            boolean bl3 = false;
            if (!(!(filter2 instanceof RiderHeavyExceptionFilter))) continue;
            collection.add(t);
        }
        return CollectionsKt.plus((Collection)((List)collection), (Iterable)CollectionsKt.listOf((Object)new DotNetConsoleExceptionFilter(project)));
    }

    private final void j(ConsoleView consoleView, String string) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string2 = this.j(string) + "\n";
        Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        String string3 = ((ConsoleViewImpl)consoleView).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String string4 = string3;
        if (!Intrinsics.areEqual((Object)string2, (Object)string4)) {
            consoleView.clear();
            consoleView.print(string2, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.scrollTo(0);
        }
    }

    private final String j(String string) {
        String string2;
        if (!Registry.is((String)NORMALIZE_STACK_TRACE_KEY)) {
            return string;
        }
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\\r\\n", (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'\"'};
            string2 = StringsKt.trim((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\r\n", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\\r\\n", (String)"\r\n", (boolean)false, (int)4, null), (String)"\\n ", (String)"\r\n", (boolean)false, (int)4, null), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null), (char[])cArray);
        } else {
            string2 = string;
        }
        String string3 = string2;
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"&mdash;", (String)"-", (boolean)false, (int)4, null), (String)"<br>", (String)"\r\n", (boolean)false, (int)4, null), (String)"<br />", (String)"\r\n", (boolean)false, (int)4, null), (String)"|r|n", (String)"\r\n", (boolean)false, (int)4, null), (String)"|n", (String)"\r\n", (boolean)false, (int)4, null), (String)"##teamcity", (String)"\r\n##teamcity", (boolean)false, (int)4, null);
    }

    private static final void j(ContentManager contentManager, Content content2) {
        Intrinsics.checkNotNullParameter((Object)contentManager, (String)"$contentManager");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"$content");
        contentManager.removeContent(content2, true);
    }

    static {
        Key key2 = Key.create((String)"RIDER_EXCEPTION_CONSOLE_VIEW");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        RIDER_CONSOLE_VIEW_DATA_KEY = key2;
    }
}

