/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker.quickFixes;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.quickfixes.SaveTo;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.spellChecker.layers.BackendDictionaryLayer;
import com.jetbrains.rider.spellChecker.quickFixes.OpenDictionarySettingsIntentionAction;
import com.jetbrains.rider.spellChecker.quickFixes.SaveToExactLayerIntentionAction;
import com.jetbrains.rider.spellChecker.quickFixes.SuppressWrapperIntentionAction;
import icons.SpellcheckerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J%\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J$\u0010,\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010.\u001a\u00020-H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\b0\b0\u000f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/spellChecker/quickFixes/BackendSaveTo;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionActionWithOptions;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "typo", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "layer", "Lcom/intellij/spellchecker/DictionaryLayer;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/spellchecker/DictionaryLayer;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "applyFix", "", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getCombiningPolicy", "Lcom/intellij/codeInsight/intention/IntentionActionWithOptions$CombiningPolicy;", "getFamilyName", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getName", "getOptions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "getText", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBackendSaveTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendSaveTo.kt\ncom/jetbrains/rider/spellChecker/quickFixes/BackendSaveTo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n800#2,11:77\n1549#2:88\n1620#2,3:89\n3792#3:92\n4307#3,2:93\n37#4,2:95\n*S KotlinDebug\n*F\n+ 1 BackendSaveTo.kt\ncom/jetbrains/rider/spellChecker/quickFixes/BackendSaveTo\n*L\n52#1:77,11\n53#1:88\n53#1:89,3\n61#1:92\n61#1:93,2\n61#1:95,2\n*E\n"})
public final class BackendSaveTo
implements LocalQuickFix,
IntentionActionWithOptions,
Iconable,
PriorityAction {
    @NotNull
    private final String typo;
    @NotNull
    private final TextRange range;
    @Nullable
    private final DictionaryLayer layer;
    @NotNull
    private final Project project;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;

    public BackendSaveTo(@NotNull String typo, @NotNull PsiElement element, @NotNull TextRange range, @Nullable DictionaryLayer layer) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.typo = typo;
        this.range = range;
        this.layer = layer;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element, element.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.pointer = smartPsiElementPointer;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.HIGH;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @NotNull
    public IntentionActionWithOptions.CombiningPolicy getCombiningPolicy() {
        return IntentionActionWithOptions.CombiningPolicy.IntentionOptionsOnly;
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor2 == null || file2 == null) {
            return;
        }
        Segment segment = this.pointer.getRange();
        if (segment == null) {
            return;
        }
        Segment segment2 = segment;
        SaveTo.applyFix((Project)project, (PsiFile)file2, (TextRange)this.range.shiftRight(segment2.getStartOffset()), (String)this.typo, (DictionaryLayer)this.layer);
    }

    @NotNull
    public List<IntentionAction> getOptions() {
        boolean bl;
        Object object;
        Iterable iterable = DictionaryLayersProvider.Companion.getAllLayers(this.project);
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Iterable iterable3 = new ArrayList();
        boolean bl3 = false;
        for (Object object2 : iterable2) {
            if (!(object2 instanceof BackendDictionaryLayer)) continue;
            iterable3.add(object2);
        }
        List list2 = (List)iterable3;
        Iterable iterable4 = list2;
        boolean bl4 = false;
        iterable3 = iterable4;
        SuppressQuickFix[] suppressQuickFixArray = (SuppressQuickFix[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
        boolean bl5 = false;
        for (Object object3 : iterable3) {
            object = (BackendDictionaryLayer)object3;
            SuppressQuickFix[] suppressQuickFixArray2 = suppressQuickFixArray;
            bl = false;
            suppressQuickFixArray2.add(new SaveToExactLayerIntentionAction(this.typo, this.pointer, this.range, (BackendDictionaryLayer)object));
        }
        iterable = CollectionsKt.toMutableList((Collection)((List)suppressQuickFixArray));
        iterable.add(new OpenDictionarySettingsIntentionAction());
        iterable4 = HighlightDisplayKey.findById((String)"SpellCheckingInspection");
        if (iterable4 != null) {
            iterable.add(new EditInspectionToolsSettingsAction((HighlightDisplayKey)iterable4));
        }
        SpellCheckingInspection spellCheckingInspection = new SpellCheckingInspection();
        iterable3 = this.pointer.getElement();
        if (iterable3 != null) {
            Object object3;
            SuppressQuickFix[] suppressQuickFixArray3 = spellCheckingInspection.getBatchSuppressActions(iterable3);
            Intrinsics.checkNotNullExpressionValue((Object)suppressQuickFixArray3, (String)"getBatchSuppressActions(...)");
            Object object4 = suppressQuickFixArray3;
            boolean bl6 = false;
            object3 = object4;
            object = new ArrayList();
            bl = false;
            for (Object e : object3) {
                SuppressQuickFix suppressQuickFix = (SuppressQuickFix)e;
                boolean bl7 = false;
                if (!suppressQuickFix.isAvailable(this.project, iterable3)) continue;
                object.add(e);
            }
            object4 = (List)object;
            bl6 = false;
            object3 = object4;
            suppressQuickFixArray = object3.toArray((SuppressQuickFix[])new SuppressQuickFix[0]);
            if (!(suppressQuickFixArray.length == 0)) {
                iterable.add(new SuppressWrapperIntentionAction(suppressQuickFixArray));
            }
        }
        return CollectionsKt.toMutableList((Collection)((Collection)iterable));
    }

    @NotNull
    public Void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        throw new IncorrectOperationException("Should not be called");
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon2 = SpellcheckerIcons.Spellcheck;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Spellcheck");
        return icon2;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.typo};
        return RiderBundle.message("spellchecker.save.0.to.dictionary", objectArray);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

