/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.search;

import com.intellij.ide.ui.search.SearchableOptionEntry;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.loggers.LogEntryBase;
import com.jetbrains.ide.model.loggers.LogEntryType;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.protocol.components.ShellHost;
import com.jetbrains.rider.services.RiderBackendDispatcherKt;
import com.jetbrains.rider.settings.IRiderViewModelConfigurable;
import com.jetbrains.rider.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.search.RiderTraverseUIHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/settings/search/RiderTraverseUIHelper;", "Lcom/intellij/ide/ui/search/TraverseUIHelper;", "()V", "traversalLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "afterConfigurable", "", "configurable", "Lcom/intellij/openapi/options/SearchableConfigurable;", "options", "", "Lcom/intellij/ide/ui/search/SearchableOptionEntry;", "afterResultsAreSaved", "beforeConfigurable", "beforeStart", "j", "message", "", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderTraverseUIHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderTraverseUIHelper.kt\ncom/jetbrains/rider/settings/search/RiderTraverseUIHelper\n+ 2 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n24#2:105\n800#3,11:106\n1855#3,2:118\n1#4:117\n*S KotlinDebug\n*F\n+ 1 RiderTraverseUIHelper.kt\ncom/jetbrains/rider/settings/search/RiderTraverseUIHelper\n*L\n37#1:105\n37#1:106,11\n51#1:118,2\n*E\n"})
public final class RiderTraverseUIHelper
implements TraverseUIHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LifetimeDefinition traversalLifetimeDef = new LifetimeDefinition();
    @NotNull
    private static final Logger logger;

    private final void j(String string) {
        logger.info(string);
        System.out.println((Object)string);
    }

    public void beforeStart() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
        Project project2 = project;
        IProtocolHostWithBackend iProtocolHostWithBackend = (IProtocolHostWithBackend)CollectionsKt.single((Iterable)((Iterable)ProtocolManager.Companion.getInstance().getProtocolHosts()));
        IProtocolHost iProtocolHost = (IProtocolHost)iProtocolHostWithBackend;
        boolean bl = false;
        Iterable iterable = iProtocolHost.getComponents();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            if (!(t instanceof ShellHost)) continue;
            collection.add(t);
        }
        ShellHost shellHost = (ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)collection)));
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        if (!ExtensionsKt.pumpMessages((Duration)duration, (Function0)((Function0)new Function0<Boolean>(shellHost){
            final /* synthetic */ ShellHost $shellHost;
            {
                this.$shellHost = $shellHost;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)this.$shellHost.isReady().getValue();
            }
        }))) {
            bl = false;
            String string = "Shell host was not ready in 1 minute";
            throw new IllegalArgumentException(string.toString());
        }
        iProtocolHost = SettingsViewModelHost.Companion.getOrCreate(project2);
        Duration duration2 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        if (!ExtensionsKt.pumpMessages((Duration)duration2, (Function0)((Function0)new Function0<Boolean>((SettingsViewModelHost)iProtocolHost){
            final /* synthetic */ SettingsViewModelHost $host;
            {
                this.$host = $host;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)this.$host.getCurrentDialog()));
            }
        }))) {
            boolean bl4 = false;
            String string = "Host settings dialog was not ready in 1 minute";
            throw new IllegalArgumentException(string.toString());
        }
        RiderBackendDispatcherKt.getDefaultBackend((IProtocolHost)((IProtocolHost)iProtocolHostWithBackend)).getLoggerModel().getMessage().advise(this.traversalLifetimeDef.getLifetime(), (Function1)new Function1<LogEntryBase, Unit>(this){
            final /* synthetic */ RiderTraverseUIHelper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull LogEntryBase it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getSeverity() == LogEntryType.WARN || it.getSeverity() == LogEntryType.ERROR) {
                    RiderTraverseUIHelper.access$info(this.this$0, "Backend log message: " + it.getSeverity() + " " + it.getLogMessage());
                }
            }
        });
    }

    public void afterResultsAreSaved() {
        ProtocolManager protocolManager = ProtocolManager.Companion.getInstance();
        boolean bl = false;
        Iterable iterable = (Iterable)protocolManager.getProtocolHosts();
        boolean bl2 = false;
        for (Object t : iterable) {
            IProtocolHostWithBackend iProtocolHostWithBackend = (IProtocolHostWithBackend)t;
            boolean bl3 = false;
            ApplicationKt.getApplication().invokeAndWait(() -> RiderTraverseUIHelper.j(protocolManager, iProtocolHostWithBackend));
            ReSharperProcessBase reSharperProcessBase = iProtocolHostWithBackend.getResharperProcess();
            if (reSharperProcessBase == null) continue;
            reSharperProcessBase.waitFor(false, (Function0)afterResultsAreSaved.1.1.2.INSTANCE);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.traversalLifetimeDef, (boolean)false, (int)1, null);
    }

    public void beforeConfigurable(@NotNull SearchableConfigurable configurable, @NotNull Set<SearchableOptionEntry> options) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        IRiderViewModelConfigurable iRiderViewModelConfigurable = ReSharperConfigurableUtilKt.unwrapReSharperConfigurable((Configurable)((Configurable)configurable));
        if (iRiderViewModelConfigurable == null) {
            return;
        }
        IRiderViewModelConfigurable iRiderViewModelConfigurable2 = iRiderViewModelConfigurable;
        List list2 = CollectionsKt.toList((Iterable)iRiderViewModelConfigurable2.getReSharperPagesId());
        Ref.IntRef intRef = new Ref.IntRef();
        int n2 = CollectionsKt.count((Iterable)iRiderViewModelConfigurable2.getReSharperPagesId());
        this.j("Before configurable " + iRiderViewModelConfigurable2.getClass().getName());
        if (n2 > 0) {
            RiderTraverseUIHelper.j(list2, intRef, this, n2, iRiderViewModelConfigurable2, configurable, options);
        }
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        if (!ExtensionsKt.pumpMessages((Duration)duration, (Function0)((Function0)new Function0<Boolean>(intRef, n2){
            final /* synthetic */ Ref.IntRef $havePages;
            final /* synthetic */ int $targetPages;
            {
                this.$havePages = $havePages;
                this.$targetPages = $targetPages;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$havePages.element == this.$targetPages;
            }
        }))) {
            boolean bl = false;
            String string = "Timeout while waiting for pages from " + iRiderViewModelConfigurable2.getClass().getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        this.j("Configurable " + iRiderViewModelConfigurable2.getClass().getName() + " processed in before, handing off to IDEA");
    }

    public void afterConfigurable(@NotNull SearchableConfigurable configurable, @NotNull Set<SearchableOptionEntry> options) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        IRiderViewModelConfigurable iRiderViewModelConfigurable = ReSharperConfigurableUtilKt.unwrapReSharperConfigurable((Configurable)((Configurable)configurable));
        if (iRiderViewModelConfigurable == null) {
            return;
        }
        IRiderViewModelConfigurable iRiderViewModelConfigurable2 = iRiderViewModelConfigurable;
        this.j("After configurable " + iRiderViewModelConfigurable2.getClass().getName());
    }

    private static final void j(ProtocolManager protocolManager, IProtocolHostWithBackend iProtocolHostWithBackend) {
        Intrinsics.checkNotNullParameter((Object)protocolManager, (String)"$pm");
        Intrinsics.checkNotNullParameter((Object)iProtocolHostWithBackend, (String)"$host");
        protocolManager.requestShutdown(iProtocolHostWithBackend);
    }

    private static final void j(List<String> list2, Ref.IntRef intRef, RiderTraverseUIHelper riderTraverseUIHelper, int n2, IRiderViewModelConfigurable iRiderViewModelConfigurable, SearchableConfigurable searchableConfigurable, Set<SearchableOptionEntry> set) {
        String string = list2.get(intRef.element);
        riderTraverseUIHelper.j("Requesting backend page " + string + " (" + (intRef.element + 1) + "/" + n2 + ")");
        SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
        Intrinsics.checkNotNull((Object)settingsViewModelHost);
        settingsViewModelHost.requestFullPage(string, (Function1)new Function1<OptionsPageInfo, Unit>(riderTraverseUIHelper, string, intRef, n2, iRiderViewModelConfigurable, searchableConfigurable, set, list2){
            final /* synthetic */ RiderTraverseUIHelper this$0;
            final /* synthetic */ String $pageId;
            final /* synthetic */ Ref.IntRef $havePages;
            final /* synthetic */ int $targetPages;
            final /* synthetic */ IRiderViewModelConfigurable $unwrapped;
            final /* synthetic */ SearchableConfigurable $configurable;
            final /* synthetic */ Set<SearchableOptionEntry> $options;
            final /* synthetic */ List<String> $sourcePages;
            {
                this.this$0 = $receiver;
                this.$pageId = $pageId;
                this.$havePages = $havePages;
                this.$targetPages = $targetPages;
                this.$unwrapped = $unwrapped;
                this.$configurable = $configurable;
                this.$options = $options;
                this.$sourcePages = $sourcePages;
                super(1);
            }

            public final void invoke(@NotNull OptionsPageInfo page) {
                Intrinsics.checkNotNullParameter((Object)page, (String)"page");
                RiderTraverseUIHelper.access$info(this.this$0, "Got page for id " + this.$pageId + ": " + page);
                RiderTraverseUIHelper.access$info(this.this$0, "have " + this.$havePages.element + " pages, target is " + this.$targetPages);
                SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
                Intrinsics.checkNotNull((Object)searchableOptionsRegistrar);
                SearchableOptionsRegistrar searchableOptionsRegistrar2 = searchableOptionsRegistrar;
                Iterator iterator2 = this.$unwrapped.getPageKeywords(page);
                int n2 = 0;
                Iterator iterator3 = iterator2;
                Set<SearchableOptionEntry> set = this.$options;
                SearchableConfigurable searchableConfigurable = this.$configurable;
                boolean bl = false;
                Iterator iterator4 = iterator3;
                while (iterator4.hasNext()) {
                    E e = iterator4.next();
                    String string = (String)e;
                    boolean bl2 = false;
                    ++n2;
                    String string2 = searchableConfigurable.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                    set.add(new SearchableOptionEntry(string2, string));
                }
                RiderTraverseUIHelper.access$info(this.this$0, "Registered " + n2 + " keywords for " + this.$configurable.getId());
                RiderTraverseUIHelper.access$info(this.this$0, "keyword registration finished for backend page " + this.$pageId + " (" + (this.$havePages.element + 1) + "/" + this.$targetPages + ")");
                int n3 = this.$havePages.element;
                this.$havePages.element = n3 + 1;
                if (this.$havePages.element < this.$targetPages) {
                    RiderTraverseUIHelper.access$beforeConfigurable$doNextPage(this.$sourcePages, this.$havePages, this.this$0, this.$targetPages, this.$unwrapped, this.$configurable, this.$options);
                }
            }
        });
    }

    public static final /* synthetic */ void access$info(RiderTraverseUIHelper $this, String message2) {
        $this.j(message2);
    }

    public static final /* synthetic */ void access$beforeConfigurable$doNextPage(List sourcePages, Ref.IntRef havePages, RiderTraverseUIHelper this$0, int targetPages, IRiderViewModelConfigurable unwrapped, SearchableConfigurable $configurable, Set $options) {
        RiderTraverseUIHelper.j(sourcePages, havePages, this$0, targetPages, unwrapped, $configurable, $options);
    }

    static {
        Logger logger2 = Logger.getInstance(RiderTraverseUIHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/search/RiderTraverseUIHelper$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

