/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.layers;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ui.JBDimension;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateInterceptor;
import com.jetbrains.rider.actions.RiderActionGroup;
import com.jetbrains.rider.actions.RiderActionPlaces;
import com.jetbrains.rider.actions.base.RiderBackendOnlyGroup;
import com.jetbrains.rider.model.Layer;
import com.jetbrains.rider.model.LayersModel;
import com.jetbrains.rider.model.ManageLayersDialog;
import com.jetbrains.rider.model.ManageLayersDialogContent;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.layers.LayersDialogKt;
import com.jetbrains.rider.settings.layers.LayersTreeFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/settings/layers/LayersDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "model", "Lcom/jetbrains/rider/model/LayersModel;", "outerLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rider/model/LayersModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "lifetime", "myManageLayersDialog", "Lcom/jetbrains/rider/model/ManageLayersDialog;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "dispose", "", "doHelpAction", "getDimensionServiceKey", "", "getInitialLocation", "Ljava/awt/Point;", "j", "panel", "Ljavax/swing/JPanel;", "content", "Lcom/jetbrains/rider/model/ManageLayersDialogContent;", "lt", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nLayersDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayersDialog.kt\ncom/jetbrains/rider/settings/layers/LayersDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,183:1\n65#2,4:184\n65#2,4:188\n65#2,4:192\n65#2,4:196\n65#2,4:200\n65#2,4:204\n*S KotlinDebug\n*F\n+ 1 LayersDialog.kt\ncom/jetbrains/rider/settings/layers/LayersDialog\n*L\n115#1:184,4\n118#1:188,4\n121#1:192,4\n122#1:196,4\n126#1:200,4\n140#1:204,4\n*E\n"})
public final class LayersDialog
extends DialogWrapper {
    @NotNull
    private final LayersModel model;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ManageLayersDialog myManageLayersDialog;

    public LayersDialog(@NotNull LayersModel model2, @NotNull Lifetime outerLifetime) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)outerLifetime, (String)"outerLifetime");
        super(true);
        this.model = model2;
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        this.lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
        this.myManageLayersDialog = new ManageLayersDialog();
        LayersDialogKt.access$getLogger$p().debug("before init");
        this.setModal(false);
        this.setTitle(SystemInfo.isMac ? RiderSettingsBundle.Companion.message("LayersDialog.dialog.title.settings.layers.macos", new Object[0]) : RiderSettingsBundle.Companion.message("LayersDialog.dialog.title.settings.layers", new Object[0]));
        this.init();
        LayersDialogKt.access$getLogger$p().debug("after init");
        outerLifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.close(1);
            }
        });
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = CommonBundle.message((String)"close.action.name", (Object[])new Object[0]);
        DialogWrapper.DialogWrapperAction dialogWrapperAction = new DialogWrapper.DialogWrapperAction(this, (String)actionArray){
            final /* synthetic */ LayersDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.close(0);
            }
        };
        actionArray = new Action[2];
        actionArray[0] = dialogWrapperAction;
        Intrinsics.checkNotNullExpressionValue((Object)this.getHelpAction(), (String)"getHelpAction(...)");
        return actionArray;
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)"https://www.jetbrains.com/help/rider/Sharing_Configuration_Options.html");
    }

    @NotNull
    public Point getInitialLocation() {
        Point point = this.getOwner().getLocation();
        Dimension dimension = this.getOwner().getSize();
        double d = 0.33;
        return new Point(point.x + (int)((double)dimension.width * d), point.y + (int)((double)dimension.height * d));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "LayersDialog";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        LayersDialogKt.access$getLogger$p().debug("createCenterPanel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        JBLoadingPanel jBLoadingPanel = new JBLoadingPanel(layoutManager, disposable, 0, 4, null);
        jBLoadingPanel.startLoading();
        jPanel.add((Component)jBLoadingPanel);
        jPanel.setMinimumSize((Dimension)new JBDimension(600, 350));
        InterfacesKt.viewNotNull((IViewable)((IViewable)this.myManageLayersDialog.getContent()), (Lifetime)this.lifetime, (Function2)((Function2)new Function2<Lifetime, ManageLayersDialogContent, Unit>(jBLoadingPanel, this, jPanel){
            final /* synthetic */ JBLoadingPanel $loadingPanel;
            final /* synthetic */ LayersDialog this$0;
            final /* synthetic */ JPanel $mainPanel;
            {
                this.$loadingPanel = $loadingPanel;
                this.this$0 = $receiver;
                this.$mainPanel = $mainPanel;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lt, @NotNull ManageLayersDialogContent content2) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                this.$loadingPanel.stopLoading();
                LayersDialogKt.access$getLogger$p().debug("reload layers");
                LayersDialog.access$repaintLayers(this.this$0, this.$mainPanel, content2, lt);
                content2.getLayers().advise(lt, (Function1)new Function1<List<? extends Layer>, Unit>(this.this$0, this.$mainPanel, content2, lt){
                    final /* synthetic */ LayersDialog this$0;
                    final /* synthetic */ JPanel $mainPanel;
                    final /* synthetic */ ManageLayersDialogContent $content;
                    final /* synthetic */ Lifetime $lt;
                    {
                        this.this$0 = $receiver;
                        this.$mainPanel = $mainPanel;
                        this.$content = $content;
                        this.$lt = $lt;
                        super(1);
                    }

                    public final void invoke(@NotNull List<Layer> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        LayersDialog.access$repaintLayers(this.this$0, this.$mainPanel, this.$content, this.$lt);
                    }
                });
            }
        }));
        this.model.getManageLayersDialog().setValue((Object)this.myManageLayersDialog);
        return jPanel;
    }

    protected void dispose() {
        this.model.getManageLayersDialog().setValue(null);
        super.dispose();
    }

    private final void j(JPanel jPanel, ManageLayersDialogContent manageLayersDialogContent, Lifetime lifetime2) {
        JPanel jPanel2;
        boolean bl;
        DefaultActionGroup defaultActionGroup;
        boolean bl2;
        Logger logger2;
        boolean bl3;
        Logger logger3;
        LayersDialogKt.access$getLogger$p().trace("Repainting layers.");
        LayersTreeFactory layersTreeFactory = new LayersTreeFactory();
        ActionManager actionManager2 = ActionManager.getInstance();
        String string = manageLayersDialogContent.getActionGroupId();
        if (FrontendActionUpdateInterceptor.Companion.isNewActionUpdateEnabled()) {
            logger3 = LayersDialogKt.access$getLogger$p();
            bl3 = false;
            if (logger3.isTraceEnabled()) {
                logger2 = logger3;
                bl2 = false;
                logger2.trace("New action update enabled. Initialize RiderBackendOnlyGroup(" + string + ").");
            }
            defaultActionGroup = (DefaultActionGroup)new RiderBackendOnlyGroup(string){};
        } else {
            logger3 = LayersDialogKt.access$getLogger$p();
            bl3 = false;
            if (logger3.isTraceEnabled()) {
                logger2 = logger3;
                bl2 = false;
                logger2.trace("New action update disabled. Initialize RiderActionGroup(" + string + ").");
            }
            defaultActionGroup = (DefaultActionGroup)new RiderActionGroup(string);
        }
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
        logger3 = LayersDialogKt.access$getLogger$p();
        bl3 = false;
        if (logger3.isTraceEnabled()) {
            logger2 = logger3;
            bl2 = false;
            logger2.trace("Actions in the action group: " + defaultActionGroup2.getChildrenCount() + ".");
        }
        logger3 = LayersDialogKt.access$getLogger$p();
        bl3 = false;
        if (logger3.isTraceEnabled()) {
            logger2 = logger3;
            bl2 = false;
            AnAction[] anActionArray = defaultActionGroup2.getChildActionsOrStubs();
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildActionsOrStubs(...)");
            logger2.trace("All actions: " + ArraysKt.joinToString$default((Object[])anActionArray, null, null, null, (int)0, null, (Function1)((Function1)new Function1<AnAction, CharSequence>(actionManager2){
                final /* synthetic */ ActionManager $actionManager;
                {
                    this.$actionManager = $actionManager;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(AnAction it) {
                    Intrinsics.checkNotNull((Object)it);
                    return LayersDialog.access$repaintLayers$getActionId(it, this.$actionManager);
                }
            }), (int)31, null) + ".");
        }
        logger3 = actionManager2.getAction("RiderEditSettingsLayerOptions");
        ActionGroup actionGroup2 = (ActionGroup)defaultActionGroup2;
        Intrinsics.checkNotNull((Object)logger3);
        TreeTable treeTable2 = layersTreeFactory.createTree(manageLayersDialogContent, actionGroup2, (AnAction)logger3, lifetime2);
        Logger logger4 = LayersDialogKt.access$getLogger$p();
        boolean bl4 = false;
        if (logger4.isTraceEnabled()) {
            logger2 = logger4;
            bl = false;
            logger2.trace("Tree " + treeTable2 + " created.");
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(RiderActionPlaces.INSTANCE.getSETTINGS_LAYERS_DIALOG(), (ActionGroup)defaultActionGroup2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        logger4 = actionToolbar;
        LayersDialogKt.access$getLogger$p().trace("Action toolbar created.");
        if (LayersDialogKt.access$getLogger$p().isTraceEnabled()) {
            logger4.addListener(new ActionToolbarListener((ActionToolbar)logger4, actionManager2){
                final /* synthetic */ ActionToolbar $toolbar;
                final /* synthetic */ ActionManager $actionManager;
                {
                    this.$toolbar = $toolbar;
                    this.$actionManager = $actionManager;
                }

                public void actionsUpdated() {
                    LayersDialogKt.access$getLogger$p().trace("Actions on toolbar updated.");
                    List list2 = this.$toolbar.getActions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActions(...)");
                    List list3 = list2;
                    LayersDialogKt.access$getLogger$p().trace("Actions count: " + list3.size() + ".");
                    LayersDialogKt.access$getLogger$p().trace("Actions: " + CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, (Function1)((Function1)new Function1<AnAction, CharSequence>(this.$actionManager){
                        final /* synthetic */ ActionManager $actionManager;
                        {
                            this.$actionManager = $actionManager;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(AnAction it) {
                            Intrinsics.checkNotNull((Object)it);
                            return LayersDialog.access$repaintLayers$getActionId(it, this.$actionManager);
                        }
                    }), (int)31, null) + ".");
                }
            }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime2, (String)"rider.settings.layers.LayersDialog::repaintLayers"));
        }
        logger4.setTargetComponent((JComponent)treeTable2);
        Logger logger5 = LayersDialogKt.access$getLogger$p();
        bl = false;
        if (logger5.isTraceEnabled()) {
            logger2 = logger5;
            boolean bl5 = false;
            logger2.trace("Toolbar initialized for a tree component " + treeTable2 + ".");
        }
        int n2 = -1;
        Component[] componentArray = jPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (!(((Object[])componentArray).length == 0)) {
            Component[] componentArray2 = jPanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"getComponents(...)");
            Component component2 = (Component)ArraysKt.last((Object[])componentArray2);
            if (component2 instanceof TreeTable) {
                n2 = ((TreeTable)component2).getSelectedRow();
            }
        }
        jPanel.removeAll();
        Serializable serializable = jPanel2 = new JPanel(new BorderLayout());
        int n3 = 0;
        serializable.add(logger4.getComponent(), "Center");
        serializable.setPreferredSize((Dimension)new JBDimension(1, 29));
        JPanel jPanel3 = jPanel2;
        jPanel.add((Component)jPanel3, "First");
        jPanel2 = new JBScrollPane((Component)treeTable2);
        serializable = jPanel2.getMinimumSize();
        jPanel2.setMinimumSize(new Dimension(((Dimension)serializable).width, 100));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.setBackground((Color)JBColor.LIGHT_GRAY);
        jPanel.validate();
        jPanel.repaint();
        this.repaint();
        treeTable2.requestFocus();
        n3 = treeTable2.getRowCount();
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        if (n2 >= 0 && n2 < n3) {
            n4 = n2;
        }
        treeTable2.getSelectionModel().addSelectionInterval(n4, n4);
    }

    private static final String j(AnAction anAction, ActionManager actionManager2) {
        String string = actionManager2.getId(anAction);
        if (string == null) {
            string = "<unknown action>";
        }
        return string;
    }

    public static final /* synthetic */ void access$repaintLayers(LayersDialog $this, JPanel panel2, ManageLayersDialogContent content2, Lifetime lt) {
        $this.j(panel2, content2, lt);
    }

    public static final /* synthetic */ String access$repaintLayers$getActionId(AnAction $receiver, ActionManager actionManager2) {
        return LayersDialog.j($receiver, actionManager2);
    }
}

