/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.exportImportWorkaround;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rider.model.ExportSessionModel;
import com.jetbrains.rider.model.ImportSessionModel;
import com.jetbrains.rider.model.SettingsHelperModel;
import com.jetbrains.rider.model.SettingsHelperModel_PregeneratedKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.ProtocolComponentFactoryKt;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.exportImportWorkaround.ExportSession;
import com.jetbrains.rider.settings.exportImportWorkaround.ImportSession;
import com.jetbrains.rider.settings.exportImportWorkaround.SettingsHelper;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/settings/exportImportWorkaround/SettingsHelper;", "Lcom/jetbrains/rider/protocol/ProtocolComponent;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "(Lcom/jetbrains/rider/protocol/IProtocolHost;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "helperModel", "Lcom/jetbrains/rider/model/SettingsHelperModel;", "mySequentialLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "createExportSession", "Lcom/jetbrains/rider/settings/exportImportWorkaround/ExportSession;", "createImportSession", "Lcom/jetbrains/rider/settings/exportImportWorkaround/ImportSession;", "file", "Ljava/io/File;", "exportToClangFormat", "", "exportToEditorConfig", "ideaExport", "", "j", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSettingsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsHelper.kt\ncom/jetbrains/rider/settings/exportImportWorkaround/SettingsHelper\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n13#2:113\n13#3:114\n*S KotlinDebug\n*F\n+ 1 SettingsHelper.kt\ncom/jetbrains/rider/settings/exportImportWorkaround/SettingsHelper\n*L\n33#1:113\n33#1:114\n*E\n"})
public final class SettingsHelper
extends ProtocolComponent {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final SettingsHelperModel helperModel;
    @NotNull
    private final SequentialLifetimes mySequentialLifetimes;

    public SettingsHelper(@NotNull IProtocolHost protocolHost) {
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        super(protocolHost);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(SettingsHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
        this.helperModel = SettingsHelperModel_PregeneratedKt.getSettingsHelperModel((IProtocol)this.getProtocol());
        this.mySequentialLifetimes = new SequentialLifetimes(this.getLifetime());
    }

    @Nullable
    public final ExportSession createExportSession() {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        this.j();
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.helperModel.isReady()))) {
            this.mySequentialLifetimes.defineNext((Function2)new Function2<LifetimeDefinition, Lifetime, Unit>(this, (Ref.ObjectRef<ExportSession>)objectRef){
                final /* synthetic */ SettingsHelper this$0;
                final /* synthetic */ Ref.ObjectRef<ExportSession> $session;
                {
                    this.this$0 = $receiver;
                    this.$session = $session;
                    super(2);
                }

                public final void invoke(@NotNull LifetimeDefinition def, @NotNull Lifetime lt) {
                    Intrinsics.checkNotNullParameter((Object)def, (String)"def");
                    Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                    ExportSessionModel exportSessionModel = new ExportSessionModel("ThisComputer");
                    InterfacesKt.setValue((IProperty)SettingsHelper.access$getHelperModel$p(this.this$0).getSession(), (Lifetime)lt, (Object)exportSessionModel);
                    this.$session.element = new ExportSession(exportSessionModel, def);
                }
            });
        }
        return (ExportSession)objectRef.element;
    }

    @Nullable
    public final ImportSession createImportSession(@Nullable File file2) {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        this.j();
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.helperModel.isReady()))) {
            this.mySequentialLifetimes.defineNext((Function2)new Function2<LifetimeDefinition, Lifetime, Unit>((Ref.ObjectRef<ImportSession>)objectRef, file2, this){
                final /* synthetic */ Ref.ObjectRef<ImportSession> $session;
                final /* synthetic */ File $file;
                final /* synthetic */ SettingsHelper this$0;
                {
                    this.$session = $session;
                    this.$file = $file;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull LifetimeDefinition def, @NotNull Lifetime lt) {
                    ImportSession importSession;
                    Intrinsics.checkNotNullParameter((Object)def, (String)"def");
                    Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                    if (this.$file != null) {
                        lt.onTermination((Function0)new Function0<Unit>(this.this$0, this.$file){
                            final /* synthetic */ SettingsHelper this$0;
                            final /* synthetic */ File $file;
                            {
                                this.this$0 = $receiver;
                                this.$file = $file;
                                super(0);
                            }

                            public final void invoke() {
                                Object object;
                                Logger logger2 = SettingsHelper.access$getLOG$p(this.this$0);
                                File file2 = this.$file;
                                boolean bl = false;
                                Logger logger3 = logger2;
                                try {
                                    object = logger3;
                                    boolean bl2 = false;
                                    boolean bl3 = false;
                                    object = Result.constructor-impl((Object)FileUtil.delete((File)file2));
                                }
                                catch (Throwable throwable) {
                                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                LoggerKt.getOrLogException((Object)object, (Logger)logger2);
                            }
                        });
                        String string = this.$file.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                        ImportSessionModel importSessionModel = new ImportSessionModel(string);
                        InterfacesKt.setValue((IProperty)SettingsHelper.access$getHelperModel$p(this.this$0).getSession(), (Lifetime)lt, (Object)importSessionModel);
                        importSession = new ImportSession(importSessionModel, def);
                    } else {
                        importSession = new ImportSession(null, def);
                    }
                    this.$session.element = importSession;
                }
            });
        }
        return (ImportSession)objectRef.element;
    }

    private final void j() {
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.helperModel.isReady()))) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.helperModel.isReady()), (Lifetime)((Lifetime)this.mySequentialLifetimes.next()), (Function1)((Function1)new Function1<Lifetime, Unit>(countDownLatch){
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.$latch = $latch;
                    super(1);
                }

                public final void invoke(@NotNull Lifetime it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$latch.countDown();
                }
            }));
            Project project = ProtocolComponentFactoryKt.getProject((ProtocolComponent)this);
            String string = RiderSettingsBundle.Companion.message("SettingsHelperFactory.dialog.title.preparing.to.show", new Object[0]);
            new Task.Modal(countDownLatch, project, string){
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.$latch = $latch;
                    super($super_call_param$1, $super_call_param$2, true);
                }

                public void run(@NotNull ProgressIndicator pi) {
                    Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
                    pi.setIndeterminate(true);
                    ApplicationKt.getApplication().invokeLater(waitBackend.2::j);
                    while (!pi.isCanceled() && !this.$latch.await(30L, TimeUnit.MILLISECONDS)) {
                    }
                }

                private static final void j() {
                    IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null).allowPumpProtocolUnderCurrentModality();
                }
            }.queue();
        }
    }

    public final void exportToEditorConfig(@NotNull String ideaExport) {
        Intrinsics.checkNotNullParameter((Object)ideaExport, (String)"ideaExport");
        this.j();
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.helperModel.isReady()))) {
            this.helperModel.getExportToEditorConfig().fire((Object)ideaExport);
        }
    }

    public final void exportToClangFormat() {
        this.j();
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.helperModel.isReady()))) {
            this.helperModel.getExportToClangFormat().fire((Object)Unit.INSTANCE);
        }
    }

    public static final /* synthetic */ SettingsHelperModel access$getHelperModel$p(SettingsHelper $this) {
        return $this.helperModel;
    }

    public static final /* synthetic */ Logger access$getLOG$p(SettingsHelper $this) {
        return $this.LOG;
    }
}

