/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.searchEverywhere.statistics;

import com.intellij.ide.actions.searcheverywhere.SearchAdapter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.searchEverywhere.statistics.ProtocolPerformanceTracker;
import com.jetbrains.rider.searchEverywhere.statistics.RiderSearchEverywhereTimeStat;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0016\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/searchEverywhere/statistics/PerformanceStatisticTracker;", "Lcom/intellij/ide/actions/searcheverywhere/SearchAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "performanceStatistic", "Lcom/jetbrains/rider/searchEverywhere/statistics/RiderSearchEverywhereTimeStat$PerformanceStatistic;", "protocolPerformanceTracker", "Lcom/jetbrains/rider/searchEverywhere/statistics/ProtocolPerformanceTracker;", "contributorFinished", "", "contributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "hasMore", "", "searchFinished", "hasMoreContributors", "", "searchStarted", "pattern", "", "contributors", "", "intellij.rider"})
public final class PerformanceStatisticTracker
extends SearchAdapter {
    @NotNull
    private final RiderSearchEverywhereTimeStat.PerformanceStatistic performanceStatistic;
    @NotNull
    private final ProtocolPerformanceTracker protocolPerformanceTracker;

    public PerformanceStatisticTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.performanceStatistic = new RiderSearchEverywhereTimeStat.PerformanceStatistic(project);
        this.protocolPerformanceTracker = new ProtocolPerformanceTracker(project, this.performanceStatistic);
    }

    public void contributorFinished(@NotNull SearchEverywhereContributor<?> contributor, boolean hasMore) {
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
        this.performanceStatistic.measureFinishTime(contributor);
    }

    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        Intrinsics.checkNotNullParameter(hasMoreContributors, (String)"hasMoreContributors");
        this.performanceStatistic.flushLoggedPerformanceStatistic();
    }

    public void searchStarted(@NotNull String pattern, @NotNull Collection<? extends SearchEverywhereContributor<?>> contributors) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(contributors, (String)"contributors");
        this.performanceStatistic.prepareStatistic();
        for (SearchEverywhereContributor<?> searchEverywhereContributor : contributors) {
            this.performanceStatistic.addContributorToMeasure(searchEverywhereContributor);
        }
        this.protocolPerformanceTracker.adviseToSearchSession();
    }
}

