/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.runtime;

import com.intellij.execution.CantRunException;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.DotNetRuntimeType;
import com.jetbrains.rider.runtime.RiderRuntimeBundle;
import com.jetbrains.rider.runtime.custom.CustomDotNetCoreRuntime;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntimeType;
import com.jetbrains.rider.runtime.mono.MonoRuntime;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import com.jetbrains.rider.runtime.msNet.MsNetRuntime;
import com.jetbrains.rider.runtime.msNet.MsNetRuntimeType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\u0005R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/runtime/RuntimeDetectionResult;", "", "type", "Lcom/jetbrains/rider/runtime/DotNetRuntimeType;", "runtime", "Lcom/jetbrains/rider/runtime/DotNetRuntime;", "(Lcom/jetbrains/rider/runtime/DotNetRuntimeType;Lcom/jetbrains/rider/runtime/DotNetRuntime;)V", "getRuntime", "()Lcom/jetbrains/rider/runtime/DotNetRuntime;", "getType", "()Lcom/jetbrains/rider/runtime/DotNetRuntimeType;", "getRuntimeOrThrow", "Companion", "intellij.rider"})
public final class RuntimeDetectionResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DotNetRuntimeType type;
    @Nullable
    private final DotNetRuntime runtime;

    public RuntimeDetectionResult(@NotNull DotNetRuntimeType type, @Nullable DotNetRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.runtime = runtime;
    }

    @NotNull
    public final DotNetRuntimeType getType() {
        return this.type;
    }

    @Nullable
    public final DotNetRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final DotNetRuntime getRuntimeOrThrow() {
        DotNetRuntime dotNetRuntime = this.runtime;
        if (dotNetRuntime == null) {
            DotNetRuntimeType dotNetRuntimeType = this.type;
            if (dotNetRuntimeType instanceof MsNetRuntimeType) {
                throw Companion.cantRunNetFramework();
            }
            if (dotNetRuntimeType instanceof MonoRuntimeType) {
                throw Companion.cantRunMono();
            }
            if (dotNetRuntimeType instanceof DotNetCoreRuntimeType) {
                throw Companion.cantRunNetCore();
            }
            Object[] objectArray = new Object[]{this.type.getName()};
            throw new CantRunException(RiderRuntimeBundle.Companion.message("RuntimeDetectionResult.dialog.message.unsupported.runtime.detected", objectArray));
        }
        return dotNetRuntime;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/runtime/RuntimeDetectionResult$Companion;", "", "()V", "cantRunMono", "Lcom/intellij/execution/CantRunException;", "cantRunNetCore", "cantRunNetFramework", "create", "Lcom/jetbrains/rider/runtime/RuntimeDetectionResult;", "runtime", "Lcom/jetbrains/rider/runtime/custom/CustomDotNetCoreRuntime;", "Lcom/jetbrains/rider/runtime/dotNetCore/DotNetCoreRuntime;", "Lcom/jetbrains/rider/runtime/mono/MonoRuntime;", "Lcom/jetbrains/rider/runtime/msNet/MsNetRuntime;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RuntimeDetectionResult create(@NotNull MsNetRuntime runtime) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            return new RuntimeDetectionResult(MsNetRuntimeType.INSTANCE, runtime);
        }

        @NotNull
        public final RuntimeDetectionResult create(@Nullable MonoRuntime runtime) {
            return new RuntimeDetectionResult(MonoRuntimeType.INSTANCE, runtime);
        }

        @NotNull
        public final RuntimeDetectionResult create(@Nullable DotNetCoreRuntime runtime) {
            return new RuntimeDetectionResult(DotNetCoreRuntimeType.INSTANCE, runtime);
        }

        @NotNull
        public final RuntimeDetectionResult create(@NotNull CustomDotNetCoreRuntime runtime) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            return new RuntimeDetectionResult(runtime.getType(), runtime);
        }

        @NotNull
        public final CantRunException cantRunNetFramework() {
            return new CantRunException(RiderRuntimeBundle.Companion.message("RuntimeDetectionResult.dialog.message.cant.run.net.framework", new Object[0]));
        }

        @NotNull
        public final CantRunException cantRunMono() {
            return new CantRunException(RiderRuntimeBundle.Companion.message("RuntimeDetectionResult.dialog.message.cant.run.mono", new Object[0]));
        }

        @NotNull
        public final CantRunException cantRunNetCore() {
            return new CantRunException(RiderRuntimeBundle.Companion.message("RuntimeDetectionResult.dialog.message.cant.run.net.core", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

