/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.devices;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.LayeredIcon;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.devices.ActiveDeviceManager;
import com.jetbrains.rider.run.devices.ActiveDeviceView;
import com.jetbrains.rider.run.devices.CompatibilityProblem;
import com.jetbrains.rider.run.devices.Device;
import com.jetbrains.rider.run.devices.DeviceKind;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/run/devices/ActiveDeviceAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "()V", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "button", "Ljavax/swing/JComponent;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "shouldShowDisabledActions", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "NoDeviceAction", "SelectDeviceAction", "intellij.rider"})
public final class ActiveDeviceAction
extends ComboBoxAction {
    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button3, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)button3, (String)"button");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        Object object = dataContext.getData(CommonDataKeys.PROJECT.getName());
        Project project = object instanceof Project ? (Project)object : null;
        if (project == null) {
            return defaultActionGroup;
        }
        Project project2 = project;
        ActiveDeviceManager activeDeviceManager = ActiveDeviceManager.Companion.getInstance(project2);
        defaultActionGroup.addAll((Collection)activeDeviceManager.getDeviceConfigurationActions());
        object = activeDeviceManager.getDevice();
        TasksKt.runWithModalProgressBlocking((Project)project2, (String)RiderRunBundle.Companion.message("ActiveDeviceAction.progress.title.refresh", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(activeDeviceManager, defaultActionGroup, (Device)object, null){
            int label;
            final /* synthetic */ ActiveDeviceManager $manager;
            final /* synthetic */ DefaultActionGroup $group;
            final /* synthetic */ Device $activeDevice;
            {
                this.$manager = $manager;
                this.$group = $group;
                this.$activeDevice = $activeDevice;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$manager.getDevices((Continuation<? super LinkedHashMap<DeviceKind, List<Pair<Device, CompatibilityProblem>>>>)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 4 sources

                        for (Map.Entry<K, V> var3_4 : ((Map)v0).entrySet()) {
                            var4_5 = (DeviceKind)var3_4.getKey();
                            var5_6 = (List)var3_4.getValue();
                            var6_7 = var4_5.getCategoryName();
                            this.$group.addSeparator(var6_7);
                            if (CollectionsKt.any((Iterable)var5_6)) {
                                for (Pair var8_9 : var5_6) {
                                    var9_10 = (Device)var8_9.component1();
                                    var10_11 = (CompatibilityProblem)var8_9.component2();
                                    this.$group.add((AnAction)new SelectDeviceAction(var9_10, var10_11, Intrinsics.areEqual((Object)this.$activeDevice, (Object)var9_10)));
                                }
                                continue;
                            }
                            this.$group.add((AnAction)new NoDeviceAction(var4_5));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return defaultActionGroup;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ActiveDeviceView activeDeviceView = (ActiveDeviceView)ActiveDeviceManager.Companion.getInstance(project).getActiveDeviceView().getValue();
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainMenu")) {
            e.getPresentation().setEnabled(activeDeviceView != null && BuildHost.Companion.isIdle(project));
            e.getPresentation().setText(RiderRunBundle.Companion.message("ActiveDeviceAction.action.change", new Object[0]));
            return;
        }
        if (activeDeviceView == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(BuildHost.Companion.isIdle(project));
        e.getPresentation().setText(activeDeviceView.getName());
        e.getPresentation().setIcon(activeDeviceView.getIcon());
        e.getPresentation().setDescription(activeDeviceView.getTooltip());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/run/devices/ActiveDeviceAction$NoDeviceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "deviceKind", "Lcom/jetbrains/rider/run/devices/DeviceKind;", "(Lcom/jetbrains/rider/run/devices/DeviceKind;)V", "getDeviceKind", "()Lcom/jetbrains/rider/run/devices/DeviceKind;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
    private static final class NoDeviceAction
    extends AnAction {
        @NotNull
        private final DeviceKind deviceKind;

        public NoDeviceAction(@NotNull DeviceKind deviceKind) {
            Intrinsics.checkNotNullParameter((Object)deviceKind, (String)"deviceKind");
            this.deviceKind = deviceKind;
        }

        @NotNull
        public final DeviceKind getDeviceKind() {
            return this.deviceKind;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(false);
            e.getPresentation().setText(this.deviceKind.getMissingMessage());
            e.getPresentation().setIcon(this.deviceKind.getMissingIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/run/devices/ActiveDeviceAction$SelectDeviceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "device", "Lcom/jetbrains/rider/run/devices/Device;", "compatibilityProblem", "Lcom/jetbrains/rider/run/devices/CompatibilityProblem;", "isActive", "", "(Lcom/jetbrains/rider/run/devices/Device;Lcom/jetbrains/rider/run/devices/CompatibilityProblem;Z)V", "getCompatibilityProblem", "()Lcom/jetbrains/rider/run/devices/CompatibilityProblem;", "getDevice", "()Lcom/jetbrains/rider/run/devices/Device;", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
    private static final class SelectDeviceAction
    extends AnAction {
        @NotNull
        private final Device device;
        @Nullable
        private final CompatibilityProblem compatibilityProblem;
        private final boolean isActive;

        public SelectDeviceAction(@NotNull Device device, @Nullable CompatibilityProblem compatibilityProblem, boolean isActive) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            this.device = device;
            this.compatibilityProblem = compatibilityProblem;
            this.isActive = isActive;
        }

        @NotNull
        public final Device getDevice() {
            return this.device;
        }

        @Nullable
        public final CompatibilityProblem getCompatibilityProblem() {
            return this.compatibilityProblem;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(this.device.getName());
            e.getPresentation().setIcon(this.isActive ? LayeredIcon.Companion.create(this.device.getIcon(), AllIcons.Nodes.DoneMark) : this.device.getIcon());
            if (this.compatibilityProblem != null) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().putClientProperty(new Key("ToolTipText"), (Object)this.compatibilityProblem.getMessage());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.compatibilityProblem != null) {
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ActiveDeviceManager.Companion.getInstance(project2).setActiveDevice(this.device);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }
}

