/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.uwp;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.LifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.uwp.UwpConfiguration;
import com.jetbrains.rider.run.configurations.uwp.UwpConfigurationParameters;
import com.jetbrains.rider.run.configurations.uwp.UwpConfigurationViewModel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/LifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/uwp/UwpConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "viewModel", "Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationViewModel;)V", "applyEditorTo", "", "s", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resetEditorFrom", "intellij.rider"})
public final class UwpConfigurationEditor
extends LifetimedSettingsEditor<UwpConfiguration> {
    @NotNull
    private final Project project;
    public UwpConfigurationViewModel viewModel;

    public UwpConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final UwpConfigurationViewModel getViewModel() {
        UwpConfigurationViewModel uwpConfigurationViewModel = this.viewModel;
        if (uwpConfigurationViewModel != null) {
            return uwpConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull UwpConfigurationViewModel uwpConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)uwpConfigurationViewModel, (String)"<set-?>");
        this.viewModel = uwpConfigurationViewModel;
    }

    protected void resetEditorFrom(@NotNull UwpConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        UwpConfigurationParameters uwpConfigurationParameters = s.getUwpParameters();
        this.getViewModel().reset(uwpConfigurationParameters.getProjectFilePath(), s.getUwpParameters().getProgramParameters());
    }

    protected void applyEditorTo(@NotNull UwpConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        RunnableProject runnableProject = (RunnableProject)this.getViewModel().getProjectSelector().getProject().getValueOrNull();
        if (runnableProject != null) {
            s.getUwpParameters().setProjectFilePath(runnableProject.getProjectFilePath());
        }
        s.getUwpParameters().setProgramParameters((String)this.getViewModel().getProgramParametersEditor().getParametersString().getValue());
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        ProjectSelector projectSelector = new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project");
        String string = ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setViewModel(new UwpConfigurationViewModel(projectSelector, new ProgramParametersEditor(string, "Program_arguments", lifetime2), ProjectExKt.getRunnableProjectsModelIfAvailable(this.project), lifetime2));
        return new ControlViewBuilder(lifetime2, this.project, "UwpProject").build(this.getViewModel());
    }
}

