/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.project;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.run.configurations.ConfigurationContextExKt;
import com.jetbrains.rider.run.configurations.RiderProjectConfigurationProducerBase;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfiguration;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationParameters;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationType;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationProducer;", "Lcom/jetbrains/rider/run/configurations/RiderProjectConfigurationProducerBase;", "Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfiguration;", "()V", "isConfigurationFromContext", "", "configurationConfiguration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "trySetupConfigurationFromRunnableProject", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "configuration", "selectedProjectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "intellij.rider"})
public final class DotNetProjectConfigurationProducer
extends RiderProjectConfigurationProducerBase<DotNetProjectConfiguration> {
    public DotNetProjectConfigurationProducer() {
        super(DotNetProjectConfigurationType.class);
    }

    public boolean isConfigurationFromContext(@NotNull DotNetProjectConfiguration configurationConfiguration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configurationConfiguration, (String)"configurationConfiguration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectModelEntity projectModelEntity = ConfigurationContextExKt.getSelectedProject(context);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        File file2 = ProjectModelEntityExtensionsKt.getFile((ProjectModelEntity)projectModelEntity2);
        String string = file2 != null ? file2.getPath() : null;
        if (string == null) {
            string = "";
        }
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)string), (Object)configurationConfiguration.getParameters().getProjectFilePath());
    }

    @Override
    protected boolean trySetupConfigurationFromRunnableProject(@NotNull RunnableProject runnableProject, @NotNull DotNetProjectConfiguration configuration, @NotNull ProjectModelEntity selectedProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)selectedProjectEntity, (String)"selectedProjectEntity");
        if (!DotNetProjectConfigurationType.Companion.isTypeApplicable(runnableProject.getKind())) {
            return false;
        }
        ProjectOutput projectOutput = (ProjectOutput)CollectionsKt.singleOrNull((List)runnableProject.getProjectOutputs());
        configuration.setName(runnableProject.getFullName());
        configuration.getParameters().setProjectFilePath(runnableProject.getProjectFilePath());
        configuration.getParameters().setProjectKind(runnableProject.getKind());
        DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters = configuration.getParameters();
        Object object = projectOutput;
        if (object == null || (object = object.getTfm()) == null || (object = object.getPresentableName()) == null) {
            object = "";
        }
        dotNetProjectConfigurationParameters.setProjectTfm((String)object);
        DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters2 = configuration.getParameters();
        Object object2 = projectOutput;
        if (object2 == null || (object2 = object2.getExePath()) == null) {
            object2 = "";
        }
        dotNetProjectConfigurationParameters2.setExePath((String)object2);
        DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters3 = configuration.getParameters();
        Object object3 = projectOutput;
        if (object3 == null || (object3 = object3.getDefaultArguments()) == null) {
            object3 = CollectionsKt.emptyList();
        }
        String string = ParametersListUtil.join((List)object3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        dotNetProjectConfigurationParameters3.setProgramParameters(string);
        DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters4 = configuration.getParameters();
        Object object4 = projectOutput;
        if (object4 == null || (object4 = object4.getWorkingDirectory()) == null) {
            object4 = "";
        }
        dotNetProjectConfigurationParameters4.setWorkingDirectory((String)object4);
        return true;
    }
}

