/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.project;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.LifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.AnchoredPanel;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.FlagEditor;
import com.jetbrains.rider.run.configurations.controls.PathSelector;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.StringSelector;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.controls.ViewSeparator;
import com.jetbrains.rider.run.configurations.controls.runtimeSelection.RuntimeSelector;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettings;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettingsEditor;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfiguration;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationEditor;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationParameters;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationViewModel;
import com.jetbrains.rider.runtime.DotNetRuntimeType;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/LifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "viewModel", "Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationViewModel;)V", "applyEditorTo", "", "configuration", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resetEditorFrom", "intellij.rider"})
public final class DotNetProjectConfigurationEditor
extends LifetimedSettingsEditor<DotNetProjectConfiguration> {
    @NotNull
    private final Project project;
    public DotNetProjectConfigurationViewModel viewModel;

    public DotNetProjectConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final DotNetProjectConfigurationViewModel getViewModel() {
        DotNetProjectConfigurationViewModel dotNetProjectConfigurationViewModel = this.viewModel;
        if (dotNetProjectConfigurationViewModel != null) {
            return dotNetProjectConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull DotNetProjectConfigurationViewModel dotNetProjectConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)dotNetProjectConfigurationViewModel, (String)"<set-?>");
        this.viewModel = dotNetProjectConfigurationViewModel;
    }

    protected void resetEditorFrom(@NotNull DotNetProjectConfiguration configuration) {
        DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters2 = dotNetProjectConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        this.getViewModel().reset(dotNetProjectConfigurationParameters2.getProjectFilePath(), dotNetProjectConfigurationParameters2.getTrackProjectExePath(), dotNetProjectConfigurationParameters2.getTrackProjectArguments(), dotNetProjectConfigurationParameters2.getTrackProjectWorkingDirectory(), dotNetProjectConfigurationParameters2.getProjectTfm(), dotNetProjectConfigurationParameters2.getExePath(), dotNetProjectConfigurationParameters2.getProgramParameters(), dotNetProjectConfigurationParameters2.getWorkingDirectory(), dotNetProjectConfigurationParameters2.getEnvs(), dotNetProjectConfigurationParameters2.isPassParentEnvs(), dotNetProjectConfigurationParameters2.getRuntimeType(), dotNetProjectConfigurationParameters2.getRuntimeArguments(), dotNetProjectConfigurationParameters2.getUseExternalConsole(), dotNetProjectConfigurationParameters2.getStartBrowserParameters());
    }

    protected void applyEditorTo(@NotNull DotNetProjectConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RunnableProject runnableProject = (RunnableProject)this.getViewModel().getProjectSelector().getProject().getValueOrNull();
        String string = (String)this.getViewModel().getTfmSelector().getString().getValueOrNull();
        if (runnableProject != null) {
            configuration.getParameters().setProjectFilePath(runnableProject.getProjectFilePath());
            if (string != null) {
                DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters;
                DotNetProjectConfigurationParameters dotNetProjectConfigurationParameters2 = dotNetProjectConfigurationParameters = configuration.getParameters();
                boolean bl = false;
                dotNetProjectConfigurationParameters2.setProjectKind(runnableProject.getKind());
                dotNetProjectConfigurationParameters2.setTrackProjectExePath(this.getViewModel().getTrackProjectExePath());
                dotNetProjectConfigurationParameters2.setTrackProjectArguments(this.getViewModel().getTrackProjectArguments());
                dotNetProjectConfigurationParameters2.setTrackProjectWorkingDirectory(this.getViewModel().getTrackProjectWorkingDirectory());
                dotNetProjectConfigurationParameters2.setProjectTfm(string);
                String string2 = FileUtil.toSystemIndependentName((String)((String)this.getViewModel().getExePathSelector().getPath().getValue()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
                dotNetProjectConfigurationParameters2.setExePath(string2);
                dotNetProjectConfigurationParameters2.setProgramParameters((String)this.getViewModel().getProgramParametersEditor().getParametersString().getValue());
                String string3 = FileUtil.toSystemIndependentName((String)((String)this.getViewModel().getWorkingDirectorySelector().getPath().getValue()));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
                dotNetProjectConfigurationParameters2.setWorkingDirectory(string3);
                dotNetProjectConfigurationParameters2.setEnvs((Map)this.getViewModel().getEnvironmentVariablesEditor().getEnvs().getValue());
                dotNetProjectConfigurationParameters2.setPassParentEnvs((Boolean)this.getViewModel().getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
                configuration.getParameters().setRuntimeType((DotNetRuntimeType)this.getViewModel().getRuntimeSelector().getRuntime().getValue());
                dotNetProjectConfigurationParameters2.setRuntimeArguments((String)this.getViewModel().getRuntimeArgumentsEditor().getParametersString().getValue());
                dotNetProjectConfigurationParameters2.setUseExternalConsole((Boolean)this.getViewModel().getUseExternalConsoleEditor().isSelected().getValue());
                dotNetProjectConfigurationParameters2.getStartBrowserParameters().setUrl((String)this.getViewModel().getUrlEditor().getText().getValue());
                dotNetProjectConfigurationParameters2.getStartBrowserParameters().setBrowser(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getMyBrowser());
                dotNetProjectConfigurationParameters2.getStartBrowserParameters().setStartAfterLaunch(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getStartAfterLaunch());
                dotNetProjectConfigurationParameters2.getStartBrowserParameters().setWithJavaScriptDebugger(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getWithJavaScriptDebugger());
            }
        }
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable(this.project);
        ProjectSelector projectSelector = new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project");
        StringSelector stringSelector = new StringSelector(RiderRunBundle.Companion.message("label.target.framework.with.colon", new Object[0]), "Target_framework");
        PathSelector pathSelector = new PathSelector(RiderRunBundle.Companion.message("label.exe.path.with.colon", new Object[0]), "Exe_path", new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(arg_0 -> DotNetProjectConfigurationEditor.j(createEditor.1.INSTANCE, arg_0)), lifetime2);
        String string = ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setViewModel(new DotNetProjectConfigurationViewModel(lifetime2, this.project, runnableProjectsModel, projectSelector, stringSelector, pathSelector, new ProgramParametersEditor(string, "Program_arguments", lifetime2), new PathSelector(RiderRunBundle.Companion.message("label.working.directory.with.colon", new Object[0]), "Working_directory", FileChooserDescriptorFactory.createSingleFolderDescriptor(), lifetime2), new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false, 4, null), new RuntimeSelector(RiderRunBundle.Companion.message("label.runtime", new Object[0]), "Runtime", this.project, lifetime2), new ProgramParametersEditor(RiderRunBundle.Companion.message("label.runtime.arguments.with.colons", new Object[0]), "Runtime_arguments", lifetime2), new FlagEditor(RiderRunBundle.Companion.message("label.use.external.console", new Object[0]), "Use_external_console"), new ViewSeparator(RiderRunBundle.Companion.message("label.open.browser", new Object[0])), new TextEditor(RiderRunBundle.Companion.message("label.url", new Object[0]), "URL", lifetime2), new BrowserSettingsEditor("")));
        AnchoredPanel anchoredPanel = new ControlViewBuilder(lifetime2, this.project, "DotNetProject").build(this.getViewModel());
        int n2 = anchoredPanel.getMinimumSize().width;
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(n2, 0));
        jPanel.setPreferredSize(new Dimension(0, 0));
        anchoredPanel.add(jPanel);
        return anchoredPanel;
    }

    private static final boolean j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Boolean)function1.invoke(object);
    }
}

