/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.project;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.rider.debugger.IRiderDebuggable;
import com.jetbrains.rider.run.ICanRunFromBackend;
import com.jetbrains.rider.run.configurations.IDotNetRunConfigurationWithPostStartupActivitiesSupport;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.PostStartupActivitiesUtilKt;
import com.jetbrains.rider.run.configurations.RiderAsyncRunConfiguration;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationParameters;
import com.jetbrains.rider.run.configurations.project.DotNetProjectExecutorFactory;
import com.jetbrains.rider.run.startupActivities.IPostStartupActivity;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfiguration;", "Lcom/jetbrains/rider/run/configurations/RiderAsyncRunConfiguration;", "Lcom/jetbrains/rider/debugger/IRiderDebuggable;", "Lcom/jetbrains/rider/run/ICanRunFromBackend;", "Lcom/jetbrains/rider/run/configurations/IProjectBasedRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/IDotNetRunConfigurationWithPostStartupActivitiesSupport;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "parameters", "Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationParameters;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationParameters;)V", "getParameters", "()Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationParameters;", "acceptsPostStartupActivity", "", "activityClass", "Ljava/lang/Class;", "Lcom/jetbrains/rider/run/startupActivities/IPostStartupActivity;", "checkConfiguration", "", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "createPostStartupActivity", "runProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/execution/configurations/RunProfileState;Lcom/intellij/execution/runners/ExecutionEnvironment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getProjectFilePath", "getTypeId", "isNative", "readExternal", "element", "Lorg/jdom/Element;", "setProjectFilePath", "path", "writeExternal", "intellij.rider"})
public final class DotNetProjectConfiguration
extends RiderAsyncRunConfiguration
implements IRiderDebuggable,
ICanRunFromBackend,
IProjectBasedRunConfiguration,
IDotNetRunConfigurationWithPostStartupActivitiesSupport {
    @NotNull
    private final DotNetProjectConfigurationParameters parameters;

    public DotNetProjectConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull DotNetProjectConfigurationParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)((Object)parameters), (String)"parameters");
        super(name, project, factory, (Function1<? super Project, ? extends SettingsEditor<? extends RunConfiguration>>)((Function1)1.INSTANCE), new DotNetProjectExecutorFactory(project, parameters));
        this.parameters = parameters;
    }

    @NotNull
    public final DotNetProjectConfigurationParameters getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public String getTypeId() {
        String string = this.getType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.parameters.getProjectFilePath();
    }

    @Override
    public void setProjectFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.parameters.setProjectFilePath(path);
    }

    public void checkConfiguration() {
        super.checkConfiguration();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.parameters.validate(RiderDotNetActiveRuntimeHost.Companion.getInstance(project));
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        this.parameters.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.parameters.writeExternal(element);
    }

    @Override
    public boolean isNative() {
        return this.parameters.isNative();
    }

    @Override
    public boolean acceptsPostStartupActivity(@NotNull Class<? extends IPostStartupActivity> activityClass) {
        Intrinsics.checkNotNullParameter(activityClass, (String)"activityClass");
        return PostStartupActivitiesUtilKt.acceptsDefaultPostStartupActivity(activityClass);
    }

    @Override
    @Nullable
    public Object createPostStartupActivity(@NotNull RunProfileState runProfileState, @NotNull ExecutionEnvironment environment, @NotNull Continuation<? super IPostStartupActivity> $completion) {
        return PostStartupActivitiesUtilKt.createDefaultPostStartupActivity(runProfileState, environment, $completion);
    }

    @NotNull
    public RunConfiguration clone() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        DotNetProjectConfiguration dotNetProjectConfiguration = new DotNetProjectConfiguration(string, project, configurationFactory, this.parameters.copy());
        dotNetProjectConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        this.copyCopyableDataTo((UserDataHolderBase)dotNetProjectConfiguration);
        return (RunConfiguration)dotNetProjectConfiguration;
    }
}

