/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.run.configurations.ConfigurationContextExKt;
import com.jetbrains.rider.run.configurations.RiderProjectConfigurationProducerBase;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.RiderMacConfigurationType;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/RiderMacConfigurationProducer;", "Lcom/jetbrains/rider/run/configurations/RiderProjectConfigurationProducerBase;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfiguration;", "()V", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "trySetupConfigurationFromRunnableProject", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "selectedProjectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "intellij.rider"})
public final class RiderMacConfigurationProducer
extends RiderProjectConfigurationProducerBase<MacRunConfiguration> {
    public RiderMacConfigurationProducer() {
        super(RiderMacConfigurationType.class);
    }

    @Override
    protected boolean trySetupConfigurationFromRunnableProject(@NotNull RunnableProject runnableProject, @NotNull MacRunConfiguration configuration, @NotNull ProjectModelEntity selectedProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)selectedProjectEntity, (String)"selectedProjectEntity");
        if (!RiderMacConfigurationType.Companion.isTypeApplicable(runnableProject.getKind())) {
            return false;
        }
        configuration.setName(runnableProject.getFullName());
        configuration.getMacParameters().setProjectFilePath(runnableProject.getProjectFilePath());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull MacRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectModelEntity projectModelEntity = ConfigurationContextExKt.getSelectedProject(context);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        File file2 = ProjectModelEntityExtensionsKt.getFile((ProjectModelEntity)projectModelEntity2);
        String string = file2 != null ? file2.getPath() : null;
        if (string == null) {
            string = "";
        }
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)string), (Object)configuration.getMacParameters().getProjectFilePath());
    }
}

