/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.AreaInstance;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.IExecutorFactory;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfigurationExtension;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfigurationParameters;
import com.jetbrains.rider.run.multiPlatform.mac.MacDebugProfileState;
import com.jetbrains.rider.run.multiPlatform.mac.MacRunProfileState;
import com.jetbrains.rider.util.NetUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunExecutorFactory;", "Lcom/jetbrains/rider/run/configurations/IExecutorFactory;", "macParameters", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters;", "(Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters;)V", "create", "Lcom/intellij/execution/configurations/RunProfileState;", "executorId", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.rider"})
public final class MacRunExecutorFactory
implements IExecutorFactory {
    @NotNull
    private final MacRunConfigurationParameters macParameters;

    public MacRunExecutorFactory(@NotNull MacRunConfigurationParameters macParameters) {
        Intrinsics.checkNotNullParameter((Object)macParameters, (String)"macParameters");
        this.macParameters = macParameters;
    }

    @Override
    @NotNull
    public RunProfileState create(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
        RunProfileState runProfileState;
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String string = executorId;
        if (Intrinsics.areEqual((Object)string, (Object)"Debug")) {
            runProfileState = new MacDebugProfileState(this.macParameters.toExecutable(true), NetUtils.INSTANCE.findFreePort(8765), environment);
        } else if (Intrinsics.areEqual((Object)string, (Object)"Run")) {
            runProfileState = new MacRunProfileState(environment, MacRunConfigurationParameters.toExecutable$default(this.macParameters, false, 1, null));
        } else {
            for (MacRunConfigurationExtension macRunConfigurationExtension : (MacRunConfigurationExtension[])MacRunConfigurationExtension.Companion.getEP_NAME().getExtensions((AreaInstance)environment.getProject())) {
                if (!macRunConfigurationExtension.canExecute(executorId)) continue;
                return macRunConfigurationExtension.executor(MacRunConfigurationParameters.toExecutable$default(this.macParameters, false, 1, null), environment);
            }
            Object[] objectArray = new Object[]{executorId};
            throw new CantRunException(RiderRunBundle.Companion.message("dialog.message.unsupported.executor.error", objectArray));
        }
        return runProfileState;
    }
}

