/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.ios;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfigurationEditor;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfigurationParameters;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConfigurationViewModel;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfiguration;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/ios/IOSConfigurationViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyEditorTo", "", "c", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resetEditorFrom", "intellij.rider"})
public final class IOSConfigurationEditor
extends RiderMultiPlatformConfigurationEditor<IOSConfiguration, IOSConfigurationViewModel> {
    @NotNull
    private final Project project;

    public IOSConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    protected void resetEditorFrom(@NotNull IOSConfiguration c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        IOSConfigurationParameters iOSConfigurationParameters = c.getIOSParameters();
        ((IOSConfigurationViewModel)this.getViewModel()).reset(iOSConfigurationParameters.getProjectFilePath(), iOSConfigurationParameters.getEnvs(), iOSConfigurationParameters.isPassParentEnvs(), iOSConfigurationParameters.getExtraMlaunchParameters());
    }

    protected void applyEditorTo(@NotNull IOSConfiguration c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        RunnableProject runnableProject = (RunnableProject)((IOSConfigurationViewModel)this.getViewModel()).getProjectSelector().getProject().getValueOrNull();
        if (runnableProject != null) {
            IOSConfigurationParameters iOSConfigurationParameters = c.getIOSParameters();
            iOSConfigurationParameters.setProjectFilePath(runnableProject.getProjectFilePath());
            iOSConfigurationParameters.setEnvs(MapsKt.toMutableMap((Map)((Map)((IOSConfigurationViewModel)this.getViewModel()).getEnvironmentVariablesEditor().getEnvs().getValue())));
            iOSConfigurationParameters.setPassParentEnvs((Boolean)((IOSConfigurationViewModel)this.getViewModel()).getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
            iOSConfigurationParameters.setExtraMlaunchParameters((String)((IOSConfigurationViewModel)this.getViewModel()).getExtraMlaunchParametersEditor().getText().getValue());
        }
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        this.setViewModel((RunConfigurationViewModelBase)new IOSConfigurationViewModel(new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project"), new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false), new TextEditor(RiderMultiPlatformBundle.Companion.message("rider.ios.extra.mlaunch.parameters.message", new Object[0]), "Extra_mlaunch_Parameters", lifetime2), ProjectExKt.getRunnableProjectsModelIfAvailable(this.project), lifetime2));
        return new ControlViewBuilder(lifetime2, this.project, "XamarinIOSProject").build((RunConfigurationViewModelBase)this.getViewModel());
    }
}

