/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationParameters;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H&J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfigurationParameters;", "", "programParameters", "", "projectFilePath", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "getProgramParameters", "()Ljava/lang/String;", "setProgramParameters", "(Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProjectFilePath", "setProjectFilePath", "readExternal", "", "element", "Lorg/jdom/Element;", "tryGetRunnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "tryGetTfm", "Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "runnableProject", "validate", "writeExternal", "Companion", "intellij.rider"})
public abstract class RiderMultiPlatformConfigurationParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String programParameters;
    @NotNull
    private String projectFilePath;
    @NotNull
    private final Project project;
    @NotNull
    private static final String PROJECT_PATH = "PROJECT_PATH";
    @NotNull
    private static final String PROGRAM_PARAMETERS = "PROGRAM_PARAMETERS";

    public RiderMultiPlatformConfigurationParameters(@NotNull String programParameters, @NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)programParameters, (String)"programParameters");
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.programParameters = programParameters;
        this.projectFilePath = projectFilePath;
        this.project = project;
    }

    @NotNull
    public final String getProgramParameters() {
        return this.programParameters;
    }

    public final void setProgramParameters(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.programParameters = string;
    }

    @NotNull
    public final String getProjectFilePath() {
        return this.projectFilePath;
    }

    public final void setProjectFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.projectFilePath = string;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public abstract RunnableProject tryGetRunnableProject();

    @Nullable
    public final RdTargetFrameworkId tryGetTfm(@Nullable RunnableProject runnableProject) {
        Object object = runnableProject;
        return object != null && (object = object.getProjectOutputs()) != null && (object = (ProjectOutput)CollectionsKt.singleOrNull((List)object)) != null ? object.getTfm() : null;
    }

    @Nullable
    public final RdTargetFrameworkId tryGetTfm() {
        return this.tryGetTfm(this.tryGetRunnableProject());
    }

    public void validate() {
        if (!Intrinsics.areEqual((Object)SolutionHostExtensionsKt.getSolution((Project)this.project).isLoaded().getValueOrNull(), (Object)true)) {
            throw new RuntimeConfigurationError(DotNetProjectConfigurationParameters.Companion.getSOLUTION_IS_LOADING());
        }
        RunnableProject runnableProject = this.tryGetRunnableProject();
        if (runnableProject == null) {
            throw new RuntimeConfigurationError(DotNetProjectConfigurationParameters.Companion.getPROJECT_NOT_SPECIFIED());
        }
        RunnableProject runnableProject2 = runnableProject;
        CharSequence charSequence = runnableProject2.getProblems();
        if (!(charSequence == null || charSequence.length() == 0)) {
            throw new RuntimeConfigurationError(runnableProject2.getProblems());
        }
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = JDOMExternalizerUtil.readField((Element)element, (String)PROJECT_PATH);
        this.projectFilePath = string == null ? "" : string;
        string = JDOMExternalizerUtil.readField((Element)element, (String)PROGRAM_PARAMETERS);
        this.programParameters = string == null ? "" : string;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JDOMExternalizerUtil.writeField((Element)element, (String)PROJECT_PATH, (String)this.projectFilePath);
        JDOMExternalizerUtil.writeField((Element)element, (String)PROGRAM_PARAMETERS, (String)this.programParameters);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfigurationParameters$Companion;", "", "()V", "PROGRAM_PARAMETERS", "", "PROJECT_PATH", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

