/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings.iisexpress;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RdIisExpressRunSession;
import com.jetbrains.rider.run.configurations.launchSettings.IisUtils;
import com.jetbrains.rider.run.iisexpress.IisExpressHost;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/iisexpress/IisExpressProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "iisExpressHost", "Lcom/jetbrains/rider/run/iisexpress/IisExpressHost;", "session", "Lcom/jetbrains/rider/model/RdIisExpressRunSession;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "showIisExpressOutput", "", "(Lcom/jetbrains/rider/run/iisexpress/IisExpressHost;Lcom/jetbrains/rider/model/RdIisExpressRunSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Z)V", "destroyProcessImpl", "", "detachIsDefault", "detachProcessImpl", "getProcessInput", "Ljava/io/OutputStream;", "intellij.rider"})
public final class IisExpressProcessHandler
extends ProcessHandler {
    @NotNull
    private final IisExpressHost iisExpressHost;
    @NotNull
    private final RdIisExpressRunSession session;

    public IisExpressProcessHandler(@NotNull IisExpressHost iisExpressHost, @NotNull RdIisExpressRunSession session, final @NotNull Lifetime sessionLifetime, final boolean showIisExpressOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)iisExpressHost), (String)"iisExpressHost");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        this.iisExpressHost = iisExpressHost;
        this.session = session;
        sessionLifetime.executeIfAlive((Function0)new Function0<Unit>(){

            public final void invoke() {
                IisUtils.INSTANCE.startConsumeSessionOutput(sessionLifetime, session, showIisExpressOutput, (Function2<? super String, ? super ConsoleViewContentType, Unit>)((Function2)new Function2<String, ConsoleViewContentType, Unit>(){

                    public final void invoke(@NotNull String text2, @NotNull ConsoleViewContentType kind) {
                        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                        ConsoleViewContentType consoleViewContentType = kind;
                        this.notifyTextAvailable(text2, Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.ERROR_OUTPUT) ? ProcessOutputTypes.STDERR : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT) ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.SYSTEM));
                    }
                }));
            }
        });
        sessionLifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.notifyProcessTerminated(-1);
            }
        });
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    protected void destroyProcessImpl() {
        this.iisExpressHost.shutdownSession(this.session);
    }

    protected void detachProcessImpl() {
        this.destroyProcessImpl();
    }

    public boolean detachIsDefault() {
        return false;
    }
}

