/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharSequenceReader;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationType;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJson;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ&\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001cH\u0007J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001cH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService;", "", "()V", "PROFILES_PROPERTY", "", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLaunchSettingsFileForProject", "Ljava/io/File;", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "projectPath", "getLaunchSettingsProjectForFile", "fs", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "projects", "", "file", "Lcom/intellij/psi/PsiFile;", "getProfileNameFromElement", "element", "Lcom/intellij/psi/PsiElement;", "j", "", "loadLaunchSettings", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "launchSettingsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "testOnlySerializeLaunchSettings", "launchSettings", "writeLaunchSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "launchSettingsJsonFile", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nLaunchSettingsJsonService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n1#2:93\n288#3,2:94\n13#4:96\n13#5:97\n*S KotlinDebug\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService\n*L\n84#1:94,2\n28#1:96\n28#1:97\n*E\n"})
public final class LaunchSettingsJsonService {
    @NotNull
    public static final LaunchSettingsJsonService INSTANCE = new LaunchSettingsJsonService();
    @NotNull
    private static final String PROFILES_PROPERTY = "profiles";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    private static final Logger logger;

    private LaunchSettingsJsonService() {
    }

    private final boolean j(File file2) {
        return Intrinsics.areEqual((Object)file2.getName().toString(), (Object)"launchSettings.json");
    }

    @Nullable
    public final File getLaunchSettingsFileForProject(@NotNull File projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        File file2 = projectPath.getParentFile();
        return file2 != null ? FilesKt.resolve((File)file2, (String)"Properties/launchSettings.json") : null;
    }

    @Nullable
    public final File getLaunchSettingsFileForProject(@NotNull RunnableProject runnableProject) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        return this.getLaunchSettingsFileForProject(new File(runnableProject.getProjectFilePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull VirtualFile launchSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsFile, (String)"launchSettingsFile");
        Document document2 = FileDocumentManagerBase.getInstance().getDocument(launchSettingsFile);
        Object object = document2;
        if (object == null || (object = object.getCharsSequence()) == null) {
            return null;
        }
        Object object2 = object;
        Closeable closeable = (Closeable)new CharSequenceReader((CharSequence)object2);
        Throwable throwable = null;
        try {
            LaunchSettingsJson.LaunchSettings launchSettings2;
            CharSequenceReader charSequenceReader = (CharSequenceReader)closeable;
            boolean bl = false;
            try {
                launchSettings2 = (LaunchSettingsJson.LaunchSettings)gson.fromJson((Reader)charSequenceReader, LaunchSettingsJson.LaunchSettings.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                logger.warn((Throwable)jsonSyntaxException);
                launchSettings2 = null;
            }
            LaunchSettingsJson.LaunchSettings launchSettings3 = launchSettings2;
            return launchSettings3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull File launchSettingsFile) {
        LaunchSettingsJson.LaunchSettings launchSettings2;
        Intrinsics.checkNotNullParameter((Object)launchSettingsFile, (String)"launchSettingsFile");
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem2, (String)"getInstance(...)");
        LocalFileSystem localFileSystem3 = localFileSystem2;
        VirtualFile virtualFile2 = localFileSystem3.findFileByIoFile(launchSettingsFile);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            launchSettings2 = INSTANCE.loadLaunchSettings(virtualFile3);
        } else {
            launchSettings2 = null;
        }
        return launchSettings2;
    }

    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull RunnableProject runnableProject) {
        LaunchSettingsJson.LaunchSettings launchSettings2;
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        File file2 = this.getLaunchSettingsFileForProject(runnableProject);
        if (file2 != null) {
            File file3 = file2;
            boolean bl = false;
            launchSettings2 = INSTANCE.loadLaunchSettings(file3);
        } else {
            launchSettings2 = null;
        }
        return launchSettings2;
    }

    @TestOnly
    public final void writeLaunchSettings(@NotNull Project project, @NotNull VirtualFile launchSettingsJsonFile, @NotNull LaunchSettingsJson.LaunchSettings launchSettings2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)launchSettingsJsonFile, (String)"launchSettingsJsonFile");
        Intrinsics.checkNotNullParameter((Object)launchSettings2, (String)"launchSettings");
        String string = gson.toJson((Object)launchSettings2);
        LoadTextUtil.write((Project)project, (VirtualFile)launchSettingsJsonFile, (Object)this, (String)string, (long)-1L);
    }

    @Nullable
    public final String getProfileNameFromElement(@NotNull PsiElement element) {
        JsonProperty jsonProperty;
        JsonProperty jsonProperty2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        if (((LeafPsiElement)element).getElementType() != JsonElementTypes.DOUBLE_QUOTED_STRING) {
            return null;
        }
        JsonProperty jsonProperty3 = jsonProperty2 = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        if ((jsonProperty3 != null ? jsonProperty3.getNameElement() : null) != ((LeafPsiElement)element).getParent()) {
            return null;
        }
        JsonProperty jsonProperty4 = jsonProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)jsonProperty2), JsonProperty.class, (boolean)true);
        if (!Intrinsics.areEqual((Object)(jsonProperty4 != null ? jsonProperty4.getName() : null), (Object)PROFILES_PROPERTY)) {
            return null;
        }
        JsonProperty jsonProperty5 = jsonProperty2;
        return jsonProperty5 != null ? jsonProperty5.getName() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final RunnableProject getLaunchSettingsProjectForFile(@NotNull LocalFileSystem fs, @NotNull List<RunnableProject> projects2, @NotNull PsiFile file2) {
        Object t;
        Object v0;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter(projects2, (String)"projects");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (!this.j(new File(virtualFile2.getPath()))) {
            return null;
        }
        LaunchSettingsConfigurationType launchSettingsConfigurationType = (LaunchSettingsConfigurationType)ConfigurationTypeUtil.findConfigurationType(LaunchSettingsConfigurationType.class);
        Iterable iterable = projects2;
        boolean bl2 = false;
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) {
                v0 = null;
                return v0;
            }
            t = iterator2.next();
            RunnableProject runnableProject = (RunnableProject)t;
            boolean bl3 = false;
            if (launchSettingsConfigurationType.isApplicable(runnableProject.getKind())) {
                VirtualFile virtualFile3;
                if (INSTANCE.getLaunchSettingsFileForProject(runnableProject) != null) {
                    File file3;
                    boolean bl4 = false;
                    virtualFile3 = fs.findFileByIoFile(file3);
                } else {
                    virtualFile3 = null;
                }
                if (Intrinsics.areEqual(virtualFile3, (Object)virtualFile2)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = t;
        return v0;
    }

    @TestOnly
    @NotNull
    public final String testOnlySerializeLaunchSettings(@NotNull LaunchSettingsJson.LaunchSettings launchSettings2) {
        Intrinsics.checkNotNullParameter((Object)launchSettings2, (String)"launchSettings");
        String string = gson.toJson((Object)launchSettings2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(LaunchSettingsJsonService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

