/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.exe;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.RunConfigurationHelper;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u0000H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationParameters;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "exePath", "", "programParameters", "workingDirectory", "envs", "", "isPassParentEnvs", "", "useExternalConsole", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;ZZ)V", "getEnvs", "()Ljava/util/Map;", "setEnvs", "(Ljava/util/Map;)V", "getExePath", "()Ljava/lang/String;", "setExePath", "(Ljava/lang/String;)V", "()Z", "setPassParentEnvs", "(Z)V", "getProgramParameters", "setProgramParameters", "getUseExternalConsole", "setUseExternalConsole", "getWorkingDirectory", "setWorkingDirectory", "copy", "readExternal", "", "element", "Lorg/jdom/Element;", "validate", "writeExternal", "Companion", "intellij.rider"})
public class ExeConfigurationParameters
extends UserDataHolderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String exePath;
    @NotNull
    private String programParameters;
    @NotNull
    private String workingDirectory;
    @NotNull
    private Map<String, String> envs;
    private boolean isPassParentEnvs;
    private boolean useExternalConsole;
    @NotNull
    private static final String EXE_PATH = "EXE_PATH";
    @NotNull
    private static final String PROGRAM_PARAMETERS = "PROGRAM_PARAMETERS";
    @NotNull
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    @NotNull
    private static final String USE_EXTERNAL_CONSOLE = "USE_EXTERNAL_CONSOLE";
    @NotNull
    private static final String PASS_PARENT_ENVS = "PASS_PARENT_ENVS";

    public ExeConfigurationParameters(@NotNull String exePath, @NotNull String programParameters, @NotNull String workingDirectory, @NotNull Map<String, String> envs, boolean isPassParentEnvs, boolean useExternalConsole) {
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        Intrinsics.checkNotNullParameter((Object)programParameters, (String)"programParameters");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.exePath = exePath;
        this.programParameters = programParameters;
        this.workingDirectory = workingDirectory;
        this.envs = envs;
        this.isPassParentEnvs = isPassParentEnvs;
        this.useExternalConsole = useExternalConsole;
    }

    @NotNull
    public final String getExePath() {
        return this.exePath;
    }

    public final void setExePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.exePath = string;
    }

    @NotNull
    public final String getProgramParameters() {
        return this.programParameters;
    }

    public final void setProgramParameters(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.programParameters = string;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    @NotNull
    public final Map<String, String> getEnvs() {
        return this.envs;
    }

    public final void setEnvs(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.envs = map2;
    }

    public final boolean isPassParentEnvs() {
        return this.isPassParentEnvs;
    }

    public final void setPassParentEnvs(boolean bl) {
        this.isPassParentEnvs = bl;
    }

    public final boolean getUseExternalConsole() {
        return this.useExternalConsole;
    }

    public final void setUseExternalConsole(boolean bl) {
        this.useExternalConsole = bl;
    }

    public void validate() {
        File file2 = new File(this.exePath);
        File file3 = new File(this.workingDirectory);
        if (!file2.exists() || !file2.isFile()) {
            Object[] objectArray = new Object[]{!StringsKt.isBlank((CharSequence)this.exePath) ? this.exePath : "<empty>"};
            throw new RuntimeConfigurationError(RiderRunBundle.Companion.message("dialog.message.invalid.exe.path", objectArray));
        }
        if (!file3.exists() || !file3.isDirectory()) {
            Object[] objectArray = new Object[]{!StringsKt.isBlank((CharSequence)this.workingDirectory) ? this.workingDirectory : "<empty>"};
            throw new RuntimeConfigurationError(RiderRunBundle.Companion.message("dialog.message.invalid.working.dir", objectArray));
        }
    }

    public void readExternal(@NotNull Element element) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string3 = JDOMExternalizerUtil.readField((Element)element, (String)EXE_PATH);
        if (string3 == null) {
            string3 = this.exePath = "";
        }
        if ((string2 = JDOMExternalizerUtil.readField((Element)element, (String)PROGRAM_PARAMETERS)) == null) {
            string2 = this.programParameters = "";
        }
        if ((string = JDOMExternalizerUtil.readField((Element)element, (String)WORKING_DIRECTORY)) == null) {
            string = "";
        }
        this.workingDirectory = string;
        this.isPassParentEnvs = !Intrinsics.areEqual((Object)JDOMExternalizerUtil.readField((Element)element, (String)PASS_PARENT_ENVS), (Object)"0");
        EnvironmentVariablesComponent.readExternal((Element)element, this.envs);
        this.useExternalConsole = Intrinsics.areEqual((Object)JDOMExternalizerUtil.readField((Element)element, (String)USE_EXTERNAL_CONSOLE), (Object)"1");
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JDOMExternalizerUtil.writeField((Element)element, (String)EXE_PATH, (String)this.exePath);
        JDOMExternalizerUtil.writeField((Element)element, (String)PROGRAM_PARAMETERS, (String)this.programParameters);
        JDOMExternalizerUtil.writeField((Element)element, (String)WORKING_DIRECTORY, (String)this.workingDirectory);
        JDOMExternalizerUtil.writeField((Element)element, (String)PASS_PARENT_ENVS, (String)(this.isPassParentEnvs ? "1" : "0"));
        EnvironmentVariablesComponent.writeExternal((Element)element, this.envs);
        JDOMExternalizerUtil.writeField((Element)element, (String)USE_EXTERNAL_CONSOLE, (String)(this.useExternalConsole ? "1" : "0"));
    }

    @NotNull
    public ExeConfigurationParameters copy() {
        return new ExeConfigurationParameters(this.exePath, this.programParameters, this.workingDirectory, RunConfigurationHelper.INSTANCE.copyEnvs(this.envs), this.isPassParentEnvs, this.useExternalConsole);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationParameters$Companion;", "", "()V", "EXE_PATH", "", "PASS_PARENT_ENVS", "PROGRAM_PARAMETERS", "USE_EXTERNAL_CONSOLE", "WORKING_DIRECTORY", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

