/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJsonService;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007J\u001a\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0012\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/run/configurations/RunConfigurationHelper;", "", "()V", "copyEnvs", "", "", "envs", "", "hasConfigurationForNameAndTypeId", "", "Lcom/intellij/execution/RunManager;", "name", "typeId", "hasConfigurationForProject", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "hasLaunchSettings", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationHelper.kt\ncom/jetbrains/rider/run/configurations/RunConfigurationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1747#2,3:34\n1747#2,3:37\n1747#2,3:40\n1855#2,2:43\n*S KotlinDebug\n*F\n+ 1 RunConfigurationHelper.kt\ncom/jetbrains/rider/run/configurations/RunConfigurationHelper\n*L\n9#1:34,3\n17#1:37,3\n23#1:40,3\n28#1:43,2\n*E\n"})
public final class RunConfigurationHelper {
    @NotNull
    public static final RunConfigurationHelper INSTANCE = new RunConfigurationHelper();

    private RunConfigurationHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasLaunchSettings(@NotNull List<RunnableProject> $this$hasLaunchSettings, @NotNull RunnableProject runnableProject) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$hasLaunchSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Iterable iterable = $this$hasLaunchSettings;
        boolean bl2 = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object t = iterator2.next();
            RunnableProject runnableProject2 = (RunnableProject)t;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)runnableProject2.getKind(), (Object)RunnableProjectKinds.INSTANCE.getLaunchSettings())) {
                boolean bl4;
                File file2 = LaunchSettingsJsonService.INSTANCE.getLaunchSettingsFileForProject(runnableProject);
                if (file2 != null) {
                    if (file2.exists()) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final boolean hasConfigurationForProject(@NotNull RunManager $this$hasConfigurationForProject, @NotNull RunnableProject runnableProject) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasConfigurationForProject, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
            Iterable iterable = $this$hasConfigurationForProject.getAllConfigurationsList();
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    RunConfiguration runConfiguration = (RunConfiguration)t;
                    boolean bl3 = false;
                    if (!(runConfiguration instanceof IProjectBasedRunConfiguration && Intrinsics.areEqual((Object)((IProjectBasedRunConfiguration)runConfiguration).getProjectFilePath(), (Object)runnableProject.getProjectFilePath()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasConfigurationForNameAndTypeId(@NotNull RunManager $this$hasConfigurationForNameAndTypeId, @NotNull String name, @NotNull String typeId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasConfigurationForNameAndTypeId, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
            Iterable iterable = $this$hasConfigurationForNameAndTypeId.getAllConfigurationsList();
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    RunConfiguration runConfiguration = (RunConfiguration)t;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)runConfiguration.getName(), (Object)name) && Intrinsics.areEqual((Object)runConfiguration.getType().getId(), (Object)typeId))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Map<String, String> copyEnvs(@NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Map map2 = new LinkedHashMap();
        Iterable iterable = envs.entrySet();
        boolean bl = false;
        for (Object t : iterable) {
            Map.Entry entry2 = (Map.Entry)t;
            boolean bl2 = false;
            String string = (String)entry2.getKey();
            String string2 = (String)entry2.getValue();
            map2.put(string, string2);
        }
        return map2;
    }
}

