/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.debugger.RiderDebuggerElevationUtilKt;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import com.jetbrains.rider.run.ExternalConsoleMediator;
import com.jetbrains.rider.run.TerminalProcessHandler;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u0015*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u001d"}, d2={"j", "", "process", "Lcom/intellij/execution/process/ProcessHandler;", "processLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "processName", "", "processResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "execute", "Lcom/intellij/execution/DefaultExecutionResult;", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "useExternalConsole", "", "runInRunToolWindow", "Lorg/jetbrains/concurrency/Promise;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "title", "runWithProgress", "progressTitle", "intellij.rider"})
public final class CommandLineExKt {
    @NotNull
    public static final DefaultExecutionResult execute(@NotNull GeneralCommandLine $this$execute, @NotNull ExecutionEnvironment environment, boolean useExternalConsole) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        try {
            ProcessHandler processHandler2;
            if (useExternalConsole) {
                processHandler2 = ExternalConsoleMediator.INSTANCE.createProcessHandler($this$execute);
            } else {
                Project project = environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                processHandler2 = (ProcessHandler)new TerminalProcessHandler(project, $this$execute, false, 4, null);
            }
            ProcessHandler processHandler3 = processHandler2;
            Project project = environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ConsoleView consoleView = DotNetProcessRunProfileStateKt.createConsole$default(useExternalConsole ? ConsoleKind.ExternalConsole : ConsoleKind.Normal, processHandler3, project2, null, 8, null);
            AnAction[] anActionArray = AnAction.EMPTY_ARRAY;
            return new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler3, Arrays.copyOf(anActionArray, anActionArray.length));
        }
        catch (Throwable throwable) {
            Project project = environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RiderDebuggerElevationUtilKt.showElevationDialogIfNeeded(throwable, project);
            throw new ExecutionException(throwable);
        }
    }

    private static final void j(ProcessHandler processHandler2, LifetimeDefinition lifetimeDefinition, String string, AsyncPromise<Integer> asyncPromise, Logger logger2) {
        boolean bl = lifetimeDefinition.onTerminationIfAlive((Function0)new Function0<Unit>(processHandler2, logger2, string, asyncPromise){
            final /* synthetic */ ProcessHandler $process;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String $processName;
            final /* synthetic */ AsyncPromise<Integer> $processResult;
            {
                this.$process = $process;
                this.$logger = $logger;
                this.$processName = $processName;
                this.$processResult = $processResult;
                super(0);
            }

            public final void invoke() {
                if (!this.$process.isProcessTerminated()) {
                    Logger logger2 = this.$logger;
                    if (logger2 != null) {
                        logger2.warn("Terminating process " + this.$processName);
                    }
                    this.$process.destroyProcess();
                }
                this.$processResult.cancel(false);
            }
        });
        if (!bl) {
            Logger logger3 = logger2;
            if (logger3 != null) {
                logger3.warn("Immediately terminating " + string + " because lifetime is already terminated");
            }
            asyncPromise.cancel();
            processHandler2.destroyProcess();
        }
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(logger2, string, lifetimeDefinition, asyncPromise){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String $processName;
            final /* synthetic */ LifetimeDefinition $processLifetime;
            final /* synthetic */ AsyncPromise<Integer> $processResult;
            {
                this.$logger = $logger;
                this.$processName = $processName;
                this.$processLifetime = $processLifetime;
                this.$processResult = $processResult;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int n2 = event.getExitCode();
                Logger logger2 = this.$logger;
                if (logger2 != null) {
                    logger2.info(this.$processName + " result: " + n2);
                }
                this.$processLifetime.executeIfAlive((Function0)new Function0<Unit>(this.$processResult, n2){
                    final /* synthetic */ AsyncPromise<Integer> $processResult;
                    final /* synthetic */ int $exitCode;
                    {
                        this.$processResult = $processResult;
                        this.$exitCode = $exitCode;
                        super(0);
                    }

                    public final void invoke() {
                        this.$processResult.setResult((Object)this.$exitCode);
                    }
                });
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$processLifetime, (boolean)false, (int)1, null);
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    Logger logger2 = this.$logger;
                    if (logger2 == null) break block0;
                    logger2.info(this.$processName + " " + outputType + ": " + event.getText());
                }
            }
        });
    }

    @NotNull
    public static final Promise<Integer> runWithProgress(@NotNull GeneralCommandLine $this$runWithProgress, @NotNull Project project, @NotNull Lifetime lifetime2, @NlsContexts.ProgressTitle @NotNull String progressTitle, @Nullable Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)$this$runWithProgress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        GeneralCommandLine generalCommandLine = $this$runWithProgress;
        AsyncPromise asyncPromise = new AsyncPromise();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, progressTitle, lifetime2, generalCommandLine, (AsyncPromise<Integer>)asyncPromise, logger2){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ AsyncPromise<Integer> $processResult;
            final /* synthetic */ Logger $logger;
            {
                this.$lifetime = $lifetime;
                this.$commandLine = $commandLine;
                this.$processResult = $processResult;
                this.$logger = $logger;
                super($project, $progressTitle, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                LifetimeDefinition lifetimeDefinition = this.$lifetime.createNested();
                try {
                    OSProcessHandler oSProcessHandler = new OSProcessHandler(this.$commandLine);
                    ProcessHandler processHandler2 = (ProcessHandler)oSProcessHandler;
                    String string = this.$commandLine.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    CommandLineExKt.access$addLifetimedProcessListener(processHandler2, lifetimeDefinition, string, this.$processResult, this.$logger);
                    oSProcessHandler.startNotify();
                    while (!oSProcessHandler.waitFor(100L)) {
                        indicator.checkCanceled();
                    }
                }
                catch (Throwable throwable) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
                    throw throwable;
                }
            }
        });
        return (Promise)asyncPromise;
    }

    @NotNull
    public static final Promise<Integer> runInRunToolWindow(@NotNull GeneralCommandLine $this$runInRunToolWindow, @NotNull Project project, @NotNull Lifetime lifetime2, @NotNull String title2, @Nullable Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)$this$runInRunToolWindow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = $this$runInRunToolWindow;
        if (!(objectRef.element instanceof PtyCommandLine)) {
            objectRef.element = new PtyCommandLine((GeneralCommandLine)objectRef.element);
        }
        ((PtyCommandLine)objectRef.element).withConsoleMode(false);
        AsyncPromise asyncPromise = new AsyncPromise();
        RunProfile runProfile2 = new RunProfile(title2, lifetime2, (AsyncPromise<Integer>)asyncPromise, logger2, project, (Ref.ObjectRef<GeneralCommandLine>)objectRef){
            final /* synthetic */ String $title;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ AsyncPromise<Integer> $processResult;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef<GeneralCommandLine> $commandLine;
            {
                this.$title = $title;
                this.$lifetime = $lifetime;
                this.$processResult = $processResult;
                this.$logger = $logger;
                this.$project = $project;
                this.$commandLine = $commandLine;
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            @NotNull
            public String getName() {
                return this.$title;
            }

            @NotNull
            public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment) {
                Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                return new RunProfileState(this.$lifetime, this.$title, this.$processResult, this.$logger, this.$project, this.$commandLine){
                    final /* synthetic */ Lifetime $lifetime;
                    final /* synthetic */ String $title;
                    final /* synthetic */ AsyncPromise<Integer> $processResult;
                    final /* synthetic */ Logger $logger;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Ref.ObjectRef<GeneralCommandLine> $commandLine;
                    {
                        this.$lifetime = $lifetime;
                        this.$title = $title;
                        this.$processResult = $processResult;
                        this.$logger = $logger;
                        this.$project = $project;
                        this.$commandLine = $commandLine;
                    }

                    @NotNull
                    public ExecutionResult execute(@Nullable Executor executor2, @NotNull ProgramRunner<?> runner) {
                        Intrinsics.checkNotNullParameter(runner, (String)"runner");
                        KillableProcessHandler killableProcessHandler = new KillableProcessHandler(this.$commandLine){

                            @NotNull
                            protected BaseOutputReader.Options readerOptions() {
                                return new BaseOutputReader.Options(){

                                    public BaseDataReader.SleepingPolicy policy() {
                                        return BaseDataReader.SleepingPolicy.BLOCKING;
                                    }

                                    public boolean withSeparators() {
                                        return true;
                                    }

                                    public boolean splitToLines() {
                                        return false;
                                    }
                                };
                            }
                        };
                        LifetimeDefinition lifetimeDefinition = this.$lifetime.createNested();
                        try {
                            CommandLineExKt.access$addLifetimedProcessListener((ProcessHandler)killableProcessHandler, lifetimeDefinition, this.$title, this.$processResult, this.$logger);
                            TerminalExecutionConsole terminalExecutionConsole = new TerminalExecutionConsole(this.$project, (ProcessHandler)killableProcessHandler);
                            return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)terminalExecutionConsole, (ProcessHandler)killableProcessHandler);
                        }
                        catch (Throwable throwable) {
                            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
                            throw throwable;
                        }
                    }
                };
            }
        };
        Executor executor2 = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"getRunExecutorInstance(...)");
        ExecutionEnvironment executionEnvironment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)new ExecutionEnvironmentBuilder(project, executor2).runProfile(runProfile2), null, (int)1, null);
        ExecutionManager.Companion.getInstance(project).restartRunProfile(executionEnvironment);
        return (Promise)asyncPromise;
    }

    public static final /* synthetic */ void access$addLifetimedProcessListener(ProcessHandler process2, LifetimeDefinition processLifetime, String processName, AsyncPromise processResult, Logger logger2) {
        CommandLineExKt.j(process2, processLifetime, processName, (AsyncPromise<Integer>)processResult, logger2);
    }
}

