/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.ProcessWatchDog;
import com.jetbrains.rider.run.WinProcessWatchDog;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler;", "Lcom/jetbrains/rider/run/ExternalConsoleProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "handle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "getHandle", "()Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "pid", "", "getPid", "()I", "watchDog", "Lcom/jetbrains/rider/run/ProcessWatchDog;", "getWatchDog", "()Lcom/jetbrains/rider/run/ProcessWatchDog;", "destroyProcessImpl", "", "killProcess", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nExternalConsoleMediator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalConsoleMediator.kt\ncom/jetbrains/rider/run/WinExternalConsoleProcessHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,448:1\n125#2:449\n152#2,3:450\n13#3:453\n13#4:454\n*S KotlinDebug\n*F\n+ 1 ExternalConsoleMediator.kt\ncom/jetbrains/rider/run/WinExternalConsoleProcessHandler\n*L\n152#1:449\n152#1:450,3\n134#1:453\n134#1:454\n*E\n"})
public final class WinExternalConsoleProcessHandler
extends ExternalConsoleProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @NotNull
    private final ProcessWatchDog watchDog;
    @NotNull
    private final WinNT.HANDLE handle;
    @NotNull
    private static final Logger logger;

    public WinExternalConsoleProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Memory memory;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super(commandLine);
        if (!SystemInfo.isWindows) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.getCommandLineString() + "\u0000";
        Path path = commandLine.getWorkingDirectory();
        String string2 = path != null ? ((Object)path).toString() : null;
        Map map2 = commandLine.getEffectiveEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEffectiveEnvironment(...)");
        SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMutableMap((Map)map2));
        WinExternalConsoleProcessHandler winExternalConsoleProcessHandler = this;
        int n2 = 0;
        if (sortedMap.isEmpty()) {
            memory = null;
        } else {
            Object object = sortedMap;
            boolean bl = false;
            Map map3 = object;
            Collection collection = new ArrayList(object.size());
            boolean bl2 = false;
            Iterator iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator2.next();
                Collection collection2 = collection;
                boolean bl3 = false;
                String string3 = (String)entry3.getKey();
                String string4 = (String)entry3.getValue();
                collection2.add(string3 + "=" + string4 + "\u0000");
            }
            String string5 = CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"", null, (CharSequence)"\u0000", (int)0, null, null, (int)58, null);
            byte[] byArray = string5.getBytes(Charsets.UTF_16LE);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = byArray;
            Memory memory2 = new Memory((long)((Object)object).length);
            memory2.write(0L, (byte[])object, 0, ((Object)object).length);
            memory = memory2;
        }
        Memory memory3 = memory;
        WinBase.STARTUPINFO sTARTUPINFO = new WinBase.STARTUPINFO();
        winExternalConsoleProcessHandler = new WinBase.PROCESS_INFORMATION();
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        if (!Kernel32.INSTANCE.CreateProcessW(null, cArray, null, null, false, new WinDef.DWORD(1552L), (Pointer)memory3, string2, sTARTUPINFO, (WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler)) {
            n2 = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("CreateProcessW failed with error code: " + n2);
        }
        WinNT.HANDLE hANDLE = ((WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler).hProcess;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"hProcess");
        this.handle = hANDLE;
        this.pid = ((WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler).dwProcessId.intValue();
        this.getLifetimeDefinition().getLifetime().onTermination((Function0)new Function0<Unit>((WinBase.PROCESS_INFORMATION)winExternalConsoleProcessHandler){
            final /* synthetic */ WinBase.PROCESS_INFORMATION $processInfo;
            {
                this.$processInfo = $processInfo;
                super(0);
            }

            public final void invoke() {
                Kernel32.INSTANCE.CloseHandle(this.$processInfo.hProcess);
                Kernel32.INSTANCE.CloseHandle(this.$processInfo.hThread);
            }
        });
        this.watchDog = new WinProcessWatchDog(this.handle, this.getPresentableName(commandLine), (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                IntByReference intByReference = new IntByReference();
                if (!Kernel32.INSTANCE.GetExitCodeProcess(this.getHandle(), intByReference)) {
                    throw new RuntimeException("Failed to get exit code for process " + this.getPid());
                }
                return intByReference.getValue();
            }
        }));
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getWatchDog().setTerminationCallback((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

                    public final void invoke(int p0) {
                        ((WinExternalConsoleProcessHandler)((Object)this.receiver)).notifyProcessTerminated(p0);
                    }
                }));
            }
        });
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    @NotNull
    protected ProcessWatchDog getWatchDog() {
        return this.watchDog;
    }

    @NotNull
    public final WinNT.HANDLE getHandle() {
        return this.handle;
    }

    protected void destroyProcessImpl() {
        this.executeOnPooledThread(() -> WinExternalConsoleProcessHandler.j(this));
    }

    public void killProcess() {
        if (!Kernel32.INSTANCE.TerminateProcess(this.handle, -1)) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("TerminateProcess failed with error code: " + n2);
        }
    }

    private static final void j(WinExternalConsoleProcessHandler winExternalConsoleProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)winExternalConsoleProcessHandler), (String)"this$0");
        try {
            OSProcessUtil.terminateProcessGracefully((int)winExternalConsoleProcessHandler.getPid());
        }
        catch (Exception exception) {
            logger.warn("Failed to terminate process gracefully, so it will be terminated forcefully", (Throwable)exception);
            winExternalConsoleProcessHandler.killProcess();
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(WinExternalConsoleProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

