/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.debugger.targets.BundledAssemblyLauncherKt;
import com.jetbrains.rider.run.TerminalProcessAugmentation;
import com.jetbrains.rider.run.TerminalProcessHandlerKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0014J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u0007H\u0016R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/run/TerminalProcessHandler;", "Lcom/intellij/execution/process/KillableProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "notifyExitCode", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/GeneralCommandLine;Z)V", "presentableCommandLine", "", "gracefulTerminationHandler", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "originalExecutable", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;Ljava/nio/file/Path;)V", "augmentation", "Lcom/jetbrains/rider/run/TerminalProcessAugmentation;", "detachInsteadDestroy", "getDetachInsteadDestroy", "()Z", "setDetachInsteadDestroy", "(Z)V", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "j", "", "destroyProcess", "destroyProcessGracefully", "notifyProcessTerminated", "exitCode", "", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "shouldKillProcessSoftly", "intellij.rider"})
public class TerminalProcessHandler
extends KillableProcessHandler {
    @NotNull
    private final GeneralCommandLine commandLine;
    private final boolean notifyExitCode;
    @Nullable
    private final Function1<ProcessHandler, Boolean> gracefulTerminationHandler;
    @NotNull
    private final LifetimeDefinition lifetime;
    @Nullable
    private final TerminalProcessAugmentation augmentation;
    private boolean detachInsteadDestroy;

    public TerminalProcessHandler(@NotNull Project project, @NotNull GeneralCommandLine commandLine, @Nullable String presentableCommandLine, boolean notifyExitCode, @Nullable Function1<? super ProcessHandler, Boolean> gracefulTerminationHandler, @NotNull Path originalExecutable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)originalExecutable, (String)"originalExecutable");
        Process process2 = commandLine.createProcess();
        String string = presentableCommandLine;
        if (string == null) {
            String string2 = commandLine.getCommandLineString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLineString(...)");
        }
        super(process2, string, commandLine.getCharset());
        this.commandLine = commandLine;
        this.notifyExitCode = notifyExitCode;
        this.gracefulTerminationHandler = gracefulTerminationHandler;
        this.lifetime = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        this.j();
        Lifetime lifetime2 = (Lifetime)this.lifetime;
        String string3 = this.commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExePath(...)");
        Path path = Paths.get(string3, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.augmentation = TerminalProcessAugmentation.Companion.get(project, lifetime2, path, originalExecutable);
    }

    public /* synthetic */ TerminalProcessHandler(Project project, GeneralCommandLine generalCommandLine, String string, boolean bl, Function1 function1, Path path, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            function1 = null;
        }
        if ((n2 & 0x20) != 0) {
            String string2 = generalCommandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExePath(...)");
            Path path2 = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            path = path2;
        }
        this(project, generalCommandLine, string, bl, (Function1<? super ProcessHandler, Boolean>)function1, path);
    }

    public TerminalProcessHandler(@NotNull Project project, @NotNull GeneralCommandLine commandLine, boolean notifyExitCode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        this(project, commandLine, commandLine.getCommandLineString(), notifyExitCode, null, null, 48, null);
    }

    public /* synthetic */ TerminalProcessHandler(Project project, GeneralCommandLine generalCommandLine, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(project, generalCommandLine, bl);
    }

    private final void j() {
        String string = this.commandLine.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)BundledAssemblyLauncherKt.getDEBUGGER_WORKER_LAUNCHER().getAssemblyName(), (boolean)false, (int)2, null);
        this.setShouldKillProcessSoftly(!bl);
        if (SystemInfo.isWindows) {
            boolean bl2;
            boolean bl3 = bl2 = !(this.commandLine instanceof PtyCommandLine) || !LocalPtyOptions.Companion.shouldUseWinConPty();
            if (!bl2) {
                this.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, true);
            }
        }
    }

    public final boolean getDetachInsteadDestroy() {
        return this.detachInsteadDestroy;
    }

    public final void setDetachInsteadDestroy(boolean bl) {
        this.detachInsteadDestroy = bl;
    }

    protected void notifyProcessTerminated(int exitCode) {
        if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)this.lifetime))) {
            TerminalProcessHandlerKt.access$getLogger$p().warn("Process for the command line \"" + this.commandLine + "\" is being terminated after the project termination. This will likely lead to issues.");
        }
        this.lifetime.terminate(true);
        super.notifyProcessTerminated(exitCode);
        if (this.notifyExitCode) {
            Object[] objectArray = new Object[]{exitCode};
            this.notifyTextAvailable(IdeBundle.message((String)"run.anything.console.process.finished", (Object[])objectArray), ProcessOutputTypes.SYSTEM);
        }
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return new BaseOutputReader.Options(this){
            final /* synthetic */ TerminalProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public BaseDataReader.SleepingPolicy policy() {
                TerminalProcessAugmentation terminalProcessAugmentation = TerminalProcessHandler.access$getAugmentation$p(this.this$0);
                if (terminalProcessAugmentation == null || (terminalProcessAugmentation = terminalProcessAugmentation.streamReadingPolicy()) == null) {
                    BaseDataReader.SleepingPolicy sleepingPolicy = BaseDataReader.SleepingPolicy.BLOCKING;
                    terminalProcessAugmentation = sleepingPolicy;
                    Intrinsics.checkNotNullExpressionValue((Object)sleepingPolicy, (String)"BLOCKING");
                }
                return terminalProcessAugmentation;
            }

            public boolean splitToLines() {
                return false;
            }

            public boolean withSeparators() {
                return true;
            }
        };
    }

    protected boolean destroyProcessGracefully() {
        Function1<ProcessHandler, Boolean> function1 = this.gracefulTerminationHandler;
        return function1 != null ? ((Boolean)function1.invoke((Object)this)).booleanValue() : super.destroyProcessGracefully();
    }

    public boolean shouldKillProcessSoftly() {
        if (!super.shouldKillProcessSoftly()) {
            return false;
        }
        TerminalProcessAugmentation terminalProcessAugmentation = this.augmentation;
        return terminalProcessAugmentation != null ? terminalProcessAugmentation.shouldKillProcessSoftly() : true;
    }

    public void destroyProcess() {
        if (this.detachInsteadDestroy) {
            this.detachProcess();
        } else {
            super.destroyProcess();
        }
    }

    public static final /* synthetic */ TerminalProcessAugmentation access$getAugmentation$p(TerminalProcessHandler $this) {
        return $this.augmentation;
    }
}

