/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.model.RunConfiguration;
import com.jetbrains.rd.ide.model.RunConfigurationExecutorDescriptor;
import com.jetbrains.rd.ide.model.RunConfigurationModel;
import com.jetbrains.rd.ide.model.RunConfigurationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RunConfigurationTemplate;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.ICanCreateFromBackend;
import com.jetbrains.rider.run.ICanRunFromBackend;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.RunConfigurationHostExecutorExtensions;
import com.jetbrains.rider.run.RunConfigurationHostExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/run/RunConfigurationHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lcom/jetbrains/rd/ide/model/RunConfigurationModel;", "getModel", "()Lcom/jetbrains/rd/ide/model/RunConfigurationModel;", "j", "Lcom/jetbrains/rd/ide/model/RunConfiguration;", "runConfigurationTemplate", "Lcom/jetbrains/rd/ide/model/RunConfigurationTemplate;", "dispose", "", "j", "", "Lcom/jetbrains/rider/run/ICanCreateFromBackend;", "j", "runConfiguration", "startListeningForConfigurations", "j", "Companion", "ProtocolListener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationHost.kt\ncom/jetbrains/rider/run/RunConfigurationHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n661#2,11:142\n766#2:153\n857#2,2:154\n1603#2,9:156\n1855#2:165\n1856#2:167\n1612#2:168\n1549#2:169\n1620#2,3:170\n1360#2:173\n1446#2,2:174\n1549#2:176\n1620#2,3:177\n1448#2,3:180\n800#2,11:183\n766#2:194\n857#2,2:195\n1360#2:197\n1446#2,2:198\n1549#2:200\n1620#2,3:201\n1448#2,3:204\n1#3:166\n*S KotlinDebug\n*F\n+ 1 RunConfigurationHost.kt\ncom/jetbrains/rider/run/RunConfigurationHost\n*L\n55#1:142,11\n62#1:153\n62#1:154,2\n63#1:156,9\n63#1:165\n63#1:167\n63#1:168\n96#1:169\n96#1:170,3\n99#1:173\n99#1:174,2\n100#1:176\n100#1:177,3\n99#1:180,3\n109#1:183,11\n110#1:194\n110#1:195,2\n111#1:197\n111#1:198,2\n112#1:200\n112#1:201,3\n111#1:204,3\n63#1:166\n*E\n"})
public final class RunConfigurationHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RunConfigurationModel model;
    @NotNull
    private static final Logger logger;

    public RunConfigurationHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.model = RunConfigurationModel_GeneratedKt.getRunConfigurationModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
    }

    @NotNull
    public final RunConfigurationModel getModel() {
        return this.model;
    }

    public final void startListeningForConfigurations() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new RunManagerListener(this){
            final /* synthetic */ RunConfigurationHost this$0;
            {
                this.this$0 = $receiver;
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                RunConfigurationHost.access$updateModel(this.this$0);
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                RunConfigurationHost.access$updateModel(this.this$0);
            }

            public void endUpdate() {
                RunConfigurationHost.access$updateModel(this.this$0);
            }

            public void stateLoaded(@NotNull RunManager runManager2, boolean isFirstLoadState) {
                Intrinsics.checkNotNullParameter((Object)runManager2, (String)"runManager");
                RunConfigurationHost.access$updateModel(this.this$0);
            }
        });
        this.j();
    }

    private final RunConfiguration j(RunConfigurationTemplate runConfigurationTemplate) {
        Object v0;
        Iterable iterable;
        block3: {
            iterable = this.j();
            boolean bl = false;
            Object var5_4 = null;
            boolean bl2 = false;
            for (Object t : iterable) {
                ICanCreateFromBackend iCanCreateFromBackend = (ICanCreateFromBackend)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)iCanCreateFromBackend.getId(), (Object)runConfigurationTemplate.getTypeId())) continue;
                if (bl2) {
                    v0 = null;
                    break block3;
                }
                var5_4 = t;
                bl2 = true;
            }
            v0 = !bl2 ? null : var5_4;
        }
        ICanCreateFromBackend iCanCreateFromBackend = v0;
        if (iCanCreateFromBackend == null || (iterable = iCanCreateFromBackend.createFromTemplate(runConfigurationTemplate, RunManager.Companion.getInstance(this.project))) == null) {
            throw new Exception("Invalid configuration type");
        }
        return iterable;
    }

    private final List<ICanCreateFromBackend> j() {
        Object object;
        Iterable iterable = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            object = (ConfigurationType)t;
            boolean bl3 = false;
            if (!(object.getConfigurationFactories().length == 1)) continue;
            collection.add(t);
        }
        iterable = (List)collection;
        bl = false;
        iterable2 = iterable;
        collection = new ArrayList();
        bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl4 = false;
        object = iterable3.iterator();
        while (object.hasNext()) {
            ICanCreateFromBackend iCanCreateFromBackend;
            Object e;
            Object e2 = e = object.next();
            boolean bl5 = false;
            ConfigurationType configurationType2 = (ConfigurationType)e2;
            boolean bl6 = false;
            ConfigurationFactory[] configurationFactoryArray = configurationType2.getConfigurationFactories();
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
            ConfigurationType configurationType3 = ((ConfigurationFactory)ArraysKt.single((Object[])configurationFactoryArray)).getType();
            if ((configurationType3 instanceof ICanCreateFromBackend ? (ICanCreateFromBackend)configurationType3 : null) == null) continue;
            iCanCreateFromBackend = iCanCreateFromBackend;
            boolean bl7 = false;
            collection.add(iCanCreateFromBackend);
        }
        return (List)collection;
    }

    private final void j(RunConfiguration runConfiguration) {
        RunConfigurationHostExtensions runConfigurationHostExtensions2;
        for (RunConfigurationHostExtensions runConfigurationHostExtensions2 : (RunManager)RunConfigurationHostExtensions.Companion.getEP_NAME().getExtensions((AreaInstance)this.project)) {
            if (runConfigurationHostExtensions2.canRunConfiguration(runConfiguration)) continue;
            logger.warning("Do not execute run configuration because of " + runConfigurationHostExtensions2.getClass().getName());
            return;
        }
        RunManager runManager2 = RunManager.Companion.getInstance(this.project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager2.findConfigurationByTypeAndName(runConfiguration.getTypeId(), runConfiguration.getName());
        if (runnerAndConfigurationSettings == null) {
            throw new Exception("Run configuration: " + runConfiguration.getName() + " not found");
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
        if (runManager2.shouldSetRunConfigurationFromContext()) {
            runManager2.setSelectedConfiguration(runnerAndConfigurationSettings2);
        }
        Executor executor2 = ExecutorRegistry.getInstance().getExecutorById(runConfiguration.getExecutor().getId());
        if (executor2 == null) {
            Object[] objectArray = new Object[]{runConfiguration.getExecutor().getId()};
            throw new CantRunException(RiderRunBundle.Companion.message("dialog.message.unsupported.executor.error", objectArray));
        }
        Executor executor3 = executor2;
        ProgramRunner programRunner = ProgramRunner.getRunner((String)runConfiguration.getExecutor().getId(), (RunProfile)((RunProfile)runnerAndConfigurationSettings2.getConfiguration()));
        if (programRunner == null) {
            throw new Exception("Can't get program runner for " + runConfiguration.getName() + " configuration and executor " + runConfiguration.getExecutor().getDisplayName());
        }
        runConfigurationHostExtensions2 = programRunner;
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment(executor3, (ProgramRunner)runConfigurationHostExtensions2, runnerAndConfigurationSettings2, this.project);
        runConfigurationHostExtensions2.execute(executionEnvironment);
    }

    private final void j() {
        ApplicationKt.getApplication().invokeLater(() -> RunConfigurationHost.j(this));
    }

    public void dispose() {
        this.model.getRunConfigurations().set((Object)CollectionsKt.emptyList());
    }

    private static final void j(RunConfigurationHost runConfigurationHost) {
        boolean bl;
        Collection collection;
        RunConfigurationExecutorDescriptor runConfigurationExecutorDescriptor;
        boolean bl2;
        Collection collection2;
        Iterable iterable;
        boolean bl3;
        Iterable iterable2;
        boolean bl4;
        Collection collection3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)runConfigurationHost), (String)"this$0");
        if (runConfigurationHost.project.isDisposed()) {
            return;
        }
        Iterable iterable3 = RunConfigurationHostExecutorExtensions.Companion.getEP_NAME().getExtensionList((AreaInstance)runConfigurationHost.project);
        boolean bl5 = false;
        Iterable iterable4 = iterable3;
        Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean bl6 = false;
        for (Object t : iterable4) {
            object = (RunConfigurationHostExecutorExtensions)t;
            collection3 = collection4;
            bl4 = false;
            collection3.add(object.getExecutorDescriptor());
        }
        List list2 = (List)collection4;
        iterable3 = runConfigurationHost.j();
        collection3 = runConfigurationHost.model.getTemplates();
        bl5 = false;
        iterable4 = iterable3;
        collection4 = new ArrayList();
        bl6 = false;
        for (Object t : iterable4) {
            object = (ICanCreateFromBackend)t;
            bl4 = false;
            iterable2 = list2;
            bl3 = false;
            iterable = iterable2;
            collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            bl2 = false;
            for (Object t2 : iterable) {
                runConfigurationExecutorDescriptor = (RunConfigurationExecutorDescriptor)t2;
                collection = collection2;
                bl = false;
                String string = object.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                collection.add(new RunConfigurationTemplate(runConfigurationExecutorDescriptor, string, object.getCompatibleRunnableProjectKinds(), CollectionsKt.emptyList()));
            }
            object = (List)collection2;
            CollectionsKt.addAll((Collection)collection4, (Iterable)object);
        }
        collection3.set((List)collection4);
        iterable3 = RunManager.Companion.getInstance(runConfigurationHost.project).getAllConfigurationsList();
        collection3 = runConfigurationHost.model.getRunConfigurations();
        bl5 = false;
        iterable4 = iterable3;
        collection4 = new ArrayList();
        bl6 = false;
        for (Object t : iterable4) {
            if (!(t instanceof ICanRunFromBackend)) continue;
            collection4.add(t);
        }
        iterable3 = (List)collection4;
        bl5 = false;
        iterable4 = iterable3;
        collection4 = new ArrayList();
        bl6 = false;
        for (Object t : iterable4) {
            object = (ICanRunFromBackend)t;
            bl4 = false;
            if (!object.canGenerateFromBackend()) continue;
            collection4.add(t);
        }
        iterable3 = (List)collection4;
        bl5 = false;
        iterable4 = iterable3;
        collection4 = new ArrayList();
        bl6 = false;
        for (Object t : iterable4) {
            object = (ICanRunFromBackend)t;
            bl4 = false;
            iterable2 = list2;
            bl3 = false;
            iterable = iterable2;
            collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            bl2 = false;
            for (Object t2 : iterable) {
                runConfigurationExecutorDescriptor = (RunConfigurationExecutorDescriptor)t2;
                collection = collection2;
                bl = false;
                collection.add(new RunConfiguration(object.getTypeId(), object.getName(), object.getProjectFilePath(), runConfigurationExecutorDescriptor));
            }
            object = (List)collection2;
            CollectionsKt.addAll((Collection)collection4, (Iterable)object);
        }
        collection3.set((List)collection4);
    }

    public static final /* synthetic */ void access$updateModel(RunConfigurationHost $this) {
        $this.j();
    }

    public static final /* synthetic */ void access$run(RunConfigurationHost $this, RunConfiguration runConfiguration) {
        $this.j(runConfiguration);
    }

    public static final /* synthetic */ RunConfiguration access$create(RunConfigurationHost $this, RunConfigurationTemplate runConfigurationTemplate) {
        return $this.j(runConfigurationTemplate);
    }

    static {
        Logger logger2 = Logger.getLogger("RunConfigurationHost");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/run/RunConfigurationHost$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "getInstance", "Lcom/jetbrains/rider/run/RunConfigurationHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRunConfigurationHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationHost.kt\ncom/jetbrains/rider/run/RunConfigurationHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,141:1\n31#2,2:142\n*S KotlinDebug\n*F\n+ 1 RunConfigurationHost.kt\ncom/jetbrains/rider/run/RunConfigurationHost$Companion\n*L\n27#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final RunConfigurationHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RunConfigurationHost> clazz = RunConfigurationHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RunConfigurationHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/run/RunConfigurationHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/RunConfigurationModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider"})
    public static final class ProtocolListener
    implements SolutionExtListener<RunConfigurationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session, @NotNull RunConfigurationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            RunConfigurationHost runConfigurationHost = Companion.getInstance(session.getProject());
            runConfigurationHost.startListeningForConfigurations();
            model2.getRun().advise(lifetime2, (Function1)new Function1<RunConfiguration, Unit>(runConfigurationHost){
                final /* synthetic */ RunConfigurationHost $runConfigurationHost;
                {
                    this.$runConfigurationHost = $runConfigurationHost;
                    super(1);
                }

                public final void invoke(@NotNull RunConfiguration it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    RunConfigurationHost.access$run(this.$runConfigurationHost, it);
                }
            });
            model2.getCreateAndRun().advise(lifetime2, (Function1)new Function1<RunConfigurationTemplate, Unit>(runConfigurationHost){
                final /* synthetic */ RunConfigurationHost $runConfigurationHost;
                {
                    this.$runConfigurationHost = $runConfigurationHost;
                    super(1);
                }

                public final void invoke(@NotNull RunConfigurationTemplate it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    RunConfigurationHost.access$run(this.$runConfigurationHost, RunConfigurationHost.access$create(this.$runConfigurationHost, it));
                }
            });
        }
    }
}

