/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.run.UnixExternalProcessHandler;
import com.jetbrains.rider.run.WinExternalConsoleProcessHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/run/ExternalConsoleMediator;", "", "()V", "createProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.rider"})
public final class ExternalConsoleMediator {
    @NotNull
    public static final ExternalConsoleMediator INSTANCE = new ExternalConsoleMediator();

    private ExternalConsoleMediator() {
    }

    @NotNull
    public final ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) {
        ProcessHandler processHandler2;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (SystemInfo.isWindows) {
            processHandler2 = new WinExternalConsoleProcessHandler(commandLine);
        } else if (SystemInfo.isUnix) {
            processHandler2 = new UnixExternalProcessHandler(commandLine);
        } else {
            throw new UnsupportedOperationException("Unsupported under " + SystemInfo.OS_NAME);
        }
        return processHandler2;
    }
}

