/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.model.RoslynFrontendModel;
import com.jetbrains.rider.model.RoslynStatusIcon;
import com.jetbrains.rider.roslyn.RoslynIconActionGroup;
import icons.RiderIcons;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/roslyn/RoslynStatusBarIcon;", "Lcom/intellij/openapi/wm/StatusBarWidget;", "Lcom/intellij/openapi/wm/StatusBarWidget$IconPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rider/model/RoslynFrontendModel;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/RoslynFrontendModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getModel", "()Lcom/jetbrains/rider/model/RoslynFrontendModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "ID", "", "dispose", "", "getClickConsumer", "Lcom/intellij/util/Consumer;", "Ljava/awt/event/MouseEvent;", "getIcon", "Ljavax/swing/Icon;", "getPresentation", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "getTooltipText", "install", "intellij.rider"})
public final class RoslynStatusBarIcon
implements StatusBarWidget,
StatusBarWidget.IconPresentation {
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RoslynFrontendModel model;
    @Nullable
    private StatusBar statusBar;

    public RoslynStatusBarIcon(@NotNull Project project, @NotNull Lifetime lifetime2, @NotNull RoslynFrontendModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project;
        this.lifetime = lifetime2;
        this.model = model2;
        this.model.getStatusBarIcon().getChange().advise(this.lifetime, (Function1)new Function1<RoslynStatusIcon, Unit>(){

            public final void invoke(@NotNull RoslynStatusIcon it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    StatusBar statusBar = statusBar;
                    if (statusBar == null) break block0;
                    statusBar.updateWidget(this.ID());
                }
            }
        });
        this.model.getRoslynEnabled().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                block0: {
                    StatusBar statusBar = statusBar;
                    if (statusBar == null) break block0;
                    statusBar.updateWidget(this.ID());
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RoslynFrontendModel getModel() {
        return this.model;
    }

    @NotNull
    public String ID() {
        return "RoslynIcon";
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return (StatusBarWidget.WidgetPresentation)this;
    }

    public void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.statusBar = statusBar;
    }

    public void dispose() {
        this.statusBar = null;
    }

    @Nullable
    public String getTooltipText() {
        String string;
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.model.getRoslynEnabled()))) {
            string = RiderBundle.message("RoslynStatusBarIcon.tooltip.roslyn.analyzers.present.in.solution.but.disabled", new Object[0]);
        } else {
            RoslynStatusIcon roslynStatusIcon = (RoslynStatusIcon)this.model.getStatusBarIcon().getValueOrNull();
            string = roslynStatusIcon != null ? roslynStatusIcon.getTooltip() : null;
        }
        return string;
    }

    @NotNull
    public Consumer<MouseEvent> getClickConsumer() {
        return RoslynStatusBarIcon::j;
    }

    @Nullable
    public Icon getIcon() {
        Icon icon2;
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.model.getRoslynEnabled()))) {
            return null;
        }
        RoslynStatusIcon roslynStatusIcon = (RoslynStatusIcon)this.model.getStatusBarIcon().getValueOrNull();
        boolean bl = roslynStatusIcon != null ? roslynStatusIcon.isWorking() : false;
        if (bl) {
            RoslynStatusIcon roslynStatusIcon2 = (RoslynStatusIcon)this.model.getStatusBarIcon().getValueOrNull();
            icon2 = (roslynStatusIcon2 != null ? roslynStatusIcon2.getHasIssues() : false) ? RiderIcons.Roslyn.RoslynStatusUpdateIssues : RiderIcons.Roslyn.RoslynStatusUpdate;
        } else {
            RoslynStatusIcon roslynStatusIcon3 = (RoslynStatusIcon)this.model.getStatusBarIcon().getValueOrNull();
            icon2 = (roslynStatusIcon3 != null ? roslynStatusIcon3.getHasIssues() : false) ? RiderIcons.Roslyn.RoslynStatusIssues : RiderIcons.Roslyn.RoslynStatus;
        }
        return icon2;
    }

    private static final void j(MouseEvent mouseEvent) {
        DataContext dataContext = DataManager.getInstance().getDataContext(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)new RoslynIconActionGroup(), dataContext2, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup listPopup2 = listPopup;
        listPopup2.show(new RelativePoint(mouseEvent.getComponent(), new Point(0, -listPopup2.getContent().getPreferredSize().height)));
    }
}

