/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.debugger.editAndContinue.HotReloadStatusTracker;
import com.jetbrains.rider.model.BackendHotReloadManagerModel;
import com.jetbrains.rider.model.RoslynBackendToFrontendError;
import com.jetbrains.rider.model.RoslynFrontendModel;
import com.jetbrains.rider.model.RoslynFrontendModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.roslyn.RoslynHost;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/roslyn/RoslynHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "model", "Lcom/jetbrains/rider/model/RoslynFrontendModel;", "getModel", "()Lcom/jetbrains/rider/model/RoslynFrontendModel;", "createHotReloadManager", "Lcom/jetbrains/rider/model/BackendHotReloadManagerModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "showErrors", "", "Companion", "ProtocolListener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRoslynHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoslynHost.kt\ncom/jetbrains/rider/roslyn/RoslynHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n13#2:112\n13#3:113\n1282#4,2:114\n1855#5,2:116\n*S KotlinDebug\n*F\n+ 1 RoslynHost.kt\ncom/jetbrains/rider/roslyn/RoslynHost\n*L\n34#1:112\n34#1:113\n64#1:114,2\n82#1:116,2\n*E\n"})
public final class RoslynHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RoslynFrontendModel model;
    @NotNull
    private final Logger logger;
    @NlsContexts.TabTitle
    @NotNull
    private static final String roslynTabName = RiderBundle.message("RoslynHost.tab.title.roslyn.project.load.issues", new Object[0]);
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private static final String roslynErrorsPrefaceText = RiderBundle.message("RoslynHost.errors.preface.text", new Object[0]) + "\n";

    public RoslynHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.model = RoslynFrontendModel_PregeneratedKt.getRoslynFrontendModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RoslynHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
    }

    @NotNull
    public final RoslynFrontendModel getModel() {
        return this.model;
    }

    @NotNull
    public final BackendHotReloadManagerModel createHotReloadManager(@NotNull Lifetime lifetime2) {
        BackendHotReloadManagerModel backendHotReloadManagerModel;
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        BackendHotReloadManagerModel backendHotReloadManagerModel2 = backendHotReloadManagerModel = new BackendHotReloadManagerModel(HotReloadStatusTracker.INSTANCE.isEnabledEncDiagnostic());
        boolean bl = false;
        this.logger.debug("Open EncBackendSession");
        this.model.getHotReloadBackendSession().set((Object)backendHotReloadManagerModel2);
        lifetime2.onTermination((Function0)new Function0<Unit>(lifetime2, this){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ RoslynHost this$0;
            {
                this.$lifetime = $lifetime;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this.$lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ RoslynHost this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                RoslynHost.access$getLogger$p(this.this$0).debug("Close EncBackendSession");
                                this.this$0.getModel().getHotReloadBackendSession().set(null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
        return backendHotReloadManagerModel;
    }

    public final void showErrors() {
        Object object;
        ConsoleView consoleView;
        ContentManager contentManager;
        ToolWindow toolWindow;
        block4: {
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
            MessageView.Companion.getInstance(this.project);
            ToolWindow toolWindow2 = toolWindowManager.getToolWindow("Messages");
            if (toolWindow2 == null) {
                return;
            }
            toolWindow = toolWindow2;
            ContentManager contentManager2 = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getContentManager(...)");
            contentManager = contentManager2;
            Content[] contentArray = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            consoleView = (ConsoleView)contentArray;
            boolean bl = false;
            for (Object object2 : consoleView) {
                Content content2 = (Content)object2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)content2.getTabName(), (Object)roslynTabName)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Content content3 = (Content)object;
        if (content3 != null) {
            contentManager.setSelectedContent(content3, true);
            toolWindow.activate(RoslynHost::N);
        } else {
            ConsoleView consoleView2 = TextConsoleBuilderFactory.getInstance().createBuilder(this.project).filters(AnalyzeStacktraceUtil.EP_NAME.getExtensions((AreaInstance)this.project)).getConsole();
            Intrinsics.checkNotNullExpressionValue((Object)consoleView2, (String)"getConsole(...)");
            consoleView = consoleView2;
            consoleView.allowHeavyFilters();
            Content content4 = contentManager.getFactory().createContent(consoleView.getComponent(), roslynTabName, true);
            Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"createContent(...)");
            Content content5 = content4;
            ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)content5)).onTermination((Function0)new Function0<Unit>(consoleView){
                final /* synthetic */ ConsoleView $console;
                {
                    this.$console = $console;
                    super(0);
                }

                public final void invoke() {
                    Disposer.dispose((Disposable)((Disposable)this.$console));
                }
            });
            this.model.getRoslynErrors().advise(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)content5)), (Function1)new Function1<IViewableList.Event<? extends RoslynBackendToFrontendError>, Unit>(this, consoleView){
                final /* synthetic */ RoslynHost this$0;
                final /* synthetic */ ConsoleView $console;
                {
                    this.this$0 = $receiver;
                    this.$console = $console;
                    super(1);
                }

                public final void invoke(@NotNull IViewableList.Event<RoslynBackendToFrontendError> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    RoslynHost.access$showErrors$rebuildErrorView(this.this$0, this.$console);
                }
            });
            contentManager.addContent(content5);
            contentManager.setSelectedContent(content5, true);
            toolWindow.activate(RoslynHost::j);
        }
    }

    private static final void N() {
    }

    private static final void j(RoslynHost roslynHost, ConsoleView consoleView) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(roslynErrorsPrefaceText);
        Iterable iterable = (Iterable)roslynHost.model.getRoslynErrors();
        boolean bl = false;
        for (Object t : iterable) {
            RoslynBackendToFrontendError roslynBackendToFrontendError = (RoslynBackendToFrontendError)t;
            boolean bl2 = false;
            stringBuilder.append("\n");
            stringBuilder.append("In project ");
            stringBuilder.append(roslynBackendToFrontendError.getProjectName());
            stringBuilder.append(": ");
            stringBuilder.append(roslynBackendToFrontendError.getText());
            stringBuilder.append("\n\n");
        }
        consoleView.clear();
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        consoleView.print(StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null), ConsoleViewContentType.NORMAL_OUTPUT);
    }

    private static final void j() {
    }

    public static final /* synthetic */ void access$showErrors$rebuildErrorView(RoslynHost this$0, ConsoleView console2) {
        RoslynHost.j(this$0, console2);
    }

    public static final /* synthetic */ Logger access$getLogger$p(RoslynHost $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/roslyn/RoslynHost$Companion;", "", "()V", "roslynErrorsPrefaceText", "", "getRoslynErrorsPrefaceText", "()Ljava/lang/String;", "roslynTabName", "getRoslynTabName", "getInstance", "Lcom/jetbrains/rider/roslyn/RoslynHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRoslynHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoslynHost.kt\ncom/jetbrains/rider/roslyn/RoslynHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,111:1\n31#2,2:112\n*S KotlinDebug\n*F\n+ 1 RoslynHost.kt\ncom/jetbrains/rider/roslyn/RoslynHost$Companion\n*L\n50#1:112,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RoslynHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RoslynHost> clazz = RoslynHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RoslynHost)((Object)object);
        }

        @NotNull
        public final String getRoslynTabName() {
            return roslynTabName;
        }

        @NotNull
        public final String getRoslynErrorsPrefaceText() {
            return roslynErrorsPrefaceText;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/roslyn/RoslynHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RoslynFrontendModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider"})
    public static final class ProtocolListener
    implements SolutionExtListener<RoslynFrontendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session, @NotNull RoslynFrontendModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            model2.getCurrentRoslynProcessPid().view(lifetime2, (Function2)extensionCreated.1.INSTANCE);
        }
    }
}

