/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ApplicationKt;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/protocol/RiderWindowsRegistryHandler;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "j", "", "buildNumberValue", "", "j", "", "hKey", "Lcom/sun/jna/platform/win32/WinReg$HKEY;", "path", "j", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderWindowsRegistryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWindowsRegistryHandler.kt\ncom/jetbrains/rider/protocol/RiderWindowsRegistryHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n13#2:90\n13#3:91\n*S KotlinDebug\n*F\n+ 1 RiderWindowsRegistryHandler.kt\ncom/jetbrains/rider/protocol/RiderWindowsRegistryHandler\n*L\n16#1:90\n16#1:91\n*E\n"})
public final class RiderWindowsRegistryHandler {
    @NotNull
    private final Logger logger;

    public RiderWindowsRegistryHandler() {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RiderWindowsRegistryHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        bl = ApplicationInfo.getInstance().getBuild().isSnapshot();
        if (SystemInfo.isWindows && !ApplicationKt.getApplication().isHeadlessEnvironment() && !bl) {
            try {
                this.j();
            }
            catch (Throwable throwable) {
                this.logger.error("Unable to run update Rider registry key", throwable);
            }
        }
    }

    private final void j() {
        String string;
        String string2;
        String string3;
        block3: {
            string3 = "SOFTWARE\\JetBrains\\Rider";
            string2 = "SOFTWARE\\Wow6432Node\\JetBrains\\Rider";
            try {
                string = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)string3, (String)"");
                Intrinsics.checkNotNull((Object)string);
                if (this.j(string)) {
                    return;
                }
            }
            catch (Win32Exception win32Exception) {
                if (win32Exception.getErrorCode() == 2) break block3;
                throw win32Exception;
            }
        }
        String string4 = BuildNumber.currentVersion().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asStringWithoutProductCode(...)");
        string = string4;
        WinReg.HKEY hKEY = WinReg.HKEY_CURRENT_USER;
        Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_CURRENT_USER");
        this.j(hKEY, string2);
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)string2, (String)"", (String)string);
        WinReg.HKEY hKEY2 = WinReg.HKEY_CURRENT_USER;
        Intrinsics.checkNotNullExpressionValue((Object)hKEY2, (String)"HKEY_CURRENT_USER");
        this.j(hKEY2, string3);
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)string3, (String)"", (String)string);
    }

    private final void j(WinReg.HKEY hKEY, String string) {
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)hKEY, (String)string) || ((CharSequence)string).length() == 0) {
            return;
        }
        int n2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'\\', (int)0, (boolean)false, (int)6, null);
        if (n2 >= 0) {
            String string2 = string.substring(0, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.j(hKEY, string2);
        }
        if (!Advapi32Util.registryCreateKey((WinReg.HKEY)hKEY, (String)string)) {
            throw new IllegalStateException(("Could not create registry key: " + string).toString());
        }
    }

    private final boolean j(String string) {
        if (StringsKt.isBlank((CharSequence)string)) {
            return false;
        }
        BuildNumber buildNumber = BuildNumber.currentVersion();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"currentVersion(...)");
        BuildNumber buildNumber2 = buildNumber;
        BuildNumber buildNumber3 = null;
        try {
            buildNumber3 = BuildNumber.fromString((String)string, null, (String)buildNumber2.getProductCode());
        }
        catch (Throwable throwable) {
            this.logger.warn("Unable to parse build number: " + string, throwable);
            return false;
        }
        if (buildNumber3 == null) {
            this.logger.warn("Unable to parse build number (parse method returned null): " + string);
            return false;
        }
        return buildNumber2.compareTo(buildNumber3) <= 0;
    }
}

