/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.solutionExplorer.rootProviders;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.projectView.ideaInterop.RiderScratchProjectViewPane;
import com.jetbrains.rider.projectView.views.actions.ConfigureScratchesAction;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerRootProvider;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/rootProviders/ScratchRootProvider;", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerRootProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoots", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "settings", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "Companion", "intellij.rider"})
public final class ScratchRootProvider
implements SolutionExplorerRootProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @TestOnly
    @Nullable
    private static Boolean forceShowScratches;

    public ScratchRootProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public List<AbstractTreeNode<?>> getRoots(@NotNull SolutionExplorerViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (Companion.shouldShowScratches(this.project)) {
            AbstractTreeNode<?> abstractTreeNode = RiderScratchProjectViewPane.Companion.createNode(this.project);
            return CollectionsKt.listOf(abstractTreeNode);
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fR\"\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/rootProviders/ScratchRootProvider$Companion;", "", "()V", "forceShowScratches", "", "getForceShowScratches", "()Ljava/lang/Boolean;", "setForceShowScratches", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "shouldShowScratches", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Boolean getForceShowScratches() {
            return forceShowScratches;
        }

        public final void setForceShowScratches(@Nullable Boolean bl) {
            forceShowScratches = bl;
        }

        public final boolean shouldShowScratches(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (this.getForceShowScratches() != null) {
                Boolean bl = this.getForceShowScratches();
                Intrinsics.checkNotNull((Object)bl);
                return bl;
            }
            if (ApplicationKt.getApplication().isUnitTestMode()) {
                return false;
            }
            return ConfigureScratchesAction.Companion.showScratchesInExplorer(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

