/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.solutionExplorer;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.SolutionManager;
import com.jetbrains.rider.projectView.views.SolutionViewPaneBase;
import com.jetbrains.rider.projectView.views.SolutionViewStatistic;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.actions.SolutionViewToggleAction;
import com.jetbrains.rider.projectView.views.search.SolutionSearchFilter;
import com.jetbrains.rider.projectView.views.solutionExplorer.SelectInSolutionExplorerTarget;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerCustomization;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewSettings;
import com.jetbrains.rider.projectView.views.solutionExplorer.nodes.SolutionExplorerModelNode;
import com.jetbrains.rider.projectView.views.solutionExplorer.nodes.SolutionExplorerRootNode;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0002@AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016J\b\u0010.\u001a\u00020*H\u0016J\u0010\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010,H\u0002J\b\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u000200H\u0016J\b\u00108\u001a\u00020\u0006H\u0016J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020!2\u0006\u0010:\u001a\u00020;H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006B"}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewPane;", "Lcom/jetbrains/rider/projectView/views/SolutionViewPaneBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myAutoScrollProjectFiles", "", "getMyAutoScrollProjectFiles", "()Z", "setMyAutoScrollProjectFiles", "(Z)V", "myDiagnosticMode", "getMyDiagnosticMode", "setMyDiagnosticMode", "mySearchDependencies", "getMySearchDependencies", "setMySearchDependencies", "mySettings", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewPane$Settings;", "myShowAllFiles", "getMyShowAllFiles", "setMyShowAllFiles", "myShowProjectImports", "getMyShowProjectImports", "setMyShowProjectImports", "myShowScratches", "getMyShowScratches", "setMyShowScratches", "viewSettings", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "getViewSettings", "()Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "addPrimaryToolbarActions", "", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "addToolbarActions", "createSelectInTarget", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SelectInSolutionExplorerTarget;", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getSearchFilters", "", "Lcom/jetbrains/rider/projectView/views/search/SolutionSearchFilter;", "getTitle", "j", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWeight", "", "initializeTree", "tree", "Ljavax/swing/JTree;", "isAutoScrollEnabledFor", "file", "isInitiallyVisible", "readExternal", "element", "Lorg/jdom/Element;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "writeExternal", "Companion", "Settings", "intellij.rider"})
public final class SolutionExplorerViewPane
extends SolutionViewPaneBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean myShowAllFiles;
    private boolean myShowProjectImports;
    private boolean myDiagnosticMode;
    private boolean myAutoScrollProjectFiles;
    private boolean myShowScratches;
    private boolean mySearchDependencies;
    @NotNull
    private final Settings mySettings;
    @NotNull
    public static final String ID = "SolutionExplorer";
    @Nls
    @NotNull
    private static final String Title = RiderProjectViewBundle.Companion.message("SolutionExplorerViewPane.solution", new Object[0]);
    public static final int Weight = 3;
    @NotNull
    public static final String SHOW_ALL_FILES_OPTION = "show-all-files";
    @NotNull
    public static final String AUTOSCROLL_ALL_OPTION = "autoscroll-all";
    @NotNull
    public static final String SHOW_PROJECT_IMPORTS_OPTION = "show-project-imports";
    @NotNull
    public static final String SHOW_SCRATCHES_OPTION = "show-scratches";
    @NotNull
    public static final String SEARCH_DEPENDENCIES = "search-dependencies";
    @NotNull
    private static final Icon Icon;

    public SolutionExplorerViewPane(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, new SolutionExplorerRootNode(project));
        this.myShowAllFiles = SolutionExplorerViewSettings.Default.INSTANCE.isShowAllFiles();
        this.myShowProjectImports = SolutionExplorerViewSettings.Default.INSTANCE.isShowProjectImports();
        this.myDiagnosticMode = SolutionExplorerViewSettings.Default.INSTANCE.isDiagnosticMode();
        this.myShowScratches = true;
        this.mySettings = new Settings();
    }

    public final boolean getMyShowAllFiles() {
        return this.myShowAllFiles;
    }

    public final void setMyShowAllFiles(boolean bl) {
        this.myShowAllFiles = bl;
    }

    public final boolean getMyShowProjectImports() {
        return this.myShowProjectImports;
    }

    public final void setMyShowProjectImports(boolean bl) {
        this.myShowProjectImports = bl;
    }

    public final boolean getMyDiagnosticMode() {
        return this.myDiagnosticMode;
    }

    public final void setMyDiagnosticMode(boolean bl) {
        this.myDiagnosticMode = bl;
    }

    public final boolean getMyAutoScrollProjectFiles() {
        return this.myAutoScrollProjectFiles;
    }

    public final void setMyAutoScrollProjectFiles(boolean bl) {
        this.myAutoScrollProjectFiles = bl;
    }

    public final boolean getMyShowScratches() {
        return this.myShowScratches;
    }

    public final void setMyShowScratches(boolean bl) {
        this.myShowScratches = bl;
    }

    public final boolean getMySearchDependencies() {
        return this.mySearchDependencies;
    }

    public final void setMySearchDependencies(boolean bl) {
        this.mySearchDependencies = bl;
    }

    @NotNull
    public final SolutionExplorerViewSettings getViewSettings() {
        return this.mySettings;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 3;
    }

    @NotNull
    public String getTitle() {
        return Title;
    }

    @NotNull
    public Icon getIcon() {
        return Icon;
    }

    @NotNull
    public SelectInSolutionExplorerTarget createSelectInTarget() {
        return new SelectInSolutionExplorerTarget(this.getProject());
    }

    public boolean isInitiallyVisible() {
        return !SolutionHostExtensionsKt.isDirectorySolution((Project)this.getProject()) && !SolutionHostExtensionsKt.isTemporarySolution((Project)this.getProject());
    }

    @Override
    public void initializeTree(@NotNull JTree tree2) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        TreeUtil.promiseSelectFirst((JTree)tree2).onSuccess(arg_0 -> SolutionExplorerViewPane.w((Function1)new Function1<TreePath, Unit>((Object)tree2){

            public final void invoke(TreePath p0) {
                ((JTree)this.receiver).expandPath(p0);
            }
        }, arg_0));
    }

    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup2) {
        Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
        if (ApplicationKt.getApplication().isInternal()) {
            actionGroup2.addAction((AnAction)new SolutionViewToggleAction(RiderActionsBundle.Companion.message("action.diagnostic.mode.text", new Object[0]), null, null, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ SolutionExplorerViewPane this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.this$0.getMyDiagnosticMode();
                }
            }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this){
                final /* synthetic */ SolutionExplorerViewPane this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(boolean it) {
                    this.this$0.setMyDiagnosticMode(it);
                }
            }))).setAsSecondary(true);
        }
        super.addToolbarActions(actionGroup2);
        for (SolutionExplorerCustomization solutionExplorerCustomization : SolutionExplorerCustomization.Companion.getExtensions(this.getProject())) {
            solutionExplorerCustomization.addToolbarActions(actionGroup2);
        }
    }

    @Override
    public void addPrimaryToolbarActions(@NotNull DefaultActionGroup actionGroup2) {
        Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
        if (!ExperimentalUI.Companion.isNewUI()) {
            actionGroup2.addAction(ActionManager.getInstance().getAction("ShowAllInSolutionExplorer"));
            actionGroup2.addSeparator();
        }
        super.addPrimaryToolbarActions(actionGroup2);
        for (SolutionExplorerCustomization solutionExplorerCustomization : SolutionExplorerCustomization.Companion.getExtensions(this.getProject())) {
            solutionExplorerCustomization.addPrimaryToolbarActions(actionGroup2);
        }
    }

    @Override
    @NotNull
    public List<SolutionSearchFilter> getSearchFilters() {
        Supplier<String> supplier = RiderProjectViewBundle.Companion.messagePointer("SolutionExplorerViewPane.search.in.dependencies", new Object[0]);
        Icon icon2 = RiderIcons.General.Dependencies;
        return CollectionsKt.listOf((Object)((Object)new SolutionSearchFilter(this, supplier, icon2){
            final /* synthetic */ SolutionExplorerViewPane this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$2);
                super($super_call_param$1, $super_call_param$2);
            }

            public boolean filterOut(@NotNull AbstractTreeNode<?> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                return !this.this$0.getMySearchDependencies() && this.j(node);
            }

            private final boolean j(AbstractTreeNode<?> abstractTreeNode) {
                if (abstractTreeNode instanceof SolutionExplorerModelNode) {
                    ProjectModelEntity projectModelEntity = ((SolutionExplorerModelNode)abstractTreeNode).getEntity();
                    boolean bl = projectModelEntity != null ? ProjectModelEntityExtensionsKt.isDependenciesFolder((ProjectModelEntity)projectModelEntity) : false;
                    if (bl) {
                        return true;
                    }
                }
                for (AbstractTreeNode abstractTreeNode2 = abstractTreeNode.getParent(); abstractTreeNode2 != null; abstractTreeNode2 = abstractTreeNode2.getParent()) {
                    if (!this.j(abstractTreeNode2)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.getMySearchDependencies();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setMySearchDependencies(state);
                SolutionViewStatistic.findPanelSearchDependenciesAction.log((Object)state);
                this.this$0.refreshSearchBar();
            }
        }));
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        DataKey dataKey = VcsDataKeys.VIRTUAL_FILES;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"VIRTUAL_FILES");
        sink.set(dataKey, this.j());
    }

    private final List<VirtualFile> j() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (AbstractTreeNode<?> abstractTreeNode : this.getSelectedNodes()) {
            VirtualFile virtualFile2;
            Object object;
            if (abstractTreeNode instanceof SolutionExplorerModelNode) {
                ProjectModelEntity projectModelEntity = ((SolutionExplorerModelNode)abstractTreeNode).getEntity();
                object = projectModelEntity != null ? ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectModelEntity) : null;
            } else {
                object = SolutionViewUtilsKt.getVirtualFile(abstractTreeNode);
            }
            if ((virtualFile2 = object) == null) continue;
            arrayList.add(virtualFile2);
        }
        return arrayList.isEmpty() ? null : CollectionsKt.toList((Iterable)arrayList);
    }

    public boolean isAutoScrollEnabledFor(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.myAutoScrollProjectFiles && SolutionManager.INSTANCE.isSolutionOrProjectFile(file2)) {
            return FileEditorManager.getInstance((Project)this.getProject()).isFileOpen(file2);
        }
        return super.isAutoScrollEnabledFor(file2);
    }

    public void readExternal(@NotNull Element element) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        SolutionExplorerViewPane solutionExplorerViewPane;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        SolutionExplorerViewPane solutionExplorerViewPane2 = this;
        String string = JDOMExternalizerUtil.readField((Element)element, (String)SHOW_ALL_FILES_OPTION);
        if (string != null) {
            String object2 = string;
            solutionExplorerViewPane = solutionExplorerViewPane2;
            bl7 = false;
            bl6 = Boolean.parseBoolean(object2);
            solutionExplorerViewPane2 = solutionExplorerViewPane;
            bl5 = bl6;
        } else {
            bl5 = SolutionExplorerViewSettings.Default.INSTANCE.isShowAllFiles();
        }
        solutionExplorerViewPane2.myShowAllFiles = bl5;
        SolutionExplorerViewPane solutionExplorerViewPane3 = this;
        String string2 = JDOMExternalizerUtil.readField((Element)element, (String)SHOW_PROJECT_IMPORTS_OPTION);
        if (string2 != null) {
            String string3 = string2;
            solutionExplorerViewPane = solutionExplorerViewPane3;
            bl7 = false;
            bl6 = Boolean.parseBoolean(string3);
            solutionExplorerViewPane3 = solutionExplorerViewPane;
            bl4 = bl6;
        } else {
            bl4 = SolutionExplorerViewSettings.Default.INSTANCE.isShowProjectImports();
        }
        solutionExplorerViewPane3.myShowProjectImports = bl4;
        SolutionExplorerViewPane solutionExplorerViewPane4 = this;
        String string4 = JDOMExternalizerUtil.readField((Element)element, (String)AUTOSCROLL_ALL_OPTION);
        if (string4 != null) {
            String string5 = string4;
            solutionExplorerViewPane = solutionExplorerViewPane4;
            bl7 = false;
            bl6 = Boolean.parseBoolean(string5);
            solutionExplorerViewPane4 = solutionExplorerViewPane;
            bl3 = bl6;
        } else {
            bl3 = false;
        }
        solutionExplorerViewPane4.myAutoScrollProjectFiles = bl3;
        SolutionExplorerViewPane solutionExplorerViewPane5 = this;
        String string6 = JDOMExternalizerUtil.readField((Element)element, (String)SHOW_SCRATCHES_OPTION);
        if (string6 != null) {
            String string7 = string6;
            solutionExplorerViewPane = solutionExplorerViewPane5;
            bl7 = false;
            bl6 = Boolean.parseBoolean(string7);
            solutionExplorerViewPane5 = solutionExplorerViewPane;
            bl2 = bl6;
        } else {
            bl2 = false;
        }
        solutionExplorerViewPane5.myShowScratches = bl2;
        SolutionExplorerViewPane solutionExplorerViewPane6 = this;
        String string8 = JDOMExternalizerUtil.readField((Element)element, (String)SEARCH_DEPENDENCIES);
        if (string8 != null) {
            String string9 = string8;
            solutionExplorerViewPane = solutionExplorerViewPane6;
            bl7 = false;
            bl6 = Boolean.parseBoolean(string9);
            solutionExplorerViewPane6 = solutionExplorerViewPane;
            bl = bl6;
        } else {
            bl = true;
        }
        solutionExplorerViewPane6.mySearchDependencies = bl;
        for (SolutionExplorerCustomization solutionExplorerCustomization : SolutionExplorerCustomization.Companion.getExtensions(this.getProject())) {
            solutionExplorerCustomization.readExternal(element);
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_ALL_FILES_OPTION, (String)String.valueOf(this.myShowAllFiles));
        JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_PROJECT_IMPORTS_OPTION, (String)String.valueOf(this.myShowProjectImports));
        JDOMExternalizerUtil.writeField((Element)element, (String)AUTOSCROLL_ALL_OPTION, (String)String.valueOf(this.myAutoScrollProjectFiles));
        JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_SCRATCHES_OPTION, (String)String.valueOf(this.myShowScratches));
        JDOMExternalizerUtil.writeField((Element)element, (String)SEARCH_DEPENDENCIES, (String)String.valueOf(this.mySearchDependencies));
        for (SolutionExplorerCustomization solutionExplorerCustomization : SolutionExplorerCustomization.Companion.getExtensions(this.getProject())) {
            solutionExplorerCustomization.writeExternal(element);
        }
    }

    private static final void w(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    static {
        Icon icon2 = RiderIcons.Toolwindows.ToolWindowSolutionExplorer;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolWindowSolutionExplorer");
        Icon = icon2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewPane$Companion;", "", "()V", "AUTOSCROLL_ALL_OPTION", "", "ID", "Icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "SEARCH_DEPENDENCIES", "SHOW_ALL_FILES_OPTION", "SHOW_PROJECT_IMPORTS_OPTION", "SHOW_SCRATCHES_OPTION", "Title", "getTitle", "()Ljava/lang/String;", "Weight", "", "getInstance", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewPane;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        @NotNull
        public final Icon getIcon() {
            return Icon;
        }

        @NotNull
        public final SolutionExplorerViewPane getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SolutionExplorerViewPane solutionExplorerViewPane = this.tryGetInstance(project);
            Intrinsics.checkNotNull((Object)((Object)solutionExplorerViewPane));
            return solutionExplorerViewPane;
        }

        @Nullable
        public final SolutionExplorerViewPane tryGetInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDisposed()) {
                return null;
            }
            AbstractProjectViewPane abstractProjectViewPane = ProjectView.getInstance((Project)project).getProjectViewPaneById(SolutionExplorerViewPane.ID);
            return abstractProjectViewPane instanceof SolutionExplorerViewPane ? (SolutionExplorerViewPane)abstractProjectViewPane : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewPane$Settings;", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "(Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewPane;)V", "projectView", "Lcom/intellij/ide/projectView/impl/ProjectViewImpl;", "isDiagnosticMode", "", "isFoldersAlwaysOnTop", "isShowAllFiles", "isShowProjectImports", "intellij.rider"})
    private final class Settings
    implements SolutionExplorerViewSettings {
        @NotNull
        private final ProjectViewImpl projectView;

        public Settings() {
            ProjectView projectView = ProjectView.getInstance((Project)SolutionExplorerViewPane.this.getProject());
            Intrinsics.checkNotNull((Object)projectView, (String)"null cannot be cast to non-null type com.intellij.ide.projectView.impl.ProjectViewImpl");
            this.projectView = (ProjectViewImpl)projectView;
        }

        @Override
        public boolean isFoldersAlwaysOnTop() {
            return this.projectView.isFoldersAlwaysOnTop(SolutionExplorerViewPane.ID);
        }

        @Override
        public boolean isShowAllFiles() {
            return SolutionExplorerViewPane.this.getMyShowAllFiles();
        }

        @Override
        public boolean isShowProjectImports() {
            return SolutionExplorerViewPane.this.getMyShowProjectImports();
        }

        @Override
        public boolean isDiagnosticMode() {
            return SolutionExplorerViewPane.this.getMyDiagnosticMode();
        }
    }
}

