/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.fileSystemExplorer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.fileSystemExplorer.FileSystemExplorerCustomization;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import icons.ReSharperIcons;
import icons.RiderIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode;", "Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "isRoot", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Z)V", "j", "Ljavax/swing/Icon;", "createNode", "virtualFile", "getTestPresentation", "", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFileSystemExplorerNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemExplorerNode.kt\ncom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n13309#2,2:70\n1747#3,3:72\n1747#3,3:75\n*S KotlinDebug\n*F\n+ 1 FileSystemExplorerNode.kt\ncom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode\n*L\n46#1:70,2\n54#1:72,3\n55#1:75,3\n*E\n"})
public final class FileSystemExplorerNode
extends FileSystemNodeBase {
    private final boolean isRoot;

    public FileSystemExplorerNode(@NotNull Project project, @NotNull VirtualFile file2, @NotNull List<NestingNode<VirtualFile>> nestedFiles, boolean isRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        super(project, file2, nestedFiles);
        this.isRoot = isRoot;
    }

    @Override
    @NotNull
    public FileSystemNodeBase createNode(@NotNull VirtualFile virtualFile2, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new FileSystemExplorerNode(project, virtualFile2, nestedFiles, false);
    }

    @Override
    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        if (!this.getFile().isValid()) {
            return;
        }
        presentation2.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.isRoot) {
            SolutionViewUtilsKt.addAdditionalText(presentation2, String.valueOf(PathUtil.getLocalPath((VirtualFile)this.getFile())));
        }
        presentation2.setIcon(this.j());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        SolutionViewUtilsKt.addNonIndexedMark(presentation2, project, this.getVirtualFile());
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        FileSystemExplorerCustomization[] fileSystemExplorerCustomizationArray = FileSystemExplorerCustomization.Companion.getExtensions(project2);
        boolean bl = false;
        int n2 = fileSystemExplorerCustomizationArray.length;
        for (int k = 0; k < n2; ++k) {
            FileSystemExplorerCustomization fileSystemExplorerCustomization;
            FileSystemExplorerCustomization fileSystemExplorerCustomization2 = fileSystemExplorerCustomization = fileSystemExplorerCustomizationArray[k];
            boolean bl2 = false;
            fileSystemExplorerCustomization2.updateNode(presentation2, this.getFile(), this);
        }
    }

    private final Icon j() {
        if (this.getFile().isDirectory()) {
            boolean bl;
            block11: {
                boolean bl2;
                ProjectModelEntity projectModelEntity;
                boolean bl3;
                boolean bl4;
                Iterable iterable;
                List list2;
                block10: {
                    Project project = this.myProject;
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                    WorkspaceModel workspaceModel2 = WorkspaceModel.Companion.getInstance(project);
                    VirtualFile virtualFile2 = this.getFile();
                    Project project2 = this.myProject;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
                    list2 = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel2, (VirtualFile)virtualFile2, (Project)project2);
                    iterable = list2;
                    bl4 = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object t : iterable) {
                            projectModelEntity = (ProjectModelEntity)t;
                            bl2 = false;
                            if (!ProjectModelEntityExtensionsKt.isExistingSolution((ProjectModelEntity)projectModelEntity)) continue;
                            bl3 = true;
                            break block10;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    Icon icon2 = RiderIcons.Nodes.FolderSolution;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FolderSolution");
                    return icon2;
                }
                iterable = list2;
                bl4 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : iterable) {
                        projectModelEntity = (ProjectModelEntity)t;
                        bl2 = false;
                        if (!(ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectModelEntity) || ProjectModelEntityExtensionsKt.isUnloadedProject((ProjectModelEntity)projectModelEntity))) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Icon icon3 = ReSharperIcons.ProjectModel.Projects;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Projects");
                return icon3;
            }
        }
        if (this.isRoot) {
            Icon icon4 = AllIcons.Actions.Menu_open;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Menu_open");
            return icon4;
        }
        VirtualFile virtualFile3 = this.getFile();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return ProjectModelIconsKt.calculateFileSystemIcon((VirtualFile)virtualFile3, (Project)project);
    }

    @Override
    @TestOnly
    @NotNull
    public String getTestPresentation() {
        PresentationData presentationData = new PresentationData();
        this.update(presentationData);
        String string = ((PresentableNodeDescriptor.ColoredFragment)presentationData.getColoredText().get(0)).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

