/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.TreeVisitor;
import com.jetbrains.rider.projectView.views.SolutionViewRootNodeBase;
import com.jetbrains.rider.projectView.views.SolutionViewVisitorByEntity;
import com.jetbrains.rider.projectView.views.SolutionViewVisitorByVirtualFile;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u0003H\u0014J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H$J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewVisitor;", "Lcom/intellij/ui/tree/TreeVisitor;", "findAllPaths", "", "(Z)V", "foundTreePaths", "", "Ljavax/swing/tree/TreePath;", "getFoundTreePaths", "()Ljava/util/List;", "foundTreePathsSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "canMatchSeveralPathsInTree", "visit", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "path", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSolutionViewVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionViewVisitor.kt\ncom/jetbrains/rider/projectView/views/SolutionViewVisitor\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,175:1\n13#2:176\n13#3:177\n*S KotlinDebug\n*F\n+ 1 SolutionViewVisitor.kt\ncom/jetbrains/rider/projectView/views/SolutionViewVisitor\n*L\n21#1:176\n21#1:177\n*E\n"})
public abstract class SolutionViewVisitor
implements TreeVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean findAllPaths;
    @NotNull
    private final HashSet<TreePath> foundTreePathsSet;
    @NotNull
    private static final Logger log;

    public SolutionViewVisitor(boolean findAllPaths) {
        this.findAllPaths = findAllPaths;
        this.foundTreePathsSet = new HashSet();
    }

    public /* synthetic */ SolutionViewVisitor(boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public final List<TreePath> getFoundTreePaths() {
        return CollectionsKt.toList((Iterable)this.foundTreePathsSet);
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        AbstractTreeNode abstractTreeNode;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.getLastPathComponent();
        AbstractTreeNode abstractTreeNode2 = abstractTreeNode = object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null;
        if (abstractTreeNode != null) {
            if (abstractTreeNode instanceof SolutionViewRootNodeBase) {
                log.trace("-> root node: CONTINUE");
                return TreeVisitor.Action.CONTINUE;
            }
            object = this.visit(abstractTreeNode);
            if (object == TreeVisitor.Action.INTERRUPT) {
                this.foundTreePathsSet.add(path);
                if (this.findAllPaths && this.canMatchSeveralPathsInTree()) {
                    log.trace("-> several nodes can be matched by the visitor: CONTINUE instead of INTERRUPT");
                    return TreeVisitor.Action.CONTINUE;
                }
            }
            return object;
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    @NotNull
    protected abstract TreeVisitor.Action visit(@NotNull AbstractTreeNode<?> var1);

    protected boolean canMatchSeveralPathsInTree() {
        return false;
    }

    public SolutionViewVisitor() {
        this(false, 1, null);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(SolutionViewVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewVisitor$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "createForRefresh", "Lcom/jetbrains/rider/projectView/views/SolutionViewVisitor;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "createForSelect", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final SolutionViewVisitor createForRefresh(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            this.getLog().trace("Create refresh visitor for file '" + virtualFile2 + "'");
            return new SolutionViewVisitorByVirtualFile(virtualFile2, true);
        }

        @NotNull
        public final SolutionViewVisitor createForSelect(@NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            this.getLog().trace("Create select visitor for file '" + virtualFile2 + "'");
            return new SolutionViewVisitorByVirtualFile(virtualFile2, false);
        }

        @NotNull
        public final SolutionViewVisitor createForRefresh(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.getLog().trace("Create for entity '" + entity + "'");
            return new SolutionViewVisitorByEntity(entity, true);
        }

        @NotNull
        public final SolutionViewVisitor createForSelect(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.getLog().trace("Create for entity '" + entity + "'");
            return new SolutionViewVisitorByEntity(entity, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

