/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.ProjectViewInplaceCommentProducerImplKt;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.InplaceCommentAppender;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.projectView.ProjectViewOpenedFileLogUsageCollector;
import com.jetbrains.rider.projectView.utils.NavigationUtilKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 )*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001)B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u000fH$J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010 \u001a\u00020\tH\u0014J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020\tH\u0014J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H$\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "T", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "value", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "allowAutoExpand", "", "appendInplaceComments", "", "appender", "Lcom/intellij/ide/util/treeView/InplaceCommentAppender;", "calculateChildren", "", "canNavigate", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "expandOnDoubleClick", "getAllVirtualFiles", "", "getBackgroundColor", "Ljava/awt/Color;", "getChildren", "", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getFileStatusColor", "status", "getVirtualFile", "ignoreFileStatus", "navigate", "requestFocus", "postprocess", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "processDoubleClick", "showInplaceComments", "update", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSolutionViewNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionViewNode.kt\ncom/jetbrains/rider/projectView/views/SolutionViewNode\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n13#2:89\n13#3:90\n*S KotlinDebug\n*F\n+ 1 SolutionViewNode.kt\ncom/jetbrains/rider/projectView/views/SolutionViewNode\n*L\n20#1:89\n20#1:90\n*E\n"})
public abstract class SolutionViewNode<T>
extends AbstractTreeNode<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public SolutionViewNode(@NotNull Project project, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super(project, value);
    }

    @NotNull
    public final Collection<? extends AbstractTreeNode<?>> getChildren() {
        List<AbstractTreeNode<?>> list2 = this.calculateChildren();
        for (AbstractTreeNode<?> abstractTreeNode : list2) {
            abstractTreeNode.setParent((AbstractTreeNode)this);
        }
        return list2;
    }

    @NotNull
    public FileStatus getFileStatus() {
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
            return fileStatus;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (this.ignoreFileStatus()) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
            return fileStatus;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile3);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        return fileStatus;
    }

    @Nullable
    public Color getFileStatusColor(@Nullable FileStatus status) {
        if (this.ignoreFileStatus()) {
            return null;
        }
        return super.getFileStatusColor(status);
    }

    protected boolean ignoreFileStatus() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ProjectViewOpenedFileLogUsageCollector.INSTANCE.logFileManuallyOpen(virtualFile3, project);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        NavigationUtilKt.navigate(virtualFile3, project2, requestFocus);
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @NotNull
    public Set<VirtualFile> getAllVirtualFiles() {
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            return SetsKt.emptySet();
        }
        VirtualFile virtualFile3 = virtualFile2;
        return SetsKt.setOf((Object)virtualFile3);
    }

    public boolean allowAutoExpand() {
        return true;
    }

    public boolean expandOnDoubleClick() {
        VirtualFile virtualFile2 = this.getVirtualFile();
        return virtualFile2 == null || virtualFile2.isDirectory();
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @NotNull
    protected abstract List<AbstractTreeNode<?>> calculateChildren();

    protected abstract void update(@NotNull PresentationData var1);

    protected boolean showInplaceComments() {
        return true;
    }

    protected void appendInplaceComments(@NotNull InplaceCommentAppender appender) {
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        if (this.showInplaceComments() && UISettings.Companion.getInstance().getShowInplaceComments()) {
            ProjectViewInplaceCommentProducerImplKt.appendInplaceComments((InplaceCommentAppender)appender, (Project)this.getProject(), (VirtualFile)this.getVirtualFile());
        }
    }

    protected void postprocess(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        super.postprocess(presentation2);
        presentation2.setBackground(this.getBackgroundColor());
    }

    @Nullable
    public Color getBackgroundColor() {
        return null;
    }

    public boolean processDoubleClick() {
        return false;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(SolutionViewNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewNode$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

