/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.scopes;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J \u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nJ\u001a\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\bH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector$State;", "<set-?>", "", "totalFiles", "getTotalFiles", "()I", "totalMarkedFiles", "getTotalMarkedFiles", "hasMarked", "", "virtualFile", "hasUnmarked", "isMarked", "run", "", "marker", "Lcom/intellij/packageDependencies/ui/Marker;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "total", "j", "parent", "state", "State", "intellij.rider"})
public final class ScopeFilesCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, State> map;
    private int totalFiles;
    private int totalMarkedFiles;

    public ScopeFilesCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.map = new LinkedHashMap();
    }

    public final int getTotalFiles() {
        return this.totalFiles;
    }

    public final int getTotalMarkedFiles() {
        return this.totalMarkedFiles;
    }

    public final void run(@Nullable Marker marker, @NotNull ProgressIndicator indicator, int total) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        if (marker == null) {
            return;
        }
        Ref.IntRef intRef = new Ref.IntRef();
        for (VirtualFile virtualFile2 : BaseProjectDirectories.Companion.getBaseDirectories(this.project)) {
            VfsIterator vfsIterator = VfsIterator.Companion.create(this.project);
            if (vfsIterator == null) continue;
            vfsIterator.visitFileOrDirectoryRecursively(virtualFile2, arg_0 -> ScopeFilesCollector.j(marker, this, intRef, total, indicator, arg_0));
        }
    }

    private final void j(VirtualFile virtualFile2, State state) {
        if (virtualFile2 == null) {
            return;
        }
        State state2 = this.map.get(virtualFile2);
        if (state2 == null) {
            return;
        }
        State state3 = state2;
        if (state3.update(state)) {
            this.j(virtualFile2.getParent(), state);
        }
    }

    public final boolean isMarked(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        State state = this.map.get(virtualFile2);
        return state != null ? state.isMarked() : false;
    }

    public final boolean hasMarked(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        State state = this.map.get(virtualFile2);
        return state != null ? state.getHasMarked() : false;
    }

    public final boolean hasUnmarked(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        State state = this.map.get(virtualFile2);
        return state != null ? state.getHasUnmarked() : false;
    }

    private static final boolean j(Marker marker, ScopeFilesCollector scopeFilesCollector, Ref.IntRef intRef, int n2, ProgressIndicator progressIndicator, VirtualFile virtualFile2) {
        State state;
        Intrinsics.checkNotNullParameter((Object)scopeFilesCollector, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)intRef, (String)"$current");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"fileOrDir");
        boolean bl = marker.isMarked(virtualFile2);
        State state2 = state = new State(bl);
        boolean bl2 = false;
        state2.setHasMarked(bl);
        state2.setHasUnmarked(!bl);
        State state3 = state;
        scopeFilesCollector.map.put(virtualFile2, state3);
        scopeFilesCollector.j(virtualFile2.getParent(), state3);
        if (VirtualFileUtil.isFile((VirtualFile)virtualFile2)) {
            int n3 = scopeFilesCollector.totalFiles;
            scopeFilesCollector.totalFiles = n3 + 1;
            if (bl) {
                n3 = scopeFilesCollector.totalMarkedFiles;
                scopeFilesCollector.totalMarkedFiles = n3 + 1;
            }
        }
        int n4 = intRef.element;
        intRef.element = n4 + 1;
        double d = Math.min((double)intRef.element / (double)n2, 1.0);
        if (progressIndicator instanceof PanelProgressIndicator) {
            ((PanelProgressIndicator)progressIndicator).update(RiderProjectViewBundle.Companion.message("scope.model.builder.progress", new Object[0]), false, d);
        } else {
            progressIndicator.setFraction(d);
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/projectView/scopes/ScopeFilesCollector$State;", "", "isMarked", "", "(Z)V", "hasMarked", "getHasMarked", "()Z", "setHasMarked", "hasUnmarked", "getHasUnmarked", "setHasUnmarked", "update", "state", "intellij.rider"})
    private static final class State {
        private final boolean isMarked;
        private boolean hasMarked;
        private boolean hasUnmarked;

        public State(boolean isMarked) {
            this.isMarked = isMarked;
        }

        public final boolean isMarked() {
            return this.isMarked;
        }

        public final boolean getHasMarked() {
            return this.hasMarked;
        }

        public final void setHasMarked(boolean bl) {
            this.hasMarked = bl;
        }

        public final boolean getHasUnmarked() {
            return this.hasUnmarked;
        }

        public final void setHasUnmarked(boolean bl) {
            this.hasUnmarked = bl;
        }

        public final boolean update(@NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            boolean bl = false;
            if (!this.hasMarked && state.hasMarked) {
                this.hasMarked = true;
                bl = true;
            }
            if (!this.hasUnmarked && state.hasUnmarked) {
                this.hasUnmarked = true;
                bl = true;
            }
            return bl;
        }
    }
}

