/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.scopes;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import com.jetbrains.rider.projectView.scopes.FileSystemNode;
import com.jetbrains.rider.projectView.scopes.ScopeFilesCollector;
import com.jetbrains.rider.projectView.scopes.ScopePatternUtilKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/projectView/scopes/FileSystemTreeModelBuilder;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myMarker", "Lcom/intellij/packageDependencies/ui/Marker;", "settings", "Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/packageDependencies/ui/Marker;Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;)V", "build", "Lcom/intellij/packageDependencies/ui/TreeModel;", "project", "j", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFileSystemTreeModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemTreeModelBuilder.kt\ncom/jetbrains/rider/projectView/scopes/FileSystemTreeModelBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,65:1\n1#2:66\n37#3,2:67\n*S KotlinDebug\n*F\n+ 1 FileSystemTreeModelBuilder.kt\ncom/jetbrains/rider/projectView/scopes/FileSystemTreeModelBuilder\n*L\n33#1:67,2\n*E\n"})
public final class FileSystemTreeModelBuilder {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Marker myMarker;
    @NotNull
    private final DependenciesPanel.DependencyPanelSettings settings;

    public FileSystemTreeModelBuilder(@NotNull Project myProject, @Nullable Marker myMarker, @NotNull DependenciesPanel.DependencyPanelSettings settings) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.myProject = myProject;
        this.myMarker = myMarker;
        this.settings = settings;
    }

    @NotNull
    public final TreeModel build(@NotNull Project project) {
        VirtualFile[] virtualFileArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText(RiderProjectViewBundle.Companion.message("scope.model.builder.progress", new Object[0]));
        progressIndicator.setIndeterminate(true);
        int n2 = this.j(project);
        ScopeFilesCollector scopeFilesCollector = new ScopeFilesCollector(project);
        Intrinsics.checkNotNull((Object)progressIndicator);
        scopeFilesCollector.run(this.myMarker, progressIndicator, n2);
        Set set2 = BaseProjectDirectories.Companion.getBaseDirectories(this.myProject);
        boolean bl = false;
        if (set2.size() == 1) {
            virtualFileArray = ((VirtualFile)CollectionsKt.single((Iterable)set2)).getChildren();
        } else {
            Collection collection = set2;
            boolean bl2 = false;
            Collection collection2 = collection;
            virtualFileArray = collection2.toArray(new VirtualFile[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"let(...)");
        List<VirtualFile> list2 = ScopePatternUtilKt.sortAndFilterScopeChildren(virtualFileArray, scopeFilesCollector, this.settings);
        RootNode rootNode2 = new RootNode(project){

            public void sortChildren() {
            }
        };
        for (VirtualFile virtualFile2 : list2) {
            rootNode2.add((MutableTreeNode)((Object)new FileSystemNode(project, virtualFile2, scopeFilesCollector, this.settings)));
        }
        TreeModel treeModel = new TreeModel((TreeNode)rootNode2);
        treeModel.setTotalFileCount(scopeFilesCollector.getTotalFiles());
        treeModel.setMarkedFileCount(scopeFilesCollector.getTotalMarkedFiles());
        return treeModel;
    }

    private final int j(Project project) {
        Integer n2 = (Integer)project.getUserData(FileTreeModelBuilder.FILE_COUNT);
        if (n2 != null) {
            return n2;
        }
        Ref.IntRef intRef = new Ref.IntRef();
        for (VirtualFile virtualFile2 : BaseProjectDirectories.Companion.getBaseDirectories(this.myProject)) {
            VfsIterator vfsIterator = VfsIterator.Companion.create(project);
            if (vfsIterator == null) continue;
            vfsIterator.visitFileOrDirectoryRecursively(virtualFile2, arg_0 -> FileSystemTreeModelBuilder.j(intRef, arg_0));
        }
        project.putUserData(FileTreeModelBuilder.FILE_COUNT, (Object)intRef.element);
        return intRef.element;
    }

    private static final boolean j(Ref.IntRef intRef, VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)intRef, (String)"$count");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"it");
        int n2 = intRef.element;
        intRef.element = n2 + 1;
        return true;
    }
}

